/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.alloymaker;

import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.silentchaos512.gear.block.alloymaker.AlloyMakerContainer;
import net.silentchaos512.gear.util.TextUtil;

public abstract class AlloyMakerScreen
extends AbstractContainerScreen<AlloyMakerContainer> {
    private Button workButton;
    private boolean lastWorkEnabledValue;

    public AlloyMakerScreen(AlloyMakerContainer screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
    }

    public abstract ResourceLocation getTexture();

    protected void init() {
        super.init();
        this.lastWorkEnabledValue = ((AlloyMakerContainer)this.menu).getWorkEnabled();
        this.workButton = Button.builder((Component)this.getWorkEnabledButtonTitle(), b -> {
            ((AlloyMakerContainer)this.menu).toggleWorkEnabled();
            b.setMessage(this.getWorkEnabledButtonTitle());
        }).bounds(this.leftPos + 70, this.topPos + 60, 50, 20).build();
        this.addWidget((GuiEventListener)this.workButton);
    }

    protected void containerTick() {
        super.containerTick();
        if (((AlloyMakerContainer)this.menu).getWorkEnabled() != this.lastWorkEnabledValue) {
            this.lastWorkEnabledValue = ((AlloyMakerContainer)this.menu).getWorkEnabled();
            this.workButton.setMessage(this.getWorkEnabledButtonTitle());
        }
    }

    @Nonnull
    private Component getWorkEnabledButtonTitle() {
        MutableComponent text = TextUtil.misc(((AlloyMakerContainer)this.menu).getWorkEnabled() ? "on" : "off", new Object[0]);
        return TextUtil.translate("block", "alloy_maker.workEnabled", text);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.workButton.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int x, int y) {
        if (this.minecraft == null) {
            return;
        }
        ResourceLocation texture = this.getTexture();
        RenderSystem.clearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        int posX = (this.width - this.imageWidth) / 2;
        int posY = (this.height - this.imageHeight) / 2;
        graphics.blit(texture, posX, posY, 0, 0, this.imageWidth, this.imageHeight);
        graphics.blit(texture, posX + 93, posY + 34, 176, 14, ((AlloyMakerContainer)this.menu).getProgressArrowScale() + 1, 16);
    }
}

