/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.Tags;
import net.silentchaos512.gear.util.TextUtil;

public class ModOreBlock
extends DropExperienceBlock {
    public ModOreBlock(IntProvider xpDrop, BlockBehaviour.Properties properties) {
        super(xpDrop, properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flagIn) {
        int harvestLevel = ModOreBlock.guessHarvestLevel(this.defaultBlockState());
        MutableComponent harvestLevelName = TextUtil.misc("harvestLevel." + harvestLevel, new Object[0]);
        tooltip.add((Component)TextUtil.misc("harvestLevel", harvestLevelName));
    }

    private static int guessHarvestLevel(BlockState state) {
        if (state.is(Tags.Blocks.NEEDS_NETHERITE_TOOL)) {
            return 4;
        }
        if (state.is(BlockTags.NEEDS_DIAMOND_TOOL)) {
            return 3;
        }
        if (state.is(BlockTags.NEEDS_IRON_TOOL)) {
            return 2;
        }
        if (state.is(BlockTags.NEEDS_STONE_TOOL)) {
            return 1;
        }
        return 0;
    }
}

