/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.material;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterialCategory;
import net.silentchaos512.gear.api.material.MaterialSerializer;
import net.silentchaos512.gear.api.material.TextureType;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.util.GearComponent;
import net.silentchaos512.gear.api.util.PropertyKey;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.setup.SgRegistries;

public interface Material
extends GearComponent<MaterialInstance> {
    public String getPackName();

    public MaterialSerializer<?> getSerializer();

    @Nullable
    public Material getParent();

    default public Optional<Material> getParentOptional() {
        return Optional.ofNullable(this.getParent());
    }

    @Deprecated
    default public Collection<IMaterialCategory> getCategories() {
        return this.getCategories(MaterialInstance.of(this));
    }

    public Collection<IMaterialCategory> getCategories(MaterialInstance var1);

    public boolean isInCategory(IMaterialCategory var1);

    public Optional<Ingredient> getPartSubstitute(PartType var1);

    public boolean hasPartSubstitutes();

    public boolean canSalvage();

    public MaterialInstance onSalvage(MaterialInstance var1);

    public boolean isSimple();

    public boolean isValid();

    public Set<PartType> getPartTypes(MaterialInstance var1);

    public boolean isAllowedInPart(MaterialInstance var1, PartType var2);

    default public boolean canRepair(MaterialInstance partMaterial) {
        return this.equals(partMaterial.get());
    }

    default public void retainData(@Nullable Material oldMaterial) {
    }

    public Collection<PropertyKey<?, ?>> getPropertyKeys(MaterialInstance var1, PartType var2);

    default public Component getBaseMaterialName(@Nullable MaterialInstance material, PartType partType) {
        return this.getDisplayName(material, partType);
    }

    public Component getDisplayNamePrefix(PartType var1);

    public TextureType getMainTextureType(MaterialInstance var1);

    public int getColor(MaterialInstance var1, PartType var2, GearType var3);

    public int getNameColor(MaterialInstance var1, PartType var2, GearType var3);

    default public String getModelKey(MaterialInstance material) {
        return SilentGear.shortenId(SgRegistries.MATERIAL.getKey(this));
    }

    default public ItemStack getDisplayItem(PartType type, int ticks) {
        ItemStack[] stacks = this.getIngredient().getItems();
        if (stacks.length == 0) {
            return ItemStack.EMPTY;
        }
        return stacks[ticks / 20 % stacks.length];
    }
}

