/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.shadowmounts_common_neoforge.mixin;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.natamus.shadowmounts_common_neoforge.rendering.ShadowMountRenderFunctions;
import com.natamus.shadowmounts_common_neoforge.util.Util;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntityRenderer.class}, priority=1001)
public abstract class LivingEntityRendererMixin {
    @Shadow
    protected EntityModel<LivingEntity> model;
    @Shadow
    protected final List<RenderLayer<LivingEntity, EntityModel<LivingEntity>>> layers = Lists.newArrayList();

    @Shadow
    protected abstract RenderType getRenderType(LivingEntity var1, boolean var2, boolean var3, boolean var4);

    @Shadow
    protected abstract float getWhiteOverlayProgress(LivingEntity var1, float var2);

    @Shadow
    protected abstract void setupRotations(LivingEntity var1, PoseStack var2, float var3, float var4, float var5, float var6);

    @Shadow
    protected abstract void scale(LivingEntity var1, PoseStack var2, float var3);

    @Inject(method={"render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="TAIL")})
    public void render(LivingEntity livingEntity, float livingEntityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, CallbackInfo ci) {
        Direction direction;
        float i;
        Entity var11;
        Optional<Player> optionalPlayer;
        if (!(livingEntity instanceof AbstractHorse)) {
            return;
        }
        AbstractHorse abstractHorse = (AbstractHorse)livingEntity;
        if (!Util.wearsShadowSaddle(abstractHorse)) {
            return;
        }
        Player player = null;
        List passengers = abstractHorse.getPassengers();
        if (!passengers.isEmpty() && (optionalPlayer = passengers.stream().filter(passenger -> passenger instanceof Player).map(passenger -> (Player)passenger).findFirst()).isPresent()) {
            player = optionalPlayer.get();
        }
        poseStack.pushPose();
        this.model.attackTime = livingEntity.getAttackAnim(partialTicks);
        this.model.riding = livingEntity.isPassenger();
        this.model.young = livingEntity.isBaby();
        float f = Mth.rotLerp((float)partialTicks, (float)livingEntity.yBodyRotO, (float)livingEntity.yBodyRot);
        float g = Mth.rotLerp((float)partialTicks, (float)livingEntity.yHeadRotO, (float)livingEntity.yHeadRot);
        float h = g - f;
        if (livingEntity.isPassenger() && (var11 = livingEntity.getVehicle()) instanceof LivingEntity) {
            LivingEntity passengerlivingEntity = (LivingEntity)var11;
            f = Mth.rotLerp((float)partialTicks, (float)passengerlivingEntity.yBodyRotO, (float)passengerlivingEntity.yBodyRot);
            h = g - f;
            i = Mth.wrapDegrees((float)h);
            if (i < -85.0f) {
                i = -85.0f;
            }
            if (i >= 85.0f) {
                i = 85.0f;
            }
            f = g - i;
            if (i * i > 2500.0f) {
                f += i * 0.2f;
            }
            h = g - f;
        }
        float j = Mth.lerp((float)partialTicks, (float)livingEntity.xRotO, (float)livingEntity.getXRot());
        if (LivingEntityRenderer.isEntityUpsideDown((LivingEntity)livingEntity)) {
            j *= -1.0f;
            h *= -1.0f;
        }
        h = Mth.wrapDegrees((float)h);
        if (livingEntity.hasPose(Pose.SLEEPING) && (direction = livingEntity.getBedOrientation()) != null) {
            float k = livingEntity.getEyeHeight(Pose.STANDING) - 0.1f;
            poseStack.translate((float)(-direction.getStepX()) * k, 0.0f, (float)(-direction.getStepZ()) * k);
        }
        i = livingEntity.getScale();
        poseStack.scale(i, i, i);
        float k = (float)livingEntity.tickCount + partialTicks;
        this.setupRotations(livingEntity, poseStack, k, f, partialTicks, i);
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        this.scale(livingEntity, poseStack, partialTicks);
        poseStack.translate(0.0f, -1.501f, 0.0f);
        float l = 0.0f;
        float m = 0.0f;
        if (!livingEntity.isPassenger() && livingEntity.isAlive()) {
            l = livingEntity.walkAnimation.speed(partialTicks);
            m = livingEntity.walkAnimation.position(partialTicks);
            if (livingEntity.isBaby()) {
                m *= 3.0f;
            }
            if (l > 1.0f) {
                l = 1.0f;
            }
        }
        this.model.prepareMobModel((Entity)livingEntity, m, l, partialTicks);
        this.model.setupAnim((Entity)livingEntity, m, l, k, h, j);
        Minecraft minecraft = Minecraft.getInstance();
        boolean bl = !livingEntity.isInvisible();
        boolean bl2 = !bl && !livingEntity.isInvisibleTo((Player)minecraft.player);
        boolean bl3 = minecraft.shouldEntityAppearGlowing((Entity)livingEntity);
        RenderType renderType = this.getRenderType(livingEntity, bl, bl2, bl3);
        if (renderType != null) {
            VertexConsumer vertexConsumer = multiBufferSource.getBuffer(renderType);
            int overlayCoords = LivingEntityRenderer.getOverlayCoords((LivingEntity)livingEntity, (float)this.getWhiteOverlayProgress(livingEntity, partialTicks));
            ShadowMountRenderFunctions.renderDarkerToBuffer(this.model, poseStack, vertexConsumer, packedLight, overlayCoords);
        }
        if (!livingEntity.isSpectator()) {
            for (RenderLayer<LivingEntity, EntityModel<LivingEntity>> layer : this.layers) {
                layer.render(poseStack, multiBufferSource, packedLight, (Entity)livingEntity, m, l, partialTicks, k, h, j);
            }
        }
        poseStack.popPose();
        ShadowMountRenderFunctions.renderTrailingParticles(abstractHorse, player);
    }

    @ModifyVariable(method={"render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/client/renderer/entity/LivingEntityRenderer;getRenderType(Lnet/minecraft/world/entity/LivingEntity;ZZZ)Lnet/minecraft/client/renderer/RenderType;"))
    public RenderType modifyRenderType(RenderType originalRenderType, LivingEntity livingEntity, float livingEntityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        AbstractHorse abstractHorse;
        if (livingEntity instanceof AbstractHorse && Util.wearsShadowSaddle(abstractHorse = (AbstractHorse)livingEntity)) {
            return null;
        }
        return originalRenderType;
    }
}

