/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.shadowmounts_common_neoforge.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.natamus.shadowmounts_common_neoforge.rendering.ShadowMountRenderFunctions;
import com.natamus.shadowmounts_common_neoforge.util.Util;
import java.util.Map;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HorseMarkingLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Markings;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HorseMarkingLayer.class}, priority=1001)
public abstract class HorseMarkingLayerMixin
extends RenderLayer<Horse, HorseModel<Horse>> {
    @Shadow
    @Final
    private static Map<Markings, ResourceLocation> LOCATION_BY_MARKINGS;

    public HorseMarkingLayerMixin(RenderLayerParent<Horse, HorseModel<Horse>> renderLayerParent) {
        super(renderLayerParent);
    }

    @Inject(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/world/entity/animal/horse/Horse;FFFFFF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/MultiBufferSource;getBuffer(Lnet/minecraft/client/renderer/RenderType;)Lcom/mojang/blaze3d/vertex/VertexConsumer;")}, cancellable=true)
    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Horse horse, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        if (!(horse instanceof AbstractHorse)) {
            return;
        }
        Horse abstractHorse = horse;
        if (!Util.wearsShadowSaddle((AbstractHorse)abstractHorse)) {
            return;
        }
        ResourceLocation resourceLocation = LOCATION_BY_MARKINGS.get(horse.getMarkings());
        if (resourceLocation == null) {
            return;
        }
        String resourceLocationPath = resourceLocation.getPath();
        ResourceLocation shadowResourceLocation = ResourceLocation.fromNamespaceAndPath((String)"shadowmounts", (String)resourceLocationPath.replace("horse_", "shadow_horse_"));
        ShadowMountRenderFunctions.renderLayerDarkerToBuffer(this.getParentModel(), poseStack, buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)shadowResourceLocation)), packedLight, LivingEntityRenderer.getOverlayCoords((LivingEntity)horse, (float)0.0f));
        ci.cancel();
    }
}

