/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.shadowmounts_common_neoforge.mixin;

import com.natamus.collective_common_neoforge.functions.EntityFunctions;
import com.natamus.shadowmounts_common_neoforge.data.ShadowItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractHorse.class}, priority=1001)
public abstract class AbstractHorseMixin {
    @Shadow
    protected SimpleContainer inventory;

    @Shadow
    protected abstract void setFlag(int var1, boolean var2);

    @Inject(method={"equipSaddle(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/sounds/SoundSource;)V"}, at={@At(value="TAIL")})
    public void equipSaddle(ItemStack itemStack, SoundSource soundSource, CallbackInfo ci) {
        this.setFlag(128, itemStack.getItem().equals(ShadowItems.SHADOW_SADDLE));
    }

    @Inject(method={"containerChanged(Lnet/minecraft/world/Container;)V"}, at={@At(value="TAIL")})
    public void containerChanged(Container container, CallbackInfo ci) {
        this.setFlag(128, this.inventory.getItem(0).getItem().equals(ShadowItems.SHADOW_SADDLE));
    }

    @Inject(method={"createInventory()V"}, at={@At(value="TAIL")})
    protected void createInventory(CallbackInfo ci) {
        if (EntityFunctions.getAbstractHorseEntityFlagResult((AbstractHorse)((AbstractHorse)this), (int)128)) {
            this.inventory.setItem(0, new ItemStack((ItemLike)ShadowItems.SHADOW_SADDLE));
        }
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    public void addAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        boolean wearsShadowSaddle = this.inventory.getItem(0).getItem().equals(ShadowItems.SHADOW_SADDLE) || EntityFunctions.getAbstractHorseEntityFlagResult((AbstractHorse)((AbstractHorse)this), (int)128);
        compoundTag.putBoolean("WearsShadowSaddle", wearsShadowSaddle);
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/animal/horse/AbstractHorse;syncSaddleToClients()V")})
    public void readAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        if (compoundTag.contains("WearsShadowSaddle") && compoundTag.getBoolean("WearsShadowSaddle")) {
            this.inventory.setItem(0, new ItemStack((ItemLike)ShadowItems.SHADOW_SADDLE));
            this.setFlag(128, true);
        }
    }
}

