/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.shadowmounts_common_fabric.rendering;

import com.mojang.datafixers.util.Pair;
import com.natamus.shadowmounts_common_fabric.config.ConfigHandler;
import com.natamus.shadowmounts_common_fabric.data.Constants;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1496;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_583;

public class ShadowMountRenderFunctions {
    private static final List<Pair<class_2400, Integer>> trailParticles = Arrays.asList(new Pair((Object)class_2398.field_22247, (Object)1), new Pair((Object)class_2398.field_22248, (Object)8), new Pair((Object)class_2398.field_22246, (Object)32), new Pair((Object)class_2398.field_11239, (Object)64));

    public static void renderDarkerToBuffer(class_583<?> entityModel, class_4587 poseStack, class_4588 vertexConsumer, int packedLight, int overlayCoords) {
        if (ConfigHandler.darkenHorseTexture) {
            entityModel.method_2828(poseStack, vertexConsumer, packedLight / 5, overlayCoords, Constants.shadowMountColour);
            return;
        }
        entityModel.method_60879(poseStack, vertexConsumer, packedLight, overlayCoords);
    }

    public static void renderLayerDarkerToBuffer(class_583<?> entityModel, class_4587 poseStack, class_4588 vertexConsumer, int packedLight, int overlayCoords) {
        if (ConfigHandler.darkenHorseTexture) {
            entityModel.method_2828(poseStack, vertexConsumer, packedLight, overlayCoords, Constants.shadowMountMarkingsColour);
            return;
        }
        entityModel.method_60879(poseStack, vertexConsumer, packedLight, overlayCoords);
    }

    public static void renderTrailingParticles(class_1496 abstractHorse, @Nullable class_1657 player) {
        if (!ConfigHandler.showShadowHorseParticles) {
            return;
        }
        class_1937 level = abstractHorse.method_37908();
        if (!level.field_9236) {
            return;
        }
        if (player == null && ConfigHandler.onlyShowParticlesWhenRiding) {
            return;
        }
        double particleBehindoffsetDistance = -1.0;
        float yRot = abstractHorse.method_36454() * ((float)Math.PI / 180);
        double xBaseOffset = particleBehindoffsetDistance * -Math.sin(yRot);
        double zBaseOffset = particleBehindoffsetDistance * Math.cos(yRot);
        double xBaseParticleVelocity = Math.sin(yRot) * 0.1;
        double zBaseParticleVelocity = -Math.cos(yRot) * 0.1;
        boolean isMoving = abstractHorse.method_18798().method_37268() > 1.0E-4;
        for (Pair<class_2400, Integer> particlePair : trailParticles) {
            int tickDelay = (Integer)particlePair.getSecond();
            if ((!isMoving || tickDelay != 32) && abstractHorse.field_6012 % tickDelay != 0) continue;
            class_2400 particle = (class_2400)particlePair.getFirst();
            double randomXOffset = xBaseOffset + (Constants.random.nextDouble() - 0.5) * 0.2;
            double randomYOffset = 0.5 + (Constants.random.nextDouble() - 0.5) * 0.2;
            double randomZOffset = zBaseOffset + (Constants.random.nextDouble() - 0.5) * 0.2;
            double xRandomParticleVelocity = xBaseParticleVelocity + (Constants.random.nextDouble() - 0.5) * 0.02;
            double zrandomParticleVelocity = zBaseParticleVelocity + (Constants.random.nextDouble() - 0.5) * 0.02;
            level.method_8406((class_2394)particle, abstractHorse.method_23317() + randomXOffset, abstractHorse.method_23318() + randomYOffset, abstractHorse.method_23321() + randomZOffset, xRandomParticleVelocity, -abstractHorse.method_18798().field_1351 * 0.5, zrandomParticleVelocity);
        }
    }
}

