/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.features.roadlogic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.countered.settlementroads.features.roadlogic.RoadDirection;
import net.countered.settlementroads.helpers.Records;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_5539;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoadPathCalculator {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"settlement-roads");
    private static final int neighborDistance = 4;
    public static final Map<Long, Integer> heightCache = new ConcurrentHashMap<Long, Integer>();

    private static long hashXZ(int x, int z) {
        return (long)x << 32 | (long)z & 0xFFFFFFFFL;
    }

    public static List<Records.RoadSegmentPlacement> calculateAStarRoadPath(class_2338 start, class_2338 end, int width, class_3218 serverWorld, int maxSteps) {
        PriorityQueue<Node> openSet = new PriorityQueue<Node>(Comparator.comparingDouble(n -> n.fScore));
        HashMap<class_2338, Node> allNodes = new HashMap<class_2338, Node>();
        HashSet<class_2338> closedSet = new HashSet<class_2338>();
        HashMap<class_2338, List<class_2338>> interpolatedSegments = new HashMap<class_2338, List<class_2338>>();
        int startX = RoadPathCalculator.snapToGrid(start.method_10263(), 4);
        int startZ = RoadPathCalculator.snapToGrid(start.method_10260(), 4);
        int endX = RoadPathCalculator.snapToGrid(end.method_10263(), 4);
        int endZ = RoadPathCalculator.snapToGrid(end.method_10260(), 4);
        start = new class_2338(startX, start.method_10264(), startZ);
        end = new class_2338(endX, end.method_10264(), endZ);
        class_2338 startGround = new class_2338(start.method_10263(), RoadPathCalculator.heightSampler(start.method_10263(), start.method_10260(), serverWorld), start.method_10260());
        class_2338 endGround = new class_2338(end.method_10263(), RoadPathCalculator.heightSampler(end.method_10263(), end.method_10260(), serverWorld), end.method_10260());
        Node startNode = new Node(startGround, null, 0.0, RoadPathCalculator.heuristic(startGround, endGround));
        openSet.add(startNode);
        allNodes.put(startGround, startNode);
        int d = 4;
        int[][] neighborOffsets = new int[][]{{d, 0}, {-d, 0}, {0, d}, {0, -d}, {d, d}, {d, -d}, {-d, d}, {-d, -d}};
        while (!openSet.isEmpty() && maxSteps-- > 0) {
            Node current = openSet.poll();
            if (current.pos.method_33096(0).method_19455((class_2382)endGround.method_33096(0)) < 8) {
                LOGGER.debug("Found path! " + String.valueOf(current.pos));
                return RoadPathCalculator.reconstructPath(current, width, interpolatedSegments);
            }
            closedSet.add(current.pos);
            allNodes.remove(current.pos);
            for (int[] offset : neighborOffsets) {
                class_2338 neighborXZ = current.pos.method_10069(offset[0], 0, offset[1]);
                int y = RoadPathCalculator.heightSampler(neighborXZ.method_10263(), neighborXZ.method_10260(), serverWorld);
                class_2338 neighborPos = new class_2338(neighborXZ.method_10263(), y, neighborXZ.method_10260());
                if (closedSet.contains(neighborPos)) continue;
                class_6880<class_1959> biomeRegistryEntry = RoadPathCalculator.biomeSampler(neighborPos, serverWorld);
                int biomeCost = biomeRegistryEntry.method_40220(class_6908.field_36511) || biomeRegistryEntry.method_40220(class_6908.field_36509) || biomeRegistryEntry.method_40220(class_6908.field_36508) ? 50 : 0;
                int elevation = Math.abs(y - current.pos.method_10264());
                if (elevation > 3) continue;
                int offsetSum = Math.abs(Math.abs(offset[0])) + Math.abs(offset[1]);
                double stepCost = offsetSum == 8 ? 1.5 : 1.0;
                int terrainStabilityCost = RoadPathCalculator.calculateTerrainStability(neighborPos, y, serverWorld);
                if (terrainStabilityCost > 2) continue;
                int yLevelCost = y == 62 ? 20 : 0;
                double tentativeG = current.gScore + stepCost + (double)(elevation * 40) + (double)(biomeCost * 8) + (double)(yLevelCost * 8) + (double)(terrainStabilityCost * 16);
                Node neighbor = (Node)allNodes.get(neighborPos);
                if (neighbor != null && !(tentativeG < neighbor.gScore)) continue;
                double h = RoadPathCalculator.heuristic(neighborPos, endGround);
                neighbor = new Node(neighborPos, current, tentativeG, tentativeG + h);
                allNodes.put(neighborPos, neighbor);
                openSet.add(neighbor);
                ArrayList<class_2338> segmentPoints = new ArrayList<class_2338>();
                for (int i = 1; i < 4; ++i) {
                    int interpX = current.pos.method_10263() + offset[0] * i / 4;
                    int interpZ = current.pos.method_10260() + offset[1] * i / 4;
                    class_2338 interpolated = new class_2338(interpX, current.pos.method_10264(), interpZ);
                    segmentPoints.add(interpolated);
                }
                interpolatedSegments.put(neighborPos, segmentPoints);
            }
        }
        return Collections.emptyList();
    }

    private static double heuristic(class_2338 a, class_2338 b) {
        int dx = a.method_10263() - b.method_10263();
        int dz = a.method_10260() - b.method_10260();
        double dxzApprox = (double)(Math.abs(dx) + Math.abs(dz)) - 0.6 * (double)Math.min(Math.abs(dx), Math.abs(dz));
        return dxzApprox * 30.0;
    }

    private static int calculateTerrainStability(class_2338 neighborPos, int y, class_3218 serverWorld) {
        int cost = 0;
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2338 testPos = neighborPos.method_10093(direction);
            int testY = RoadPathCalculator.heightSampler(testPos.method_10263(), testPos.method_10260(), serverWorld);
            int elevation = Math.abs(y - testY);
            if ((cost += elevation) <= 2) continue;
            return Integer.MAX_VALUE;
        }
        return cost;
    }

    private static List<Records.RoadSegmentPlacement> reconstructPath(Node endNode, int width, Map<class_2338, List<class_2338>> interpolatedPathMap) {
        ArrayList<Node> pathNodes = new ArrayList<Node>();
        Node current = endNode;
        while (current != null) {
            pathNodes.add(current);
            current = current.parent;
        }
        Collections.reverse(pathNodes);
        LinkedHashMap<class_2338, Set<class_2338>> roadSegments = new LinkedHashMap<class_2338, Set<class_2338>>();
        HashSet<class_2338> widthCache = new HashSet<class_2338>();
        for (Node node : pathNodes) {
            class_2338 pos = node.pos;
            List interpolated = interpolatedPathMap.getOrDefault(pos, Collections.emptyList());
            RoadDirection roadDirection = RoadDirection.X_AXIS;
            if (!interpolated.isEmpty()) {
                class_2338 firstInterpolated = (class_2338)interpolated.get(0);
                int dx = pos.method_10263() - firstInterpolated.method_10263();
                int dz = pos.method_10260() - firstInterpolated.method_10260();
                if (dx < 0 && dz > 0 || dx > 0 && dz < 0) {
                    roadDirection = RoadDirection.DIAGONAL_1;
                } else if (dx < 0 && dz < 0 || dx > 0 && dz > 0) {
                    roadDirection = RoadDirection.DIAGONAL_2;
                } else if (dx == 0 && dz != 0) {
                    roadDirection = RoadDirection.Z_AXIS;
                }
                for (class_2338 interp : interpolated) {
                    Set<class_2338> widthSetInterp = RoadPathCalculator.generateWidth(interp, width / 2, widthCache, roadDirection);
                    roadSegments.put(interp, widthSetInterp);
                }
            }
            Set<class_2338> widthSet = RoadPathCalculator.generateWidth(pos, width / 2, widthCache, roadDirection);
            roadSegments.put(pos, widthSet);
        }
        ArrayList<Records.RoadSegmentPlacement> result = new ArrayList<Records.RoadSegmentPlacement>();
        for (Map.Entry entry : roadSegments.entrySet()) {
            result.add(new Records.RoadSegmentPlacement((class_2338)entry.getKey(), new ArrayList<class_2338>((Collection)entry.getValue())));
        }
        return result;
    }

    private static int heightSampler(int x, int z, class_3218 serverWorld) {
        long key = RoadPathCalculator.hashXZ(x, z);
        return heightCache.computeIfAbsent(key, k -> serverWorld.method_14178().method_12129().method_18028(x, z, class_2902.class_2903.field_13194, (class_5539)serverWorld, serverWorld.method_14178().method_41248()));
    }

    private static class_6880<class_1959> biomeSampler(class_2338 pos, class_3218 serverWorld) {
        return serverWorld.method_23753(pos);
    }

    private static int snapToGrid(int value, int gridSize) {
        return Math.floorDiv(value, gridSize) * gridSize;
    }

    private static Set<class_2338> generateWidth(class_2338 center, int radius, Set<class_2338> widthPositionsCache, RoadDirection direction) {
        HashSet<class_2338> segmentWidthPositions = new HashSet<class_2338>();
        int centerX = center.method_10263();
        int centerZ = center.method_10260();
        int y = 0;
        if (direction == RoadDirection.X_AXIS) {
            for (int dz = -radius; dz <= radius; ++dz) {
                class_2338 pos = new class_2338(centerX, y, centerZ + dz);
                if (widthPositionsCache.contains(pos)) continue;
                widthPositionsCache.add(pos);
                segmentWidthPositions.add(pos);
            }
        } else if (direction == RoadDirection.Z_AXIS) {
            for (int dx = -radius; dx <= radius; ++dx) {
                class_2338 pos = new class_2338(centerX + dx, y, centerZ);
                if (widthPositionsCache.contains(pos)) continue;
                widthPositionsCache.add(pos);
                segmentWidthPositions.add(pos);
            }
        } else {
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    class_2338 pos;
                    if (direction == RoadDirection.DIAGONAL_2 && (dx == -radius && dz == -radius || dx == radius && dz == radius) || direction == RoadDirection.DIAGONAL_1 && (dx == -radius && dz == radius || dx == radius && dz == -radius) || widthPositionsCache.contains(pos = new class_2338(centerX + dx, y, centerZ + dz))) continue;
                    widthPositionsCache.add(pos);
                    segmentWidthPositions.add(pos);
                }
            }
        }
        return segmentWidthPositions;
    }

    private static class Node {
        class_2338 pos;
        Node parent;
        double gScore;
        double fScore;

        Node(class_2338 pos, Node parent, double gScore, double fScore) {
            this.pos = pos;
            this.parent = parent;
            this.gScore = gScore;
            this.fScore = fScore;
        }
    }
}

