/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.events;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.countered.settlementroads.config.ModConfig;
import net.countered.settlementroads.features.RoadFeature;
import net.countered.settlementroads.features.config.RoadFeatureConfig;
import net.countered.settlementroads.features.roadlogic.Road;
import net.countered.settlementroads.features.roadlogic.RoadPathCalculator;
import net.countered.settlementroads.helpers.Records;
import net.countered.settlementroads.helpers.StructureConnector;
import net.countered.settlementroads.persistence.attachments.WorldDataAttachment;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2975;
import net.minecraft.class_3037;
import net.minecraft.class_3218;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModEventHandler {
    private static final int THREAD_COUNT = 7;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"settlement-roads");
    private static ExecutorService executor = Executors.newFixedThreadPool(7);
    private static final ConcurrentHashMap<String, Future<?>> runningTasks = new ConcurrentHashMap();

    public static void register() {
        ServerWorldEvents.LOAD.register((server, serverWorld) -> {
            ModEventHandler.restartExecutorIfNeeded();
            if (!serverWorld.method_27983().equals(class_1937.field_25179)) {
                return;
            }
            Records.StructureLocationData structureLocationData = (Records.StructureLocationData)serverWorld.getAttachedOrCreate(WorldDataAttachment.STRUCTURE_LOCATIONS, () -> new Records.StructureLocationData(new ArrayList<class_2338>()));
            if (structureLocationData.structureLocations().size() < ModConfig.initialLocatingCount) {
                for (int i = 0; i < ModConfig.initialLocatingCount; ++i) {
                    StructureConnector.cacheNewConnection(serverWorld, false);
                    ModEventHandler.tryGenerateNewRoads(serverWorld, true, 5000);
                }
            }
        });
        ServerWorldEvents.UNLOAD.register((server, serverWorld) -> {
            if (!serverWorld.method_27983().equals(class_1937.field_25179)) {
                return;
            }
            Future<?> task = runningTasks.remove(serverWorld.method_27983().method_29177().toString());
            if (task != null && !task.isDone()) {
                task.cancel(true);
                LOGGER.debug("Aborted running road task for world: {}", (Object)serverWorld.method_27983().method_29177());
            }
        });
        ServerTickEvents.START_WORLD_TICK.register(serverWorld -> {
            if (!serverWorld.method_27983().equals(class_1937.field_25179)) {
                return;
            }
            ModEventHandler.tryGenerateNewRoads(serverWorld, true, 5000);
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            RoadPathCalculator.heightCache.clear();
            runningTasks.values().forEach(future -> future.cancel(true));
            runningTasks.clear();
            executor.shutdownNow();
            LOGGER.debug("SettlementRoads: ExecutorService shut down.");
        });
    }

    private static void tryGenerateNewRoads(class_3218 serverWorld, Boolean async, int steps) {
        if (!StructureConnector.cachedStructureConnections.isEmpty()) {
            class_3037 class_30372;
            Records.StructureConnection structureConnection = StructureConnector.cachedStructureConnections.poll();
            class_2975 feature = (class_2975)serverWorld.method_30349().method_30530(class_7924.field_41239).method_29107(RoadFeature.ROAD_FEATURE_KEY);
            if (feature != null && (class_30372 = feature.comp_333()) instanceof RoadFeatureConfig) {
                RoadFeatureConfig roadConfig = (RoadFeatureConfig)class_30372;
                if (async.booleanValue()) {
                    Future<?> future = executor.submit(() -> {
                        try {
                            new Road(serverWorld, structureConnection, roadConfig).generateRoad(steps);
                        }
                        catch (Exception e) {
                            LOGGER.error("Error generating road", (Throwable)e);
                        }
                    });
                    runningTasks.put(serverWorld.method_27983().method_29177().toString(), future);
                } else {
                    new Road(serverWorld, structureConnection, roadConfig).generateRoad(steps);
                }
            }
        }
    }

    private static void restartExecutorIfNeeded() {
        if (executor.isShutdown() || executor.isTerminated()) {
            executor = Executors.newFixedThreadPool(7);
            LOGGER.debug("SettlementRoads: ExecutorService restarted.");
        }
    }
}

