/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.mixin.features.ticking;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import me.wesley1808.servercore.common.config.Config;
import me.wesley1808.servercore.common.config.data.FeatureConfig;
import me.wesley1808.servercore.common.utils.ChunkManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.chunk.ChunkAccess;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={Villager.class})
public abstract class VillagerMixin
extends AbstractVillager {
    @Unique
    private boolean servercore$lobotomized = false;
    @Unique
    private int servercore$notLobotomizedCount = 0;

    private VillagerMixin(EntityType<? extends AbstractVillager> entityType, Level level) {
        super(entityType, level);
    }

    @WrapWithCondition(method={"customServerAiStep()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/Brain;tick(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;)V")})
    private boolean servercore$shouldTickBrain(Brain<Villager> brain, ServerLevel level, LivingEntity livingEntity) {
        FeatureConfig config = Config.get().features();
        return !config.lobotomizeVillagers() || !this.servercore$isLobotomized() || this.tickCount % config.lobotomizedTickInterval() == 0 || this.isUnderWater();
    }

    @Unique
    private boolean servercore$isLobotomized() {
        if (this.tickCount % (this.servercore$notLobotomizedCount > 3 ? 600 : 300) == 0) {
            boolean bl = this.servercore$lobotomized = !this.getTags().contains("exclude_lobotomization") && (this.isPassenger() || !this.servercore$canTravel());
            this.servercore$notLobotomizedCount = this.servercore$lobotomized ? 0 : ++this.servercore$notLobotomizedCount;
        }
        return this.servercore$lobotomized;
    }

    @Unique
    private boolean servercore$canTravel() {
        BlockPos center = BlockPos.containing((double)this.getX(), (double)(this.getY() + 0.0625), (double)this.getZ());
        ChunkAccess chunk = ChunkManager.getChunkNow((LevelReader)this.level(), center);
        if (chunk == null) {
            return false;
        }
        BlockPos.MutableBlockPos mutable = center.mutable();
        boolean canJump = !this.servercore$hasCollisionAt(chunk, (BlockPos)mutable.move(Direction.UP, 2));
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!this.servercore$canTravelTo(mutable.setWithOffset((Vec3i)center, direction), canJump)) continue;
            return true;
        }
        return false;
    }

    @Unique
    private boolean servercore$canTravelTo(BlockPos.MutableBlockPos mutable, boolean canJump) {
        ChunkAccess chunk = ChunkManager.getChunkNow((LevelReader)this.level(), (BlockPos)mutable);
        if (chunk == null) {
            return false;
        }
        Block bottom = chunk.getBlockState((BlockPos)mutable).getBlock();
        if (bottom instanceof BedBlock) {
            return true;
        }
        if (this.servercore$hasCollisionAt(chunk, (BlockPos)mutable.move(Direction.UP))) {
            return false;
        }
        boolean isTallBlock = bottom instanceof FenceBlock || bottom instanceof FenceGateBlock || bottom instanceof WallBlock;
        return !bottom.hasCollision || canJump && !isTallBlock && !this.servercore$hasCollisionAt(chunk, (BlockPos)mutable.move(Direction.UP));
    }

    @Unique
    private boolean servercore$hasCollisionAt(ChunkAccess chunk, BlockPos pos) {
        return chunk.getBlockState((BlockPos)pos).getBlock().hasCollision;
    }
}

