/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.dynamic;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SequencedCollection;
import me.wesley1808.servercore.common.config.Config;
import me.wesley1808.servercore.common.config.data.dynamic.DynamicConfig;
import me.wesley1808.servercore.common.config.data.dynamic.Setting;
import me.wesley1808.servercore.common.dynamic.DynamicSetting;
import me.wesley1808.servercore.common.dynamic.LinkedSetting;
import me.wesley1808.servercore.common.interfaces.IMinecraftServer;
import me.wesley1808.servercore.common.interfaces.IMobCategory;
import me.wesley1808.servercore.common.utils.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.MobCategory;

public class DynamicManager {
    private static final List<LinkedSetting> SETTINGS = new ObjectArrayList();
    private final MinecraftServer server;
    private double averageTickTime;
    private int count;

    public DynamicManager(MinecraftServer server) {
        this.server = server;
        DynamicSetting.initDefaultValues();
    }

    public static DynamicManager getInstance(MinecraftServer server) {
        return ((IMinecraftServer)server).servercore$getDynamicManager();
    }

    public static void reload() {
        SETTINGS.clear();
        List<Setting> settings = Config.get().dynamic().settings();
        DynamicSetting.recalculateValues(settings);
        for (Setting setting : settings) {
            SETTINGS.add(new LinkedSetting(setting));
        }
        for (int i = 0; i < SETTINGS.size(); ++i) {
            LinkedSetting linked = SETTINGS.get(i);
            linked.initialize(i == 0 ? null : SETTINGS.get(i - 1), i == SETTINGS.size() - 1 ? null : SETTINGS.get(i + 1));
        }
    }

    public static void update(MinecraftServer server) {
        if (server.getTickCount() % 20 == 0) {
            DynamicManager manager = DynamicManager.getInstance(server);
            manager.updateValues();
            DynamicConfig config = Config.get().dynamic();
            if (config.enabled()) {
                manager.runPerformanceChecks(config);
            }
        }
    }

    private void updateValues() {
        this.averageTickTime = this.calculateAverageTickTime();
        ++this.count;
    }

    protected double calculateAverageTickTime() {
        return this.server.getCurrentSmoothedTickTime();
    }

    private void runPerformanceChecks(DynamicConfig config) {
        block1: {
            LinkedSetting setting;
            boolean increase;
            double targetMspt = config.targetMspt();
            boolean decrease = this.averageTickTime > targetMspt + 5.0;
            boolean bl = increase = this.averageTickTime < Math.max(targetMspt - 5.0, 2.0);
            if (!decrease && !increase) break block1;
            SequencedCollection<LinkedSetting> ordered = increase ? SETTINGS.reversed() : SETTINGS;
            Iterator iterator = ordered.iterator();
            while (!(!iterator.hasNext() || (setting = (LinkedSetting)iterator.next()).shouldRun(this.count) && setting.modify(increase, this))) {
            }
        }
    }

    public void modifyViewDistance(int distance) {
        this.server.getPlayerList().setViewDistance(distance);
        if (Environment.CLIENT) {
            Minecraft.getInstance().options.renderDistance().set((Object)distance);
        }
    }

    public void modifySimulationDistance(int distance) {
        this.server.getPlayerList().setSimulationDistance(distance);
        if (Environment.CLIENT) {
            Minecraft.getInstance().options.simulationDistance().set((Object)distance);
        }
    }

    public static void modifyMobcaps(int percentage) {
        double modifier = (float)percentage / 100.0f;
        for (MobCategory category : MobCategory.values()) {
            IMobCategory.modifyCapacity(category, modifier);
        }
    }

    public double getAverageTickTime() {
        return this.averageTickTime;
    }
}

