/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sawmill;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.mehvahdjukaar.sawmill.SawmillMod;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SingleItemRecipe;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class WoodcuttingRecipe
extends SingleItemRecipe {
    private final int inputCount;

    public WoodcuttingRecipe(String group, Ingredient ingredient, ItemStack itemStack, int inputCount) {
        super(SawmillMod.WOODCUTTING_RECIPE.get(), SawmillMod.WOODCUTTING_RECIPE_SERIALIZER.get(), group, ingredient, itemStack);
        if (inputCount > 64) {
            throw new IllegalArgumentException("Input count for wood cutting recipe is too high: " + inputCount + ". Ingredient: " + String.valueOf(ingredient) + ", Result: " + String.valueOf(itemStack));
        }
        this.inputCount = inputCount;
    }

    public int getInputCount() {
        return this.inputCount;
    }

    public boolean matches(SingleRecipeInput container, Level level) {
        ItemStack item = container.getItem(0);
        return this.ingredient.test(item) && item.getCount() >= this.inputCount;
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)SawmillMod.SAWMILL_BLOCK.get());
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<WoodcuttingRecipe> {
        private final MapCodec<WoodcuttingRecipe> codec = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(arg -> ((WoodcuttingRecipe)arg).group), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(arg -> ((WoodcuttingRecipe)arg).ingredient), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(arg -> ((WoodcuttingRecipe)arg).result), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("ingredient_count", (Object)1).forGetter(arg -> arg.inputCount)).apply((Applicative)instance, WoodcuttingRecipe::new));
        private final StreamCodec<RegistryFriendlyByteBuf, WoodcuttingRecipe> streamCodec = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, arg -> WoodcuttingRecipe.access$200(arg), (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, arg -> WoodcuttingRecipe.access$100(arg), (StreamCodec)ItemStack.STREAM_CODEC, arg -> WoodcuttingRecipe.access$000(arg), (StreamCodec)ByteBufCodecs.VAR_INT, arg -> arg.inputCount, WoodcuttingRecipe::new);

        public MapCodec<WoodcuttingRecipe> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, WoodcuttingRecipe> streamCodec() {
            return this.streamCodec;
        }
    }
}

