/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.type;

import dev.latvian.mods.rhino.type.TypeInfo;
import dev.latvian.mods.rhino.type.TypeInfoBase;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class VariableTypeInfo
extends TypeInfoBase {
    private static final Map<TypeVariable<?>, TypeInfo> CACHE = new HashMap();
    private static final Lock READ;
    private static final Lock WRITE;
    private TypeInfo consolidated = null;
    private final String name;

    public VariableTypeInfo(String name) {
        this.name = name;
    }

    static TypeInfo of(TypeVariable<?> t) {
        READ.lock();
        TypeInfo got = CACHE.get(t);
        READ.unlock();
        if (got == null) {
            WRITE.lock();
            Type bound = t.getBounds()[0];
            VariableTypeInfo variable = new VariableTypeInfo(t.getName());
            got = variable;
            CACHE.put(t, got);
            variable.consolidated = TypeInfo.of(bound);
            WRITE.unlock();
        }
        return got;
    }

    @Override
    public Class<?> asClass() {
        return this.consolidated.asClass();
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    static {
        ReentrantReadWriteLock l = new ReentrantReadWriteLock();
        READ = l.readLock();
        WRITE = l.writeLock();
    }
}

