/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.type;

import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.type.ArrayTypeInfo;
import dev.latvian.mods.rhino.type.BasicClassTypeInfo;
import dev.latvian.mods.rhino.type.EnumTypeInfo;
import dev.latvian.mods.rhino.type.InterfaceTypeInfo;
import dev.latvian.mods.rhino.type.JSOrTypeInfo;
import dev.latvian.mods.rhino.type.NoTypeInfo;
import dev.latvian.mods.rhino.type.ParameterizedTypeInfo;
import dev.latvian.mods.rhino.type.PrimitiveClassTypeInfo;
import dev.latvian.mods.rhino.type.RecordTypeInfo;
import dev.latvian.mods.rhino.type.TypeStringContext;
import dev.latvian.mods.rhino.type.TypeUtils;
import dev.latvian.mods.rhino.type.VariableTypeInfo;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public interface TypeInfo {
    public static final TypeInfo NONE = new NoTypeInfo();
    public static final TypeInfo[] EMPTY_ARRAY = new TypeInfo[0];
    public static final TypeInfo OBJECT = new BasicClassTypeInfo(Object.class);
    public static final TypeInfo OBJECT_ARRAY = OBJECT.asArray();
    public static final TypeInfo PRIMITIVE_VOID = new PrimitiveClassTypeInfo(Void.TYPE, null);
    public static final TypeInfo PRIMITIVE_BOOLEAN = new PrimitiveClassTypeInfo(Boolean.TYPE, false);
    public static final TypeInfo PRIMITIVE_BOOLEAN_ARRAY = PRIMITIVE_BOOLEAN.asArray();
    public static final TypeInfo PRIMITIVE_BYTE = new PrimitiveClassTypeInfo(Byte.TYPE, (byte)0);
    public static final TypeInfo PRIMITIVE_BYTE_ARRAY = PRIMITIVE_BYTE.asArray();
    public static final TypeInfo PRIMITIVE_SHORT = new PrimitiveClassTypeInfo(Short.TYPE, (short)0);
    public static final TypeInfo PRIMITIVE_SHORT_ARRAY = PRIMITIVE_SHORT.asArray();
    public static final TypeInfo PRIMITIVE_INT = new PrimitiveClassTypeInfo(Integer.TYPE, 0);
    public static final TypeInfo PRIMITIVE_INT_ARRAY = PRIMITIVE_INT.asArray();
    public static final TypeInfo PRIMITIVE_LONG = new PrimitiveClassTypeInfo(Long.TYPE, 0L);
    public static final TypeInfo PRIMITIVE_LONG_ARRAY = PRIMITIVE_LONG.asArray();
    public static final TypeInfo PRIMITIVE_FLOAT = new PrimitiveClassTypeInfo(Float.TYPE, Float.valueOf(0.0f));
    public static final TypeInfo PRIMITIVE_FLOAT_ARRAY = PRIMITIVE_FLOAT.asArray();
    public static final TypeInfo PRIMITIVE_DOUBLE = new PrimitiveClassTypeInfo(Double.TYPE, 0.0);
    public static final TypeInfo PRIMITIVE_DOUBLE_ARRAY = PRIMITIVE_DOUBLE.asArray();
    public static final TypeInfo PRIMITIVE_CHARACTER = new PrimitiveClassTypeInfo(Character.TYPE, Character.valueOf('\u0000'));
    public static final TypeInfo PRIMITIVE_CHARACTER_ARRAY = PRIMITIVE_CHARACTER.asArray();
    public static final TypeInfo VOID = new BasicClassTypeInfo(Void.class);
    public static final TypeInfo BOOLEAN = new BasicClassTypeInfo(Boolean.class);
    public static final TypeInfo BYTE = new BasicClassTypeInfo(Byte.class);
    public static final TypeInfo SHORT = new BasicClassTypeInfo(Short.class);
    public static final TypeInfo INT = new BasicClassTypeInfo(Integer.class);
    public static final TypeInfo LONG = new BasicClassTypeInfo(Long.class);
    public static final TypeInfo FLOAT = new BasicClassTypeInfo(Float.class);
    public static final TypeInfo DOUBLE = new BasicClassTypeInfo(Double.class);
    public static final TypeInfo CHARACTER = new BasicClassTypeInfo(Character.class);
    public static final TypeInfo NUMBER = new BasicClassTypeInfo(Number.class);
    public static final TypeInfo STRING = new BasicClassTypeInfo(String.class);
    public static final TypeInfo STRING_ARRAY = STRING.asArray();
    public static final TypeInfo CLASS = new BasicClassTypeInfo(Class.class);
    public static final TypeInfo DATE = new BasicClassTypeInfo(Date.class);
    public static final TypeInfo CONTEXT = new BasicClassTypeInfo(Context.class);
    public static final TypeInfo SCRIPTABLE = new BasicClassTypeInfo(Scriptable.class);
    public static final TypeInfo RUNNABLE = new InterfaceTypeInfo(Runnable.class, Boolean.TRUE);
    public static final TypeInfo RAW_CONSUMER = new InterfaceTypeInfo(Consumer.class, Boolean.TRUE);
    public static final TypeInfo RAW_SUPPLIER = new InterfaceTypeInfo(Supplier.class, Boolean.TRUE);
    public static final TypeInfo RAW_FUNCTION = new InterfaceTypeInfo(Function.class, Boolean.TRUE);
    public static final TypeInfo RAW_PREDICATE = new InterfaceTypeInfo(Predicate.class, Boolean.TRUE);
    public static final TypeInfo RAW_LIST = new InterfaceTypeInfo(List.class, Boolean.FALSE);
    public static final TypeInfo RAW_SET = new InterfaceTypeInfo(Set.class, Boolean.FALSE);
    public static final TypeInfo RAW_MAP = new InterfaceTypeInfo(Map.class, Boolean.FALSE);
    public static final TypeInfo RAW_OPTIONAL = new BasicClassTypeInfo(Optional.class);
    public static final TypeInfo RAW_ENUM_SET = new BasicClassTypeInfo(EnumSet.class);

    public Class<?> asClass();

    default public TypeInfo param(int index) {
        return NONE;
    }

    default public boolean is(TypeInfo info) {
        return this == info;
    }

    default public boolean isPrimitive() {
        return false;
    }

    default public boolean shouldConvert() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypeInfo of(Class<?> c) {
        if (c == null || c == Object.class) {
            return OBJECT;
        }
        if (c == Void.TYPE) {
            return PRIMITIVE_VOID;
        }
        TypeInfo cached = TypeUtils.IMMUTABLE_CACHE.get(c);
        if (cached != null) {
            return cached;
        }
        if (c.isArray()) {
            return TypeInfo.of(c.getComponentType()).asArray();
        }
        if (c.isEnum()) {
            Map<Class<?>, EnumTypeInfo> map = EnumTypeInfo.CACHE;
            synchronized (map) {
                return EnumTypeInfo.CACHE.computeIfAbsent(c, EnumTypeInfo::new);
            }
        }
        if (c.isRecord()) {
            Map<Class<?>, RecordTypeInfo> map = RecordTypeInfo.CACHE;
            synchronized (map) {
                return RecordTypeInfo.CACHE.computeIfAbsent(c, RecordTypeInfo::new);
            }
        }
        if (c.isInterface()) {
            Map<Class<?>, InterfaceTypeInfo> map = InterfaceTypeInfo.CACHE;
            synchronized (map) {
                return InterfaceTypeInfo.CACHE.computeIfAbsent(c, InterfaceTypeInfo::new);
            }
        }
        Map<Class<?>, BasicClassTypeInfo> map = BasicClassTypeInfo.CACHE;
        synchronized (map) {
            return BasicClassTypeInfo.CACHE.computeIfAbsent(c, BasicClassTypeInfo::new);
        }
    }

    public static TypeInfo of(Type type) {
        Type type2 = type;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Class.class, ParameterizedType.class, GenericArrayType.class, TypeVariable.class, WildcardType.class}, (Object)type2, n)) {
            case 0 -> {
                Class clz = (Class)type2;
                yield TypeInfo.of(clz);
            }
            case 1 -> {
                ParameterizedType paramType = (ParameterizedType)type2;
                yield TypeInfo.of(paramType.getRawType()).withParams(TypeInfo.ofArray(paramType.getActualTypeArguments()));
            }
            case 2 -> {
                GenericArrayType arrType = (GenericArrayType)type2;
                yield TypeInfo.of(arrType.getGenericComponentType()).asArray();
            }
            case 3 -> {
                TypeVariable variable = (TypeVariable)type2;
                yield VariableTypeInfo.of(variable);
            }
            case 4 -> {
                WildcardType wildcard = (WildcardType)type2;
                Type[] lower = wildcard.getLowerBounds();
                if (lower.length == 0) {
                    Type[] upper = wildcard.getUpperBounds();
                    if (upper.length == 0 || upper[0] == Object.class) {
                        yield NONE;
                    }
                    yield TypeInfo.of(upper[0]);
                }
                yield TypeInfo.of(lower[0]);
            }
            default -> NONE;
        };
    }

    public static TypeInfo[] ofArray(Type[] array) {
        if (array.length == 0) {
            return EMPTY_ARRAY;
        }
        TypeInfo[] arr = new TypeInfo[array.length];
        for (int i = 0; i < array.length; ++i) {
            arr[i] = TypeInfo.of(array[i]);
        }
        return arr;
    }

    public static TypeInfo safeOf(Supplier<Type> supplier) {
        try {
            return TypeInfo.of(supplier.get());
        }
        catch (Throwable ignored) {
            return NONE;
        }
    }

    public static TypeInfo[] safeOfArray(Supplier<Type[]> supplier) {
        try {
            return TypeInfo.ofArray(supplier.get());
        }
        catch (Exception ignored) {
            return EMPTY_ARRAY;
        }
    }

    default public String signature() {
        return this.toString();
    }

    default public TypeInfo componentType() {
        return NONE;
    }

    default public Object newArray(int length) {
        return Array.newInstance(this.asClass(), length);
    }

    default public TypeInfo asArray() {
        return new ArrayTypeInfo(this);
    }

    default public TypeInfo withParams(TypeInfo ... params) {
        if (params.length == 0) {
            return this;
        }
        return new ParameterizedTypeInfo(this, params);
    }

    default public boolean isFunctionalInterface() {
        return false;
    }

    default public Map<String, RecordTypeInfo.Component> recordComponents() {
        return Map.of();
    }

    default public List<Object> enumConstants() {
        return List.of();
    }

    default public TypeInfo or(TypeInfo info) {
        return new JSOrTypeInfo(List.of(this, info));
    }

    default public void append(TypeStringContext ctx, StringBuilder sb) {
        sb.append(this);
    }

    @Nullable
    default public Object createDefaultValue() {
        return null;
    }

    default public boolean isVoid() {
        return false;
    }

    default public boolean isBoolean() {
        return false;
    }

    default public boolean isByte() {
        return false;
    }

    default public boolean isShort() {
        return false;
    }

    default public boolean isInt() {
        return false;
    }

    default public boolean isLong() {
        return false;
    }

    default public boolean isFloat() {
        return false;
    }

    default public boolean isDouble() {
        return false;
    }

    default public boolean isCharacter() {
        return false;
    }

    default public void collectContainedComponentClasses(Collection<Class<?>> classes) {
        classes.add(this.asClass());
    }

    default public Set<Class<?>> getContainedComponentClasses() {
        LinkedHashSet set = new LinkedHashSet();
        this.collectContainedComponentClasses(set);
        return set;
    }
}

