/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.type;

import dev.latvian.mods.rhino.type.TypeInfo;
import dev.latvian.mods.rhino.type.TypeInfoBase;
import dev.latvian.mods.rhino.type.TypeStringContext;
import java.util.Collection;
import java.util.Set;

public final class ArrayTypeInfo
extends TypeInfoBase {
    private final TypeInfo component;
    private Class<?> asClass;

    ArrayTypeInfo(TypeInfo component) {
        this.component = component;
    }

    @Override
    public Class<?> asClass() {
        if (this.asClass == null) {
            this.asClass = this.component.newArray(0).getClass();
        }
        return this.asClass;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof ArrayTypeInfo)) return false;
        ArrayTypeInfo t = (ArrayTypeInfo)obj;
        if (!this.component.equals(t.component)) return false;
        return true;
    }

    public int hashCode() {
        return this.component.hashCode();
    }

    public String toString() {
        return String.valueOf(this.component) + "[]";
    }

    @Override
    public void append(TypeStringContext ctx, StringBuilder sb) {
        ctx.append(sb, this.component);
        sb.append('[');
        sb.append(']');
    }

    @Override
    public String signature() {
        return this.component.signature() + "[]";
    }

    @Override
    public TypeInfo componentType() {
        return this.component;
    }

    @Override
    public void collectContainedComponentClasses(Collection<Class<?>> classes) {
        this.component.collectContainedComponentClasses(classes);
    }

    @Override
    public Set<Class<?>> getContainedComponentClasses() {
        return this.component.getContainedComponentClasses();
    }
}

