/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.BaseFunction;
import dev.latvian.mods.rhino.Callable;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.EqualObjectGraphs;
import dev.latvian.mods.rhino.Function;
import dev.latvian.mods.rhino.NativeObject;
import dev.latvian.mods.rhino.ScriptRuntime;
import dev.latvian.mods.rhino.Scriptable;

public class ArrowFunction
extends BaseFunction {
    private final Callable targetFunction;
    private final Scriptable boundThis;

    static boolean equalObjectGraphs(Context cx, ArrowFunction f1, ArrowFunction f2, EqualObjectGraphs eq) {
        return eq.equalGraphs(cx, f1.boundThis, f2.boundThis) && eq.equalGraphs(cx, f1.targetFunction, f2.targetFunction);
    }

    public ArrowFunction(Context cx, Scriptable scope, Callable targetFunction, Scriptable boundThis) {
        this.targetFunction = targetFunction;
        this.boundThis = boundThis;
        ScriptRuntime.setFunctionProtoAndParent(cx, scope, this);
        BaseFunction thrower = ScriptRuntime.typeErrorThrower(cx);
        NativeObject throwing = new NativeObject(cx.factory);
        throwing.put(cx, "get", (Scriptable)throwing, (Object)thrower);
        throwing.put(cx, "set", (Scriptable)throwing, (Object)thrower);
        throwing.put(cx, "enumerable", (Scriptable)throwing, (Object)Boolean.FALSE);
        throwing.put(cx, "configurable", (Scriptable)throwing, (Object)Boolean.FALSE);
        throwing.preventExtensions();
        this.defineOwnProperty(cx, "caller", throwing, false);
        this.defineOwnProperty(cx, "arguments", throwing, false);
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Scriptable callThis = this.boundThis != null ? this.boundThis : cx.getTopCallOrThrow();
        return cx.callSync(this.targetFunction, scope, callThis, args);
    }

    @Override
    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        throw ScriptRuntime.typeError1(cx, "msg.not.ctor", this.toString());
    }

    @Override
    public boolean hasInstance(Context cx, Scriptable instance) {
        if (this.targetFunction instanceof Function) {
            return ((Function)this.targetFunction).hasInstance(cx, instance);
        }
        throw ScriptRuntime.typeError0(cx, "msg.not.ctor");
    }

    @Override
    public int getLength() {
        if (this.targetFunction instanceof BaseFunction) {
            return ((BaseFunction)this.targetFunction).getLength();
        }
        return 0;
    }

    @Override
    public int getArity() {
        return this.getLength();
    }

    @Override
    public String toString() {
        if (this.targetFunction instanceof BaseFunction) {
            return "ArrowFunction (" + ((BaseFunction)this.targetFunction).getLength() + ") => {...}";
        }
        return "ArrowFunction";
    }
}

