/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.setup;

import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.api.smartwrench.SmartWrench;
import mcjty.rftoolsutility.commands.ModCommands;
import mcjty.rftoolsutility.modules.environmental.NoTeleportAreaManager;
import mcjty.rftoolsutility.modules.environmental.PeacefulAreaManager;
import mcjty.rftoolsutility.modules.screen.blocks.IAttackableBlock;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenBlock;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenHitBlock;
import mcjty.rftoolsutility.modules.teleporter.TeleportationTools;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestination;
import mcjty.rftoolsutility.playerprops.BuffProperties;
import mcjty.rftoolsutility.playerprops.PlayerBuff;
import mcjty.rftoolsutility.setup.Registration;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.apache.commons.lang3.tuple.Pair;

public class ForgeEventHandlers {
    private static final List<Pair<TeleportDestination, Player>> playersToTeleportHere = new ArrayList<Pair<TeleportDestination, Player>>();

    public static void addPlayerToTeleportHere(TeleportDestination destination, Player player) {
        playersToTeleportHere.add((Pair<TeleportDestination, Player>)Pair.of((Object)destination, (Object)player));
    }

    private static void performDelayedTeleports() {
        if (!playersToTeleportHere.isEmpty()) {
            ArrayList<Pair<TeleportDestination, Player>> copy = new ArrayList<Pair<TeleportDestination, Player>>(playersToTeleportHere);
            playersToTeleportHere.clear();
            for (Pair<TeleportDestination, Player> pair : copy) {
                TeleportationTools.performTeleport((Player)pair.getRight(), (TeleportDestination)pair.getLeft(), 0, 10, false);
            }
        }
    }

    @SubscribeEvent
    public void onWorldTick(LevelTickEvent.Pre event) {
        if (!event.getLevel().isClientSide && event.getLevel().dimension().equals(Level.OVERWORLD)) {
            ForgeEventHandlers.performDelayedTeleports();
        }
    }

    @SubscribeEvent
    public void onPlayerTickEvent(PlayerTickEvent.Pre event) {
        Player player = event.getEntity();
        if (!player.getCommandSenderWorld().isClientSide) {
            BuffProperties data = (BuffProperties)player.getData(Registration.ATTACHMENT_TYPE_BUFF_PROPERTIES);
            data.tickBuffs((ServerPlayer)player);
        }
    }

    @SubscribeEvent
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        double blockReachDistance;
        BlockHitResult rayTrace;
        Level world = event.getLevel();
        if (world.isClientSide) {
            return;
        }
        Player player = event.getEntity();
        ItemStack heldItem = player.getMainHandItem();
        if ((heldItem.isEmpty() || !(heldItem.getItem() instanceof SmartWrench)) && (rayTrace = ForgeEventHandlers.rayTraceEyes((LivingEntity)player, (blockReachDistance = player.getAttribute(Attributes.BLOCK_INTERACTION_RANGE).getValue()) + 1.0)).getType() == HitResult.Type.BLOCK) {
            Block block = world.getBlockState(rayTrace.getBlockPos()).getBlock();
            if (block instanceof ScreenBlock) {
                event.setCanceled(true);
            } else if (block instanceof ScreenHitBlock) {
                event.setCanceled(true);
            }
        }
    }

    @Nonnull
    public static BlockHitResult rayTraceEyes(LivingEntity entity, double length) {
        Vec3 startPos = new Vec3(entity.getX(), entity.getY() + (double)entity.getEyeHeight(), entity.getZ());
        Vec3 endPos = startPos.add(new Vec3(entity.getLookAngle().x * length, entity.getLookAngle().y * length, entity.getLookAngle().z * length));
        ClipContext context = new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity);
        return entity.level().clip(context);
    }

    @SubscribeEvent
    public void onPlayerInteractEventLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        this.checkCreativeClick(event);
        ItemStack heldItem = player.getItemInHand(event.getHand());
        if (heldItem.isEmpty()) {
            return;
        }
        heldItem.getItem();
    }

    @SubscribeEvent
    public void onPlayerInteractEventRightClick(PlayerInteractEvent.RightClickBlock event) {
        ItemStack heldItem;
        Player player = event.getEntity();
        if (player.isShiftKeyDown() && ((heldItem = player.getMainHandItem()).isEmpty() || !(heldItem.getItem() instanceof SmartWrench))) {
            Level world = event.getLevel();
            BlockState state = world.getBlockState(event.getPos());
            Block block = state.getBlock();
        }
        if ((heldItem = player.getItemInHand(event.getHand())).isEmpty()) {
            return;
        }
        heldItem.getItem();
    }

    private void checkCreativeClick(PlayerInteractEvent.LeftClickBlock event) {
        BlockState state;
        Block block;
        if (event.getEntity().isCreative() && (block = (state = event.getLevel().getBlockState(event.getPos())).getBlock()) instanceof IAttackableBlock) {
            IAttackableBlock attackableBlock = (IAttackableBlock)block;
            if (!event.getEntity().isShiftKeyDown()) {
                if (event.getLevel().isClientSide) {
                    attackableBlock.doAttack(event.getLevel(), event.getPos());
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onLivingFall(LivingFallEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            BuffProperties h = (BuffProperties)player.getData(Registration.ATTACHMENT_TYPE_BUFF_PROPERTIES);
            if (h.hasBuff(PlayerBuff.BUFF_FEATHERFALLING)) {
                event.setDamageMultiplier(event.getDamageMultiplier() / 2.0f);
            }
            if (h.hasBuff(PlayerBuff.BUFF_FEATHERFALLINGPLUS)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onPearlTeleport(EntityTeleportEvent.EnderPearl event) {
        this.checkTeleport((EntityTeleportEvent)event);
    }

    @SubscribeEvent
    public void onEntityTeleport(EntityTeleportEvent.EnderEntity event) {
        this.checkTeleport((EntityTeleportEvent)event);
    }

    private void checkTeleport(EntityTeleportEvent event) {
        BlockPos coordinate;
        Level world = event.getEntity().getCommandSenderWorld();
        ResourceKey id = world.dimension();
        Entity entity = event.getEntity();
        if (NoTeleportAreaManager.isTeleportPrevented(entity, GlobalPos.of((ResourceKey)id, (BlockPos)(coordinate = new BlockPos((int)entity.getX(), (int)entity.getY(), (int)entity.getZ()))))) {
            event.setCanceled(true);
        } else {
            coordinate = new BlockPos((int)event.getTargetX(), (int)event.getTargetY(), (int)event.getTargetZ());
            if (NoTeleportAreaManager.isTeleportPrevented(entity, GlobalPos.of((ResourceKey)id, (BlockPos)coordinate))) {
                event.setCanceled(true);
            }
        }
    }

    public static boolean onEntitySpawnEvent(Entity entity) {
        BlockPos coordinate;
        Level world = entity.level();
        ResourceKey id = world.dimension();
        return entity instanceof Enemy && PeacefulAreaManager.isPeaceful(GlobalPos.of((ResourceKey)id, (BlockPos)(coordinate = new BlockPos((int)entity.getX(), (int)entity.getY(), (int)entity.getZ()))));
    }

    @SubscribeEvent
    public void serverLoad(RegisterCommandsEvent event) {
        ModCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

