/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.modulesclient;

import mcjty.rftoolsbase.api.screens.IClientScreenModule;
import mcjty.rftoolsbase.api.screens.IModuleRenderHelper;
import mcjty.rftoolsbase.api.screens.ITextRenderHelper;
import mcjty.rftoolsbase.api.screens.ModuleRenderInfo;
import mcjty.rftoolsbase.api.screens.data.IModuleDataInteger;
import mcjty.rftoolsbase.tools.ScreenTextHelper;
import mcjty.rftoolsutility.modules.screen.items.modules.RedstoneModuleItem;
import mcjty.rftoolsutility.modules.screen.modules.RedstoneScreenModule;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class RedstoneClientScreenModule
implements IClientScreenModule<IModuleDataInteger> {
    private final ITextRenderHelper labelCache = new ScreenTextHelper();

    public IClientScreenModule.TransformMode getTransformMode(ItemStack moduleItem) {
        return IClientScreenModule.TransformMode.TEXT;
    }

    public int getHeight(ItemStack moduleItem) {
        return 10;
    }

    public void render(GuiGraphics graphics, MultiBufferSource buffer, IModuleRenderHelper renderHelper, Font fontRenderer, int currenty, IModuleDataInteger screenData, ModuleRenderInfo renderInfo) {
        int col;
        String text;
        int xoffset;
        RedstoneScreenModule data = RedstoneModuleItem.data(renderInfo.moduleStack);
        if (!data.getLine().isEmpty()) {
            this.labelCache.setup(data.getLine(), 160, renderInfo);
            this.labelCache.align(data.getAlign());
            this.labelCache.renderText(graphics, buffer, 0, currenty, data.getColor(), renderInfo);
            xoffset = 47;
        } else {
            xoffset = 7;
        }
        if (screenData != null) {
            boolean rs;
            int power = screenData.get();
            boolean bl = rs = power > 0;
            text = data.isAnalog() ? Integer.toString(power) : (rs ? data.getYestext() : data.getNotext());
            col = rs ? data.getYescolor() : data.getNocolor();
        } else {
            text = "<invalid>";
            col = 0xFF0000;
        }
        renderHelper.renderText(graphics, buffer, xoffset, currenty, col, renderInfo, text);
    }

    public void mouseClick(ItemStack moduleStack, Level world, int x, int y, boolean clicked) {
    }

    public boolean needsServerData() {
        return true;
    }
}

