/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.modules;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.CapabilityTools;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.screens.IScreenDataHelper;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.screens.data.IModuleData;
import mcjty.rftoolsutility.modules.screen.ScreenConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;

public record InventoryScreenModule(int slot1, int slot2, int slot3, int slot4, GlobalPos pos, boolean active, String monitor) implements IScreenModule<InventoryScreenModule, ModuleDataStacks>
{
    public static final InventoryScreenModule DEFAULT = new InventoryScreenModule(-1, -1, -1, -1, GlobalPos.of((ResourceKey)Level.OVERWORLD, (BlockPos)BlockPosTools.INVALID), false, "");
    public static final Codec<InventoryScreenModule> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("slot1").forGetter(module -> module.slot1), (App)Codec.INT.fieldOf("slot2").forGetter(module -> module.slot2), (App)Codec.INT.fieldOf("slot3").forGetter(module -> module.slot3), (App)Codec.INT.fieldOf("slot4").forGetter(module -> module.slot4), (App)GlobalPos.CODEC.fieldOf("pos").forGetter(module -> module.pos), (App)Codec.STRING.fieldOf("monitor").forGetter(module -> module.monitor)).apply((Applicative)instance, InventoryScreenModule::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, InventoryScreenModule> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, module -> module.slot1, (StreamCodec)ByteBufCodecs.INT, module -> module.slot2, (StreamCodec)ByteBufCodecs.INT, module -> module.slot3, (StreamCodec)ByteBufCodecs.INT, module -> module.slot4, (StreamCodec)GlobalPos.STREAM_CODEC, module -> module.pos, (StreamCodec)ByteBufCodecs.STRING_UTF8, module -> module.monitor, InventoryScreenModule::new);

    public InventoryScreenModule(int slot1, int slot2, int slot3, int slot4, GlobalPos pos, String monitor) {
        this(slot1, slot2, slot3, slot4, pos, false, monitor);
    }

    public int getSlot1() {
        return this.slot1;
    }

    public int getSlot2() {
        return this.slot2;
    }

    public int getSlot3() {
        return this.slot3;
    }

    public int getSlot4() {
        return this.slot4;
    }

    public GlobalPos getPos() {
        return this.pos;
    }

    public String getMonitor() {
        return this.monitor;
    }

    public InventoryScreenModule withSlot1(int slot1) {
        return new InventoryScreenModule(slot1, this.slot2, this.slot3, this.slot4, this.pos, this.active, this.monitor);
    }

    public InventoryScreenModule withSlot2(int slot2) {
        return new InventoryScreenModule(this.slot1, slot2, this.slot3, this.slot4, this.pos, this.active, this.monitor);
    }

    public InventoryScreenModule withSlot3(int slot3) {
        return new InventoryScreenModule(this.slot1, this.slot2, slot3, this.slot4, this.pos, this.active, this.monitor);
    }

    public InventoryScreenModule withSlot4(int slot4) {
        return new InventoryScreenModule(this.slot1, this.slot2, this.slot3, slot4, this.pos, this.active, this.monitor);
    }

    public InventoryScreenModule withPos(GlobalPos pos) {
        return new InventoryScreenModule(this.slot1, this.slot2, this.slot3, this.slot4, pos, this.active, this.monitor);
    }

    public InventoryScreenModule withMonitor(String monitor) {
        return new InventoryScreenModule(this.slot1, this.slot2, this.slot3, this.slot4, this.pos, this.active, monitor);
    }

    public InventoryScreenModule withActive(boolean active) {
        return new InventoryScreenModule(this.slot1, this.slot2, this.slot3, this.slot4, this.pos, active, this.monitor);
    }

    public ModuleDataStacks getData(IScreenDataHelper helper, Level worldObj, long millis) {
        if (!this.active) {
            return null;
        }
        ServerLevel world = LevelTools.getLevel((Level)worldObj, (ResourceKey)this.pos.dimension());
        if (world == null) {
            return null;
        }
        if (!LevelTools.isLoaded((Level)world, (BlockPos)this.pos.pos())) {
            return null;
        }
        BlockEntity te = world.getBlockEntity(this.pos.pos());
        if (te == null) {
            return null;
        }
        IItemHandler h = CapabilityTools.getItemCapabilitySafe((BlockEntity)te);
        if (h != null) {
            ItemStack stack1 = this.getItemStack(h, this.slot1);
            ItemStack stack2 = this.getItemStack(h, this.slot2);
            ItemStack stack3 = this.getItemStack(h, this.slot3);
            ItemStack stack4 = this.getItemStack(h, this.slot4);
            return new ModuleDataStacks(stack1, stack2, stack3, stack4);
        }
        return null;
    }

    private ItemStack getItemStack(Container inventory, int slot) {
        if (slot == -1) {
            return ItemStack.EMPTY;
        }
        if (slot < inventory.getContainerSize()) {
            return inventory.getItem(slot);
        }
        return ItemStack.EMPTY;
    }

    private ItemStack getItemStack(IItemHandler itemHandler, int slot) {
        if (slot == -1) {
            return ItemStack.EMPTY;
        }
        if (slot < itemHandler.getSlots()) {
            return itemHandler.getStackInSlot(slot);
        }
        return ItemStack.EMPTY;
    }

    public InventoryScreenModule validate(Level world, BlockPos p, boolean isPlus) {
        if (isPlus) {
            return this.withActive(true);
        }
        if (LevelTools.isLoaded((Level)world, (BlockPos)this.pos.pos()) && Objects.equals(this.pos.dimension(), world.dimension())) {
            int dx = Math.abs(this.pos.pos().getX() - p.getX());
            int dy = Math.abs(this.pos.pos().getY() - p.getY());
            int dz = Math.abs(this.pos.pos().getZ() - p.getZ());
            if (dx > 64 || dy > 64 || dz <= 64) {
                // empty if block
            }
        }
        return this.withActive(false);
    }

    public int getRfPerTick() {
        return (Integer)ScreenConfiguration.ITEMSTACK_RFPERTICK.get();
    }

    public void mouseClick(Level world, int x, int y, boolean clicked, Player player) {
    }

    public static class ModuleDataStacks
    implements IModuleData {
        public static final String ID = "rftoolsutility:itemStacks";
        private final ItemStack[] stacks = new ItemStack[4];

        public String getId() {
            return ID;
        }

        public ModuleDataStacks(ItemStack stack1, ItemStack stack2, ItemStack stack3, ItemStack stack4) {
            this.stacks[0] = stack1;
            this.stacks[1] = stack2;
            this.stacks[2] = stack3;
            this.stacks[3] = stack4;
        }

        public ModuleDataStacks(RegistryFriendlyByteBuf buf) {
            for (int i = 0; i < 4; ++i) {
                this.stacks[i] = NetworkTools.readItemStack((RegistryFriendlyByteBuf)buf);
            }
        }

        public ItemStack getStack(int idx) {
            return this.stacks[idx];
        }

        public void writeToBuf(RegistryFriendlyByteBuf buf) {
            this.writeStack(buf, this.stacks[0]);
            this.writeStack(buf, this.stacks[1]);
            this.writeStack(buf, this.stacks[2]);
            this.writeStack(buf, this.stacks[3]);
        }

        private void writeStack(RegistryFriendlyByteBuf buf, ItemStack stack) {
            NetworkTools.writeItemStack((RegistryFriendlyByteBuf)buf, (ItemStack)stack);
        }
    }
}

