/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.modules;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import mcjty.lib.varia.CapabilityTools;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.screens.BarMode;
import mcjty.rftoolsbase.api.screens.FormatStyle;
import mcjty.rftoolsbase.api.screens.ILevelRenderHelper;
import mcjty.rftoolsbase.api.screens.IScreenDataHelper;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.screens.TextAlign;
import mcjty.rftoolsbase.api.screens.data.IModuleDataContents;
import mcjty.rftoolsutility.modules.screen.ScreenConfiguration;
import mcjty.rftoolsutility.modules.screen.modules.ScreenModuleHelper;
import mcjty.rftoolsutility.modules.screen.modulesclient.helper.ScreenLevelHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public record FluidBarScreenModule(GlobalPos pos, ScreenModuleHelper helper, boolean active, String line, int color, TextAlign align, ILevelRenderHelper mbRenderer, String monitor) implements IScreenModule<FluidBarScreenModule, IModuleDataContents>
{
    public static final FluidBarScreenModule DEFAULT = new FluidBarScreenModule(GlobalPos.of((ResourceKey)Level.OVERWORLD, (BlockPos)BlockPos.ZERO), "", 0xFFFFFF, TextAlign.ALIGN_LEFT, new ScreenLevelHelper(), "");
    public static final Codec<FluidBarScreenModule> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)GlobalPos.CODEC.fieldOf("pos").forGetter(module -> module.pos), (App)Codec.STRING.fieldOf("line").forGetter(module -> module.line), (App)Codec.INT.fieldOf("color").forGetter(module -> module.color), (App)TextAlign.CODEC.fieldOf("align").forGetter(module -> module.align), (App)ScreenLevelHelper.CODEC.fieldOf("mbRenderer").forGetter(module -> (ScreenLevelHelper)module.mbRenderer), (App)Codec.STRING.fieldOf("monitor").forGetter(module -> module.monitor)).apply((Applicative)instance, FluidBarScreenModule::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, FluidBarScreenModule> STREAM_CODEC = StreamCodec.composite((StreamCodec)GlobalPos.STREAM_CODEC, module -> module.pos, (StreamCodec)ByteBufCodecs.STRING_UTF8, module -> module.line, (StreamCodec)ByteBufCodecs.INT, module -> module.color, (StreamCodec)TextAlign.STREAM_CODEC, module -> module.align, ScreenLevelHelper.STREAM_CODEC, module -> (ScreenLevelHelper)module.mbRenderer, (StreamCodec)ByteBufCodecs.STRING_UTF8, module -> module.monitor, FluidBarScreenModule::new);

    public FluidBarScreenModule(GlobalPos pos, String line, int color, TextAlign align, ILevelRenderHelper mbRenderer, String monitor) {
        this(pos, new ScreenModuleHelper(), false, line, color, align, mbRenderer, monitor);
    }

    public String getLine() {
        return this.line;
    }

    public int getColor() {
        return this.color;
    }

    public GlobalPos getPos() {
        return this.pos;
    }

    public String getMonitor() {
        return this.monitor;
    }

    public TextAlign getAlign() {
        return this.align;
    }

    public int getPosColor() {
        return this.mbRenderer.getPosColor();
    }

    public int getNegColor() {
        return this.mbRenderer.getNegColor();
    }

    public boolean isHideBar() {
        return this.mbRenderer.isHideBar();
    }

    public FormatStyle getFormat() {
        return this.mbRenderer.getFormatStyle();
    }

    public BarMode getBarMode() {
        return this.mbRenderer.getBarMode();
    }

    public ILevelRenderHelper getMbRenderer() {
        return this.mbRenderer;
    }

    public FluidBarScreenModule withLine(String line) {
        return new FluidBarScreenModule(this.pos, this.helper, this.active, line, this.color, this.align, this.mbRenderer, this.monitor);
    }

    public FluidBarScreenModule withColor(int color) {
        return new FluidBarScreenModule(this.pos, this.helper, this.active, this.line, color, this.align, this.mbRenderer, this.monitor);
    }

    public FluidBarScreenModule withAlign(TextAlign align) {
        return new FluidBarScreenModule(this.pos, this.helper, this.active, this.line, this.color, align, this.mbRenderer, this.monitor);
    }

    public FluidBarScreenModule withPos(GlobalPos pos) {
        return new FluidBarScreenModule(pos, this.helper, this.active, this.line, this.color, this.align, this.mbRenderer, this.monitor);
    }

    public FluidBarScreenModule withMonitor(String monitor) {
        return new FluidBarScreenModule(this.pos, this.helper, this.active, this.line, this.color, this.align, this.mbRenderer, monitor);
    }

    public FluidBarScreenModule withActive(boolean active) {
        return new FluidBarScreenModule(this.pos, this.helper, active, this.line, this.color, this.align, this.mbRenderer, this.monitor);
    }

    public FluidBarScreenModule withPosColor(int posColor) {
        this.mbRenderer.setPosColor(posColor);
        return new FluidBarScreenModule(this.pos, this.helper, this.active, this.line, this.color, this.align, this.mbRenderer, this.monitor);
    }

    public FluidBarScreenModule withNegColor(int negColor) {
        this.mbRenderer.setNegColor(negColor);
        return new FluidBarScreenModule(this.pos, this.helper, this.active, this.line, this.color, this.align, this.mbRenderer, this.monitor);
    }

    public FluidBarScreenModule withHideBar(boolean hideBar) {
        this.mbRenderer.setHideBar(hideBar);
        return new FluidBarScreenModule(this.pos, this.helper, this.active, this.line, this.color, this.align, this.mbRenderer, this.monitor);
    }

    public FluidBarScreenModule withFormat(FormatStyle format) {
        this.mbRenderer.setFormatStyle(format);
        return new FluidBarScreenModule(this.pos, this.helper, this.active, this.line, this.color, this.align, this.mbRenderer, this.monitor);
    }

    public FluidBarScreenModule withBarMode(BarMode mode) {
        this.mbRenderer.setBarMode(mode);
        return new FluidBarScreenModule(this.pos, this.helper, this.active, this.line, this.color, this.align, this.mbRenderer, this.monitor);
    }

    public IModuleDataContents getData(IScreenDataHelper h, Level worldObj, long millis) {
        if (!this.active) {
            return null;
        }
        ServerLevel world = LevelTools.getLevel((Level)worldObj, (ResourceKey)this.pos.dimension());
        if (world == null) {
            return null;
        }
        if (!LevelTools.isLoaded((Level)world, (BlockPos)this.pos.pos())) {
            return null;
        }
        AtomicInteger contents = new AtomicInteger();
        AtomicInteger maxContents = new AtomicInteger();
        BlockEntity te = world.getBlockEntity(this.pos.pos());
        IFluidHandler hf = CapabilityTools.getFluidCapabilitySafe((BlockEntity)te);
        if (hf != null && hf.getTanks() > 0) {
            if (!hf.getFluidInTank(0).isEmpty()) {
                contents.set(hf.getFluidInTank(0).getAmount());
            }
            maxContents.set(hf.getTankCapacity(0));
        }
        return this.helper.getContentsValue(millis, contents.get(), maxContents.get());
    }

    public FluidBarScreenModule validate(Level world, BlockPos p, boolean isPlus) {
        if (isPlus) {
            return this.withActive(true);
        }
        if (LevelTools.isLoaded((Level)world, (BlockPos)this.pos.pos()) && Objects.equals(this.pos.dimension(), world.dimension())) {
            int dx = Math.abs(this.pos.pos().getX() - p.getX());
            int dy = Math.abs(this.pos.pos().getY() - p.getY());
            int dz = Math.abs(this.pos.pos().getZ() - p.getZ());
            if (dx <= 64 && dy <= 64 && dz <= 64) {
                return this.withActive(true);
            }
        }
        return this.withActive(false);
    }

    public int getRfPerTick() {
        return (Integer)ScreenConfiguration.FLUID_RFPERTICK.get();
    }

    public void mouseClick(Level world, int x, int y, boolean clicked, Player player) {
    }
}

