/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.items.modules;

import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mcjty.lib.crafting.IComponentsToPreserve;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.CapabilityTools;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.ModuleTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.api.screens.IClientScreenModule;
import mcjty.rftoolsbase.api.screens.IModuleGuiBuilder;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.tools.GenericModuleItem;
import mcjty.rftoolsutility.RFToolsUtility;
import mcjty.rftoolsutility.modules.screen.ScreenConfiguration;
import mcjty.rftoolsutility.modules.screen.ScreenModule;
import mcjty.rftoolsutility.modules.screen.modules.InventoryScreenModule;
import mcjty.rftoolsutility.modules.screen.modulesclient.InventoryClientScreenModule;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class InventoryModuleItem
extends GenericModuleItem
implements IComponentsToPreserve {
    public InventoryModuleItem() {
        super(RFToolsUtility.setup.defaultProperties().stacksTo(1).durability(1));
    }

    @Nullable
    public Codec<? extends IScreenModule<?, ?>> codec() {
        return InventoryScreenModule.CODEC;
    }

    @Nullable
    public StreamCodec<RegistryFriendlyByteBuf, ? extends IScreenModule<?, ?>> streamCodec() {
        return InventoryScreenModule.STREAM_CODEC;
    }

    @Nullable
    public DataComponentType<? extends IScreenModule<?, ?>> componentType() {
        return (DataComponentType)ScreenModule.MODULE_INVENTORY_DATA.get();
    }

    public IScreenModule<?, ?> createServerScreenModule() {
        return InventoryScreenModule.DEFAULT;
    }

    public IClientScreenModule<?> createClientScreenModule() {
        return new InventoryClientScreenModule();
    }

    protected int getUses(ItemStack stack) {
        return (Integer)ScreenConfiguration.ITEMSTACK_RFPERTICK.get();
    }

    protected boolean hasGoldMessage(ItemStack stack) {
        return !BlockPosTools.isValid((BlockPos)InventoryModuleItem.data(stack).getPos().pos());
    }

    protected String getInfoString(ItemStack stack) {
        InventoryScreenModule data = InventoryModuleItem.data(stack);
        return ModuleTools.getTargetString((String)data.getMonitor(), (GlobalPos)data.getPos());
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction facing = context.getClickedFace();
        Player player = context.getPlayer();
        BlockEntity te = world.getBlockEntity(pos);
        if (te == null) {
            if (world.isClientSide) {
                Logging.message((Player)player, (String)(String.valueOf(ChatFormatting.RED) + "This is not a valid inventory!"));
            }
            return InteractionResult.SUCCESS;
        }
        InventoryScreenModule data = InventoryModuleItem.data(stack);
        if (CapabilityTools.getItemCapabilitySafe((BlockEntity)te) != null) {
            data = data.withPos(GlobalPos.of((ResourceKey)world.dimension(), (BlockPos)pos));
            String name = "<invalid>";
            if (!world.getBlockState(pos).isAir()) {
                name = Tools.getReadableName((Level)world, (BlockPos)pos);
            }
            data = data.withMonitor(name);
            if (world.isClientSide) {
                Logging.message((Player)player, (String)("Inventory module is set to block '" + name + "'"));
            }
        } else {
            data = data.withPos(GlobalPos.of((ResourceKey)Level.OVERWORLD, (BlockPos)BlockPosTools.INVALID));
            data = data.withMonitor("");
            if (world.isClientSide) {
                Logging.message((Player)player, (String)"Inventory module is cleared");
            }
        }
        stack.set(ScreenModule.MODULE_INVENTORY_DATA, (Object)data);
        return InteractionResult.SUCCESS;
    }

    public String getModuleName() {
        return "Inv";
    }

    public static InventoryScreenModule data(ItemStack stack) {
        InventoryScreenModule data = (InventoryScreenModule)stack.get(ScreenModule.MODULE_INVENTORY_DATA);
        if (data == null) {
            data = InventoryScreenModule.DEFAULT;
        }
        return data;
    }

    public static void data(ItemStack stack, Function<InventoryScreenModule, InventoryScreenModule> setter) {
        InventoryScreenModule data = InventoryModuleItem.data(stack);
        data = setter.apply(data);
        stack.set(ScreenModule.MODULE_INVENTORY_DATA, (Object)data);
    }

    public void createGui(IModuleGuiBuilder guiBuilder) {
        guiBuilder.label("Slot 1:").integer((stack, index) -> InventoryModuleItem.data(stack).withSlot1((int)index), stack -> InventoryModuleItem.data(stack).getSlot1(), new String[]{"Slot index to show"}).nl().label("Slot 2:").integer((stack, index) -> InventoryModuleItem.data(stack).withSlot2((int)index), stack -> InventoryModuleItem.data(stack).getSlot2(), new String[]{"Slot index to show"}).nl().label("Slot 3:").integer((stack, index) -> InventoryModuleItem.data(stack).withSlot3((int)index), stack -> InventoryModuleItem.data(stack).getSlot3(), new String[]{"Slot index to show"}).nl().label("Slot 4:").integer((stack, index) -> InventoryModuleItem.data(stack).withSlot4((int)index), stack -> InventoryModuleItem.data(stack).getSlot4(), new String[]{"Slot index to show"}).nl().block(stack -> InventoryModuleItem.data(stack).getPos(), stack -> InventoryModuleItem.data(stack).getMonitor()).nl();
    }

    public Collection<DataComponentType<?>> getComponentsToPreserve() {
        return List.of((DataComponentType)ScreenModule.MODULE_INVENTORY_DATA.get());
    }
}

