/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.blocks;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.container.ItemInventory;
import mcjty.lib.api.module.DefaultModuleSupport;
import mcjty.lib.api.module.IModuleSupport;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ResultCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.network.Networking;
import mcjty.lib.network.PacketServerCommandTyped;
import mcjty.lib.setup.Registration;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolsbase.api.screens.IClientScreenModule;
import mcjty.rftoolsbase.api.screens.IModuleProvider;
import mcjty.rftoolsbase.api.screens.IScreenDataHelper;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.screens.IScreenModuleUpdater;
import mcjty.rftoolsbase.api.screens.ITooltipInfo;
import mcjty.rftoolsbase.api.screens.data.IModuleData;
import mcjty.rftoolsbase.api.screens.data.IModuleDataBoolean;
import mcjty.rftoolsbase.api.screens.data.IModuleDataContents;
import mcjty.rftoolsbase.api.screens.data.IModuleDataInteger;
import mcjty.rftoolsbase.api.screens.data.IModuleDataString;
import mcjty.rftoolsbase.tools.GenericModuleItem;
import mcjty.rftoolsutility.modules.screen.ScreenModule;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenBlock;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenContainer;
import mcjty.rftoolsutility.modules.screen.data.ModuleDataBoolean;
import mcjty.rftoolsutility.modules.screen.data.ModuleDataInteger;
import mcjty.rftoolsutility.modules.screen.data.ModuleDataString;
import mcjty.rftoolsutility.modules.screen.data.ScreenData;
import mcjty.rftoolsutility.modules.screen.items.modules.TextModuleItem;
import mcjty.rftoolsutility.modules.screen.modules.ScreenModuleHelper;
import mcjty.rftoolsutility.modules.screen.modules.TextScreenModule;
import mcjty.rftoolsutility.modules.screen.modulesclient.TextClientScreenModule;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;

public class ScreenTileEntity
extends TickingTileEntity {
    public List<String> infoReceived = Collections.emptyList();
    @GuiValue
    public static final Value<ScreenTileEntity, Boolean> VALUE_BRIGHT = Value.create((String)"bright", (Type)Type.BOOLEAN, ScreenTileEntity::isBright, ScreenTileEntity::setBright);
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, ScreenContainer.CONTAINER_FACTORY).onUpdate((slot, stack) -> this.resetModules()).build();
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private static final Function<ScreenTileEntity, GenericItemHandler> ITEM_CAP = be -> be.items;
    @Cap(type=CapType.CONTAINER)
    private static final Function<ScreenTileEntity, MenuProvider> SCREEN_CAP = be -> new DefaultContainerProvider("Screen").containerSupplier((windowId, player) -> ScreenContainer.create(windowId, be.getBlockPos(), (GenericTileEntity)be, player)).itemHandler(() -> be.items).setupSync((GenericTileEntity)be);
    @Cap(type=CapType.MODULE)
    private static final Function<ScreenTileEntity, IModuleSupport> MODULE_CAP = be -> new DefaultModuleSupport(0, 10){

        public boolean isModule(ItemStack itemStack) {
            return itemStack.getItem() instanceof IModuleProvider;
        }
    };
    public static final Map<GlobalPos, Map<Integer, IModuleData>> screenData = new HashMap<GlobalPos, Map<Integer, IModuleData>>();
    private List<Pair<ItemStack, IClientScreenModule<?>>> clientScreenModules = null;
    private ResourceKey<Level> dummyType = null;
    private boolean needsServerData = false;
    private boolean showHelp = true;
    private boolean powerOn = false;
    private boolean connected = false;
    private int hoveringModule = -1;
    private int hoveringX = -1;
    private int hoveringY = -1;
    public static final int SIZE_NORMAL = 0;
    public static final int SIZE_LARGE = 1;
    public static final int SIZE_HUGE = 2;
    private List<IScreenModule<?, ?>> screenModules = null;
    private Map<ActivatedModule, ModuleTicker> clickedModules = new HashMap<ActivatedModule, ModuleTicker>();
    private int totalRfPerTick = 0;
    private boolean controllerNeededInCreative = false;
    public long lastTime = 0L;
    private static List<Pair<ItemStack, IClientScreenModule<?>>> helpingScreenModules = null;
    private final IScreenDataHelper screenDataHelper = new IScreenDataHelper(this){

        public IModuleDataInteger createInteger(int i) {
            return new ModuleDataInteger(i);
        }

        public IModuleDataBoolean createBoolean(boolean b) {
            return new ModuleDataBoolean(b);
        }

        public IModuleDataString createString(String b) {
            return new ModuleDataString(b);
        }

        public IModuleDataContents createContents(long contents, long maxContents, long lastPerTick) {
            return new ScreenModuleHelper.ModuleDataContents(contents, maxContents, lastPerTick);
        }
    };
    public static final Key<Integer> PARAM_X = new Key("x", Type.INTEGER);
    public static final Key<Integer> PARAM_Y = new Key("y", Type.INTEGER);
    public static final Key<Integer> PARAM_MODULE = new Key("module", Type.INTEGER);
    public static final Key<Integer> PARAM_TRUETYPE = new Key("truetype", Type.INTEGER);
    @ServerCommand
    public static final Command<?> CMD_CLICK = Command.create((String)"screen.click", (te, player, params) -> te.hitScreenServer(player, (Integer)params.get(PARAM_X), (Integer)params.get(PARAM_Y), (Integer)params.get(PARAM_MODULE)));
    @ServerCommand
    public static final Command<?> CMD_HOVER = Command.create((String)"screen.hover", (te, player, params) -> {
        te.hoveringX = (Integer)params.get(PARAM_X);
        te.hoveringY = (Integer)params.get(PARAM_Y);
        te.hoveringModule = (Integer)params.get(PARAM_MODULE);
    });
    @ServerCommand
    public static final Command<?> CMD_SETTRUETYPE = Command.create((String)"screen.setTruetype", (te, player, params) -> te.setTrueTypeMode((Integer)params.get(PARAM_TRUETYPE)));
    public static final Key<List<String>> PARAM_INFO = new Key("info", Type.STRING_LIST);
    @ServerCommand
    public static final ResultCommand<?> CMD_SCREEN_INFO = ResultCommand.create((String)"getScreenInfo", (te, player, params) -> {
        IScreenModule<?, ?> module = te.getHoveringModule((Integer)params.get(PARAM_MODULE));
        List info = Collections.emptyList();
        if (module instanceof ITooltipInfo) {
            info = ((ITooltipInfo)module).getInfo(te.level, ((Integer)params.get(PARAM_X)).intValue(), ((Integer)params.get(PARAM_Y)).intValue());
        }
        return TypedMap.builder().put(PARAM_INFO, info).build();
    }, (te, player, params) -> {
        te.infoReceived = (List)params.get(PARAM_INFO);
    });

    public ScreenTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ScreenModule.SCREEN.be().get(), pos, state);
    }

    public ScreenTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public ScreenTileEntity(ResourceKey<Level> world, BlockPos pos) {
        this(pos, null);
        this.dummyType = world;
    }

    public ScreenTileEntity(BlockEntityType<?> type, ResourceKey<Level> world, BlockPos pos) {
        this(type, pos, null);
        this.dummyType = world;
    }

    public boolean isDummy() {
        return this.dummyType != null;
    }

    public ResourceKey<Level> getDimension() {
        if (this.dummyType != null) {
            return this.dummyType;
        }
        return super.getDimension();
    }

    protected void tickClient() {
        this.tickMe();
    }

    public void tickMe() {
        if (this.clickedModules.isEmpty()) {
            return;
        }
        HashMap<ActivatedModule, ModuleTicker> newClickedModules = new HashMap<ActivatedModule, ModuleTicker>();
        for (Map.Entry<ActivatedModule, ModuleTicker> cm : this.clickedModules.entrySet()) {
            Pair<ItemStack, IClientScreenModule<?>> pair;
            --cm.getValue().ticks;
            ActivatedModule activatedModule = cm.getKey();
            if (cm.getValue().ticks > 0) {
                newClickedModules.put(activatedModule, cm.getValue());
                continue;
            }
            List<Pair<ItemStack, IClientScreenModule<?>>> modules = this.getClientScreenModules();
            if (activatedModule.module >= modules.size() || (pair = modules.get(activatedModule.module)) == null || pair.getRight() == null) continue;
            ((IClientScreenModule)pair.getRight()).mouseClick((ItemStack)pair.getLeft(), this.level, activatedModule.x, activatedModule.y, false);
        }
        this.clickedModules = newClickedModules;
    }

    protected void tickServer() {
        if (this.clickedModules.isEmpty()) {
            return;
        }
        HashMap<ActivatedModule, ModuleTicker> newClickedModules = new HashMap<ActivatedModule, ModuleTicker>();
        for (Map.Entry<ActivatedModule, ModuleTicker> cm : this.clickedModules.entrySet()) {
            --cm.getValue().ticks;
            ActivatedModule activatedModule = cm.getKey();
            if (cm.getValue().ticks > 0) {
                newClickedModules.put(activatedModule, cm.getValue());
                continue;
            }
            List<IScreenModule<?, ?>> modules = this.getScreenModules();
            if (activatedModule.module >= modules.size()) continue;
            ItemStack itemStack = this.items.getStackInSlot(activatedModule.module);
            IScreenModule<?, ?> module = modules.get(activatedModule.module);
            module.mouseClick(this.level, activatedModule.x, activatedModule.y, false, null);
            if (!(module instanceof IScreenModuleUpdater)) continue;
        }
        this.clickedModules = newClickedModules;
    }

    private void resetModules() {
        this.clientScreenModules = null;
        this.screenModules = null;
        this.clickedModules.clear();
        this.showHelp = true;
    }

    private boolean isActivated(int index) {
        for (ActivatedModule module : this.clickedModules.keySet()) {
            if (module.module != index) continue;
            return true;
        }
        return false;
    }

    public void focusModuleClient(double hitX, double hitY, double hitZ, Direction side, Direction horizontalFacing) {
        int module;
        int y;
        int x;
        ScreenData data = (ScreenData)this.getData(ScreenModule.SCREEN_DATA);
        ModuleRaytraceResult result = this.getHitModule(hitX, hitY, hitZ, side, horizontalFacing, data.size());
        if (result == null) {
            x = -1;
            y = -1;
            module = -1;
        } else {
            x = result.x();
            y = result.y() - result.currenty();
            module = result.moduleIndex();
        }
        if (x != this.hoveringX || y != this.hoveringY || module != this.hoveringModule) {
            PacketServerCommandTyped packet = PacketServerCommandTyped.create((BlockPos)this.getBlockPos(), this.getDimension(), (String)CMD_HOVER.name(), (TypedMap)TypedMap.builder().put(PARAM_X, (Object)x).put(PARAM_Y, (Object)y).put(PARAM_MODULE, (Object)module).build());
            Networking.sendToServer((CustomPacketPayload)packet);
            this.hoveringX = x;
            this.hoveringY = y;
            this.hoveringModule = module;
        }
    }

    public void hitScreenClient(double hitX, double hitY, double hitZ, Direction side, Direction horizontalFacing) {
        ScreenData data = (ScreenData)this.getData(ScreenModule.SCREEN_DATA);
        ModuleRaytraceResult result = this.getHitModule(hitX, hitY, hitZ, side, horizontalFacing, data.size());
        if (result == null) {
            return;
        }
        this.hitScreenClient(result);
    }

    public void hitScreenClient(ModuleRaytraceResult result) {
        List<Pair<ItemStack, IClientScreenModule<?>>> modules = this.getClientScreenModules();
        int module = result.moduleIndex();
        if (this.isActivated(module)) {
            return;
        }
        ((IClientScreenModule)modules.get(module).getRight()).mouseClick((ItemStack)modules.get(module).getLeft(), this.level, result.x(), result.y() - result.currenty(), true);
        this.clickedModules.put(new ActivatedModule(module, result.x(), result.y()), new ModuleTicker(3));
        PacketServerCommandTyped packet = PacketServerCommandTyped.create((BlockPos)this.getBlockPos(), this.getDimension(), (String)CMD_CLICK.name(), (TypedMap)TypedMap.builder().put(PARAM_X, (Object)result.x()).put(PARAM_Y, (Object)(result.y() - result.currenty())).put(PARAM_MODULE, (Object)module).build());
        Networking.sendToServer((CustomPacketPayload)packet);
    }

    public ModuleRaytraceResult getHitModule(double hitX, double hitY, double hitZ, Direction side, Direction horizontalFacing, int size) {
        float factor = (float)size + 1.0f;
        float dx = 0.0f;
        float dy = 0.0f;
        switch (side) {
            case NORTH: {
                dx = (float)((1.0 - hitX) / (double)factor);
                dy = (float)((1.0 - hitY) / (double)factor);
                break;
            }
            case SOUTH: {
                dx = (float)(hitX / (double)factor);
                dy = (float)((1.0 - hitY) / (double)factor);
                break;
            }
            case WEST: {
                dx = (float)(hitZ / (double)factor);
                dy = (float)((1.0 - hitY) / (double)factor);
                break;
            }
            case EAST: {
                dx = (float)((1.0 - hitZ) / (double)factor);
                dy = (float)((1.0 - hitY) / (double)factor);
                break;
            }
            case UP: {
                switch (horizontalFacing) {
                    case NORTH: {
                        dx = (float)((1.0 - hitX) / (double)factor);
                        dy = (float)((1.0 - hitZ) / (double)factor);
                        break;
                    }
                    case SOUTH: {
                        dx = (float)(hitX / (double)factor);
                        dy = (float)(hitZ / (double)factor);
                        break;
                    }
                    case WEST: {
                        dx = (float)(hitZ / (double)factor);
                        dy = (float)((1.0 - hitX) / (double)factor);
                        break;
                    }
                    case EAST: {
                        dx = (float)((1.0 - hitZ) / (double)factor);
                        dy = (float)(hitX / (double)factor);
                    }
                }
                break;
            }
            case DOWN: {
                switch (horizontalFacing) {
                    case NORTH: {
                        dx = (float)((1.0 - hitX) / (double)factor);
                        dy = (float)(hitZ / (double)factor);
                        break;
                    }
                    case SOUTH: {
                        dx = (float)(hitX / (double)factor);
                        dy = (float)((1.0 - hitZ) / (double)factor);
                        break;
                    }
                    case WEST: {
                        dx = (float)(hitZ / (double)factor);
                        dy = (float)(hitX / (double)factor);
                        break;
                    }
                    case EAST: {
                        dx = (float)((1.0 - hitZ) / (double)factor);
                        dy = (float)((1.0 - hitX) / (double)factor);
                    }
                }
                break;
            }
            default: {
                return null;
            }
        }
        int x = (int)(dx * 128.0f);
        int y = (int)(dy * 128.0f);
        int currenty = 7;
        int moduleIndex = 0;
        List<Pair<ItemStack, IClientScreenModule<?>>> clientScreenModules = this.getClientScreenModules();
        for (Pair<ItemStack, IClientScreenModule<?>> pair : clientScreenModules) {
            int height;
            IClientScreenModule module;
            if (pair != null && (module = (IClientScreenModule)pair.getRight()) != null && currenty + (height = module.getHeight((ItemStack)pair.getLeft())) <= 124) {
                if (currenty <= y && y < currenty + height) break;
                currenty += height;
            }
            ++moduleIndex;
        }
        if (moduleIndex >= clientScreenModules.size()) {
            return null;
        }
        return new ModuleRaytraceResult(moduleIndex, x, y, currenty);
    }

    private void hitScreenServer(Player player, int x, int y, int module) {
        List<IScreenModule<?, ?>> screenModules = this.getScreenModules();
        IScreenModule<?, ?> screenModule = screenModules.get(module);
        if (screenModule != null) {
            ItemStack itemStack = this.items.getStackInSlot(module);
            screenModule.mouseClick(this.level, x, y, true, player);
            if (screenModule instanceof IScreenModuleUpdater) {
                IScreenModuleUpdater iScreenModuleUpdater = (IScreenModuleUpdater)screenModule;
            }
            this.clickedModules.put(new ActivatedModule(module, x, y), new ModuleTicker(5));
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.items.load(tag, "items", provider);
        this.powerOn = tag.getBoolean("powerOn");
        this.connected = tag.getBoolean("connected");
        this.totalRfPerTick = tag.getInt("rfPerTick");
        this.controllerNeededInCreative = tag.getBoolean("controllerNeededInCreative");
        this.resetModules();
    }

    public void saveAdditional(@Nonnull CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        this.items.save(tag, "items", provider);
        tag.putBoolean("powerOn", this.powerOn);
        tag.putBoolean("connected", this.connected);
        tag.putInt("rfPerTick", this.totalRfPerTick);
        tag.putBoolean("controllerNeededInCreative", this.controllerNeededInCreative);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        ScreenData data = (ScreenData)input.get(ScreenModule.ITEM_SCREEN_DATA);
        if (data != null) {
            this.setData(ScreenModule.SCREEN_DATA, data);
        }
        this.items.applyImplicitComponents((ItemInventory)input.get((Supplier)Registration.ITEM_INVENTORY));
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(ScreenModule.ITEM_SCREEN_DATA, (Object)((ScreenData)this.getData(ScreenModule.SCREEN_DATA)));
        this.items.collectImplicitComponents(builder);
    }

    public void saveClientDataToNBT(CompoundTag tag, HolderLookup.Provider provider) {
        tag.putBoolean("powerOn", this.powerOn);
        tag.putBoolean("connected", this.connected);
        ScreenData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)((ScreenData)this.getData(ScreenModule.SCREEN_DATA))).result().ifPresent(data -> tag.put("data", data));
        this.items.save(tag, "items", provider);
    }

    public void loadClientDataFromNBT(CompoundTag tag, HolderLookup.Provider provider) {
        this.powerOn = tag.getBoolean("powerOn");
        this.connected = tag.getBoolean("connected");
        ScreenData.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("data")).result().ifPresent(data -> this.setData(ScreenModule.SCREEN_DATA, (ScreenData)data.getFirst()));
        this.items.load(tag, "items", provider);
        this.resetModules();
    }

    public int getColor() {
        ScreenData data = (ScreenData)this.getData(ScreenModule.SCREEN_DATA);
        return data.color();
    }

    public void setColor(int color) {
        ScreenData data = (ScreenData)this.getData(ScreenModule.SCREEN_DATA);
        data = data.withColor(color);
        this.setData(ScreenModule.SCREEN_DATA, data);
    }

    public void setSize(int size) {
        ScreenData data = (ScreenData)this.getData(ScreenModule.SCREEN_DATA);
        data = data.withSize(size);
        this.setData(ScreenModule.SCREEN_DATA, data);
    }

    public int getSize() {
        ScreenData data = (ScreenData)this.getData(ScreenModule.SCREEN_DATA);
        return data.size();
    }

    public boolean isBright() {
        ScreenData data = (ScreenData)this.getData(ScreenModule.SCREEN_DATA);
        return data.bright();
    }

    public void setBright(boolean bright) {
        ScreenData data = (ScreenData)this.getData(ScreenModule.SCREEN_DATA);
        data = data.withBright(bright);
        this.setData(ScreenModule.SCREEN_DATA, data);
    }

    public int getTrueTypeMode() {
        ScreenData data = (ScreenData)this.getData(ScreenModule.SCREEN_DATA);
        return data.trueTypeMode();
    }

    public void setTrueTypeMode(int trueTypeMode) {
        ScreenData data = (ScreenData)this.getData(ScreenModule.SCREEN_DATA);
        data = data.withTrueTypeMode(trueTypeMode);
        this.setData(ScreenModule.SCREEN_DATA, data);
    }

    public void setTransparent(boolean transparent) {
        ScreenData data = (ScreenData)this.getData(ScreenModule.SCREEN_DATA);
        data = data.withTransparent(transparent);
        this.setData(ScreenModule.SCREEN_DATA, data);
    }

    public boolean isTransparent() {
        ScreenData data = (ScreenData)this.getData(ScreenModule.SCREEN_DATA);
        return data.transparent();
    }

    public void setPower(boolean power) {
        if (this.powerOn == power) {
            return;
        }
        this.powerOn = power;
        this.markDirtyClient();
    }

    public boolean isPowerOn() {
        return this.powerOn;
    }

    public boolean isRenderable() {
        if (this.powerOn) {
            return true;
        }
        if (this.isShowHelp()) {
            return true;
        }
        return this.isCreative();
    }

    public boolean isCreative() {
        return false;
    }

    public void setConnected(boolean c) {
        if (this.connected == c) {
            return;
        }
        this.connected = c;
        this.setChanged();
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void updateModuleData(int slot, ItemStack newStack) {
        this.items.setStackInSlot(slot, newStack);
        this.screenModules = null;
        this.clientScreenModules = null;
        this.markDirtyClient();
    }

    public static List<Pair<ItemStack, IClientScreenModule<?>>> getHelpingScreenModules() {
        if (helpingScreenModules == null) {
            helpingScreenModules = new ArrayList();
            ScreenTileEntity.addLine("Read me", 0x7799FF, true);
            ScreenTileEntity.addLine("", 0xFFFFFF, false);
            ScreenTileEntity.addLine("Sneak-right click for", 0xFFFFFF, false);
            ScreenTileEntity.addLine("GUI and insertion of", 0xFFFFFF, false);
            ScreenTileEntity.addLine("modules", 0xFFFFFF, false);
            ScreenTileEntity.addLine("", 0xFFFFFF, false);
            ScreenTileEntity.addLine("Use Screen Controller", 0xFFFFFF, false);
            ScreenTileEntity.addLine("to power screens", 0xFFFFFF, false);
            ScreenTileEntity.addLine("remotely", 0xFFFFFF, false);
        }
        return helpingScreenModules;
    }

    private static void addLine(String s, int color, boolean large) {
        ItemStack textModuleItem = new ItemStack((ItemLike)ScreenModule.TEXT_MODULE.get());
        TextScreenModule data = TextModuleItem.data(textModuleItem);
        data = data.withLine(s);
        data = data.withColor(color);
        data = data.withLarge(large);
        textModuleItem.set(ScreenModule.MODULE_TEXT_DATA, (Object)data);
        TextClientScreenModule t1 = new TextClientScreenModule();
        helpingScreenModules.add(Pair.of((Object)textModuleItem, (Object)t1));
    }

    public List<Pair<ItemStack, IClientScreenModule<?>>> getClientScreenModules() {
        if (this.clientScreenModules == null) {
            this.needsServerData = false;
            this.showHelp = true;
            this.clientScreenModules = new ArrayList();
            for (int i = 0; i < this.items.getSlots(); ++i) {
                ItemStack itemStack = this.items.getStackInSlot(i);
                if (!itemStack.isEmpty() && ScreenBlock.hasModuleProvider(itemStack)) {
                    IModuleProvider moduleProvider = ScreenBlock.getModuleProvider(itemStack);
                    IClientScreenModule clientScreenModule = moduleProvider.createClientScreenModule();
                    this.clientScreenModules.add(Pair.of((Object)itemStack, (Object)clientScreenModule));
                    if (clientScreenModule.needsServerData()) {
                        this.needsServerData = true;
                    }
                    this.showHelp = false;
                    continue;
                }
                this.clientScreenModules.add(null);
            }
        }
        return this.clientScreenModules;
    }

    public boolean isShowHelp() {
        return this.showHelp;
    }

    public boolean isNeedsServerData() {
        return this.needsServerData;
    }

    public int getTotalRfPerTick() {
        if (this.isCreative()) {
            return 0;
        }
        if (this.screenModules == null) {
            this.getScreenModules();
        }
        return this.totalRfPerTick;
    }

    public boolean isControllerNeeded() {
        if (!this.isCreative()) {
            return true;
        }
        if (this.screenModules == null) {
            this.getScreenModules();
        }
        return this.controllerNeededInCreative;
    }

    public List<IScreenModule<?, ?>> getScreenModules() {
        if (this.screenModules == null) {
            this.totalRfPerTick = 0;
            this.controllerNeededInCreative = false;
            this.screenModules = new ArrayList();
            for (int i = 0; i < this.items.getSlots(); ++i) {
                ItemStack itemStack = this.items.getStackInSlot(i);
                if (!itemStack.isEmpty() && ScreenBlock.hasModuleProvider(itemStack)) {
                    GenericModuleItem mi;
                    Item item;
                    IScreenModule screenModule;
                    IModuleProvider moduleProvider = ScreenBlock.getModuleProvider(itemStack);
                    IScreenModule iScreenModule = screenModule = moduleProvider.componentType() != null ? (IScreenModule)itemStack.get(moduleProvider.componentType()) : null;
                    if (screenModule == null) {
                        screenModule = moduleProvider.createServerScreenModule();
                    }
                    boolean isPlus = (item = itemStack.getItem()) instanceof GenericModuleItem && (mi = (GenericModuleItem)item).isPlusModule();
                    screenModule = screenModule.validate(this.level, this.getBlockPos(), isPlus);
                    this.screenModules.add(screenModule);
                    this.totalRfPerTick += screenModule.getRfPerTick() * (isPlus ? 5 : 1);
                    if (!screenModule.needsController()) continue;
                    this.controllerNeededInCreative = true;
                    continue;
                }
                this.screenModules.add(null);
            }
        }
        return this.screenModules;
    }

    public Map<Integer, IModuleData> getScreenData(long millis) {
        HashMap<Integer, IModuleData> map = new HashMap<Integer, IModuleData>();
        List<IScreenModule<?, ?>> screenModules = this.getScreenModules();
        int moduleIndex = 0;
        for (IScreenModule<?, ?> module : screenModules) {
            IModuleData data;
            if (module != null && (data = module.getData(this.screenDataHelper, this.level, millis)) != null) {
                map.put(moduleIndex, data);
            }
            ++moduleIndex;
        }
        return map;
    }

    public IScreenModule<?, ?> getHoveringModule() {
        return this.getHoveringModule(this.hoveringModule);
    }

    public IScreenModule<?, ?> getHoveringModule(int hoveringModule) {
        if (hoveringModule == -1) {
            return null;
        }
        this.getScreenModules();
        if (hoveringModule >= 0 && hoveringModule < this.screenModules.size()) {
            return this.screenModules.get(hoveringModule);
        }
        return null;
    }

    public int getHoveringX() {
        return this.hoveringX;
    }

    public int getHoveringY() {
        return this.hoveringY;
    }

    private static class ModuleTicker {
        private int ticks;

        public ModuleTicker(int ticks) {
            this.ticks = ticks;
        }
    }

    private record ActivatedModule(int module, int x, int y) {
    }

    public record ModuleRaytraceResult(int moduleIndex, int x, int y, int currenty) {
    }
}

