/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen;

import java.util.HashMap;
import mcjty.lib.api.information.CapabilityPowerInformation;
import mcjty.lib.api.information.IPowerInformation;
import mcjty.lib.varia.EnergyTools;
import mcjty.rftoolsutility.modules.screen.MachineInfo;
import mcjty.rftoolsutility.modules.screen.network.PacketReturnRfInRange;
import mcjty.rftoolsutility.setup.RFToolsUtilityMessages;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class RFToolsTools {
    public static void returnRfInRange(Player player) {
        BlockPos pos = player.blockPosition();
        Level world = player.getCommandSenderWorld();
        HashMap<BlockPos, MachineInfo> result = new HashMap<BlockPos, MachineInfo>();
        int range = 12;
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    BlockPos p = pos.offset(x, y, z);
                    BlockEntity te = world.getBlockEntity(p);
                    if (!EnergyTools.isEnergyTE((BlockEntity)te, null)) continue;
                    EnergyTools.EnergyLevel level = EnergyTools.getEnergyLevel((BlockEntity)te, null);
                    IPowerInformation powerInformation = (IPowerInformation)world.getCapability(CapabilityPowerInformation.POWER_INFORMATION_CAPABILITY, p, null);
                    if (powerInformation == null) continue;
                    Long usage = powerInformation.getEnergyDiffPerTick();
                    result.put(p, new MachineInfo(level.energy(), level.maxEnergy(), usage));
                }
            }
        }
        RFToolsUtilityMessages.sendToPlayer(PacketReturnRfInRange.create(result), player);
    }
}

