/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.environmental.blocks;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.container.ItemInventory;
import mcjty.lib.api.information.IPowerInformation;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.api.infusable.ItemInfusable;
import mcjty.lib.api.module.DefaultModuleSupport;
import mcjty.lib.api.module.IModuleSupport;
import mcjty.lib.api.power.ItemEnergy;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ListCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.setup.Registration;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.NamedEnum;
import mcjty.lib.varia.RedstoneMode;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsutility.compat.RFToolsUtilityTOPDriver;
import mcjty.rftoolsutility.modules.environmental.EnvModuleProvider;
import mcjty.rftoolsutility.modules.environmental.EnvironmentalConfiguration;
import mcjty.rftoolsutility.modules.environmental.EnvironmentalModule;
import mcjty.rftoolsutility.modules.environmental.blocks.EnvironmentalMode;
import mcjty.rftoolsutility.modules.environmental.data.EnvironmentalData;
import mcjty.rftoolsutility.modules.environmental.modules.EnvironmentModule;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.Lazy;

public class EnvironmentalControllerTileEntity
extends TickingTileEntity {
    public static final String COMPONENT_NAME = "environmental_controller";
    public static final int ENV_MODULES = 7;
    public static final int SLOT_MODULES = 0;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(7).box(SlotDefinition.specific(s -> s.getItem() instanceof EnvModuleProvider).in().out(), 0, 7, 8, 1, 7).playerSlots(27, 142));
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).itemValid((slot, stack) -> stack.getItem() instanceof EnvModuleProvider).onUpdate((slot, stack) -> {
        this.environmentModules = null;
    }).build();
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private static final Function<EnvironmentalControllerTileEntity, GenericItemHandler> ITEM_CAP = tile -> tile.items;
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)EnvironmentalConfiguration.ENVIRONMENTAL_MAXENERGY.get()).intValue(), (long)((Integer)EnvironmentalConfiguration.ENVIRONMENTAL_RECEIVEPERTICK.get()).intValue());
    @Cap(type=CapType.ENERGY)
    private static final Function<EnvironmentalControllerTileEntity, GenericEnergyStorage> ENERGY_CAP = tile -> tile.energyStorage;
    private final DefaultInfusable infusable = new DefaultInfusable((BlockEntity)this);
    @Cap(type=CapType.INFUSABLE)
    private static final Function<EnvironmentalControllerTileEntity, IInfusable> INFUSABLE_CAP = tile -> tile.infusable;
    private final IPowerInformation powerInfoHandler = this.createPowerInfo();
    @Cap(type=CapType.POWER_INFO)
    private static final Function<EnvironmentalControllerTileEntity, IPowerInformation> POWER_INFO_CAP = tile -> tile.powerInfoHandler;
    @Cap(type=CapType.MODULE)
    private static final Function<EnvironmentalControllerTileEntity, IModuleSupport> MODULE_CAP = tile -> new DefaultModuleSupport(0, 6){

        public boolean isModule(ItemStack itemStack) {
            return itemStack.getItem() instanceof EnvModuleProvider;
        }
    };
    @Cap(type=CapType.CONTAINER)
    private static final Function<EnvironmentalControllerTileEntity, MenuProvider> SCREEN_CAP = tile -> new DefaultContainerProvider("Environmental Controller").containerSupplier(DefaultContainerProvider.container(EnvironmentalModule.CONTAINER_ENVIRONENTAL_CONTROLLER, CONTAINER_FACTORY, (GenericTileEntity)tile)).itemHandler(() -> tile.items).energyHandler(() -> tile.energyStorage).setupSync((GenericTileEntity)tile);
    private List<EnvironmentModule> environmentModules = null;
    private int totalRfPerTick = 0;
    @GuiValue
    public static final Value<?, ?> VALUE_MODE = Value.createEnum((String)"mode", (NamedEnum[])EnvironmentalMode.values(), EnvironmentalControllerTileEntity::getMode, EnvironmentalControllerTileEntity::setMode);
    @GuiValue
    public static final Value<?, ?> VALUE_RADIUS = Value.create((String)"radius", (Type)Type.INTEGER, EnvironmentalControllerTileEntity::getRadius, EnvironmentalControllerTileEntity::setRadius);
    @GuiValue
    public static final Value<?, ?> VALUE_MINY = Value.create((String)"miny", (Type)Type.INTEGER, EnvironmentalControllerTileEntity::getMiny, EnvironmentalControllerTileEntity::setMiny);
    @GuiValue
    public static final Value<?, ?> VALUE_MAXY = Value.create((String)"maxy", (Type)Type.INTEGER, EnvironmentalControllerTileEntity::getMaxy, EnvironmentalControllerTileEntity::setMaxy);
    private int volume = -1;
    private boolean active = false;
    private int powerTimeout = 0;
    @ServerCommand
    public static final Command<?> CMD_RSMODE = Command.create((String)"env.setRsMode", (te, player, params) -> te.setRSMode(RedstoneMode.values()[(Integer)params.get(ImageChoiceLabel.PARAM_CHOICE_IDX)]));
    public static final Key<Integer> PARAM_MIN = new Key("min", Type.INTEGER);
    public static final Key<Integer> PARAM_MAX = new Key("max", Type.INTEGER);
    @ServerCommand
    public static final Command<?> CMD_SETBOUNDS = Command.create((String)"env.setBounds", (te, player, params) -> {
        te.setMiny((Integer)params.get(PARAM_MIN));
        te.setMaxy((Integer)params.get(PARAM_MAX));
    });
    public static final Key<Integer> PARAM_MODE = new Key("mode", Type.INTEGER);
    @ServerCommand
    public static final Command<?> CMD_SETMODE = Command.create((String)"env.setBlacklist", (te, player, params) -> te.setMode(EnvironmentalMode.values()[(Integer)params.get(PARAM_MODE)]));
    public static final Key<String> PARAM_NAME = new Key("name", Type.STRING);
    @ServerCommand
    public static final Command<?> CMD_ADDPLAYER = Command.create((String)"env.addPlayer", (te, player, params) -> te.addPlayer((String)params.get(PARAM_NAME)));
    @ServerCommand
    public static final Command<?> CMD_DELPLAYER = Command.create((String)"env.delPlayer", (te, player, params) -> te.delPlayer((String)params.get(PARAM_NAME)));
    @ServerCommand(type=String.class)
    public static final ListCommand<?, ?> CMD_GETPLAYERS = ListCommand.create((String)"rftoolsutility.env.getPlayers", (te, player, params) -> te.getPlayersAsList(), (te, player, params, list) -> {
        EnvironmentalData data = (EnvironmentalData)te.getData(EnvironmentalModule.ENVIRONMENTAL_DATA);
        data = data.withPlayers(new HashSet<String>(list));
        te.setData(EnvironmentalModule.ENVIRONMENTAL_DATA, data);
    });

    public EnvironmentalControllerTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EnvironmentalModule.ENVIRONENTAL_CONTROLLER.be().get(), pos, state);
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().properties(BlockBehaviour.Properties.of().strength(2.0f).sound(SoundType.METAL).lightLevel(value -> 13)).tileEntitySupplier(EnvironmentalControllerTileEntity::new).topDriver((TOPDriver)RFToolsUtilityTOPDriver.DRIVER).infusable().manualEntry(ManualHelper.create((String)"rftoolsutility:machines/environmental")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()})){

            public RotationType getRotationType() {
                return RotationType.NONE;
            }
        };
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    public EnvironmentalMode getMode() {
        EnvironmentalData data = (EnvironmentalData)this.getData(EnvironmentalModule.ENVIRONMENTAL_DATA);
        return data.mode();
    }

    public void setMode(EnvironmentalMode mode) {
        EnvironmentalData data = (EnvironmentalData)this.getData(EnvironmentalModule.ENVIRONMENTAL_DATA);
        data = data.withMode(mode);
        this.setData(EnvironmentalModule.ENVIRONMENTAL_DATA, data);
    }

    private float getPowerMultiplier() {
        EnvironmentalData data = (EnvironmentalData)this.getData(EnvironmentalModule.ENVIRONMENTAL_DATA);
        return switch (data.mode()) {
            default -> throw new MatchException(null, null);
            case EnvironmentalMode.MODE_BLACKLIST, EnvironmentalMode.MODE_WHITELIST -> 1.0f;
            case EnvironmentalMode.MODE_HOSTILE, EnvironmentalMode.MODE_PASSIVE, EnvironmentalMode.MODE_MOBS, EnvironmentalMode.MODE_ALL -> (float)((Double)EnvironmentalConfiguration.mobsPowerMultiplier.get()).doubleValue();
        };
    }

    public boolean isEntityAffected(Entity entity) {
        EnvironmentalData data = (EnvironmentalData)this.getData(EnvironmentalModule.ENVIRONMENTAL_DATA);
        switch (data.mode()) {
            case MODE_BLACKLIST: {
                if (entity instanceof Player) {
                    return this.isPlayerAffected((Player)entity);
                }
                return false;
            }
            case MODE_WHITELIST: {
                if (entity instanceof Player) {
                    return this.isPlayerAffected((Player)entity);
                }
                return false;
            }
            case MODE_HOSTILE: {
                return entity instanceof Enemy;
            }
            case MODE_PASSIVE: {
                return entity instanceof Mob && !(entity instanceof Enemy);
            }
            case MODE_MOBS: {
                return entity instanceof Mob;
            }
            case MODE_ALL: {
                if (entity instanceof Player) {
                    return this.isPlayerAffected((Player)entity);
                }
                return true;
            }
        }
        return false;
    }

    public boolean isPlayerAffected(Player player) {
        EnvironmentalData data = (EnvironmentalData)this.getData(EnvironmentalModule.ENVIRONMENTAL_DATA);
        if (data.mode() == EnvironmentalMode.MODE_WHITELIST) {
            return data.players().contains(player.getName().getString());
        }
        if (data.mode() == EnvironmentalMode.MODE_BLACKLIST) {
            return !data.players().contains(player.getName().getString());
        }
        return data.mode() == EnvironmentalMode.MODE_ALL;
    }

    public List<String> getPlayersAsList() {
        EnvironmentalData data = (EnvironmentalData)this.getData(EnvironmentalModule.ENVIRONMENTAL_DATA);
        return new ArrayList<String>(data.players());
    }

    private void addPlayer(String player) {
        EnvironmentalData data = (EnvironmentalData)this.getData(EnvironmentalModule.ENVIRONMENTAL_DATA);
        Set<String> players = data.players();
        if (!players.contains(player)) {
            players.add(player);
            this.setData(EnvironmentalModule.ENVIRONMENTAL_DATA, data.withPlayers(players));
        }
    }

    private void delPlayer(String player) {
        EnvironmentalData data = (EnvironmentalData)this.getData(EnvironmentalModule.ENVIRONMENTAL_DATA);
        Set<String> players = data.players();
        if (players.contains(player)) {
            players.remove(player);
            this.setData(EnvironmentalModule.ENVIRONMENTAL_DATA, data.withPlayers(players));
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public int getTotalRfPerTick() {
        if (this.environmentModules == null) {
            this.getEnvironmentModules();
        }
        float factor = this.infusable.getInfusedFactor();
        int rfNeeded = (int)((float)this.totalRfPerTick * this.getPowerMultiplier() * (4.0f - factor) / 4.0f);
        if (this.environmentModules.isEmpty()) {
            return rfNeeded;
        }
        if (rfNeeded < (Integer)EnvironmentalConfiguration.MIN_USAGE.get()) {
            rfNeeded = (Integer)EnvironmentalConfiguration.MIN_USAGE.get();
        }
        return rfNeeded;
    }

    public int getVolume() {
        if (this.volume == -1) {
            EnvironmentalData data = (EnvironmentalData)this.getData(EnvironmentalModule.ENVIRONMENTAL_DATA);
            this.volume = (int)((double)(data.radius() * data.radius()) * Math.PI * (double)(data.maxy() - data.miny() + 1));
        }
        return this.volume;
    }

    public int getRadius() {
        EnvironmentalData data = (EnvironmentalData)this.getData(EnvironmentalModule.ENVIRONMENTAL_DATA);
        return data.radius();
    }

    public void setRadius(int radius) {
        EnvironmentalData data = (EnvironmentalData)this.getData(EnvironmentalModule.ENVIRONMENTAL_DATA);
        data = data.withRadius(radius);
        this.setData(EnvironmentalModule.ENVIRONMENTAL_DATA, data);
        this.volume = -1;
        this.environmentModules = null;
    }

    public int getMiny() {
        EnvironmentalData data = (EnvironmentalData)this.getData(EnvironmentalModule.ENVIRONMENTAL_DATA);
        return data.miny();
    }

    public void setMiny(int miny) {
        if (miny == Integer.MIN_VALUE) {
            return;
        }
        EnvironmentalData data = (EnvironmentalData)this.getData(EnvironmentalModule.ENVIRONMENTAL_DATA);
        data = data.withMiny(miny);
        this.setData(EnvironmentalModule.ENVIRONMENTAL_DATA, data);
        this.volume = -1;
        this.environmentModules = null;
    }

    public int getMaxy() {
        EnvironmentalData data = (EnvironmentalData)this.getData(EnvironmentalModule.ENVIRONMENTAL_DATA);
        return data.maxy();
    }

    public void setMaxy(int maxy) {
        if (maxy == Integer.MIN_VALUE) {
            return;
        }
        EnvironmentalData data = (EnvironmentalData)this.getData(EnvironmentalModule.ENVIRONMENTAL_DATA);
        data = data.withMaxy(maxy);
        this.setData(EnvironmentalModule.ENVIRONMENTAL_DATA, data);
        this.volume = -1;
        this.environmentModules = null;
    }

    protected void tickServer() {
        if (this.powerTimeout > 0) {
            --this.powerTimeout;
            return;
        }
        long rf = this.energyStorage.getEnergyStored();
        if (!this.isMachineEnabled()) {
            rf = 0L;
        }
        this.getEnvironmentModules();
        int rfNeeded = this.getTotalRfPerTick();
        if ((long)rfNeeded > rf || this.environmentModules.isEmpty()) {
            this.deactivate();
            this.powerTimeout = 20;
        } else {
            this.energyStorage.consumeEnergy((long)rfNeeded);
            for (EnvironmentModule module : this.environmentModules) {
                module.activate(true);
                EnvironmentalData data = (EnvironmentalData)this.getData(EnvironmentalModule.ENVIRONMENTAL_DATA);
                module.tick(this.level, this.getBlockPos(), data.radius(), data.miny(), data.maxy(), this);
            }
            if (!this.active) {
                this.active = true;
                this.markDirtyClient();
            }
        }
    }

    public void deactivate() {
        for (EnvironmentModule module : this.environmentModules) {
            module.activate(false);
        }
        if (this.active) {
            this.active = false;
            this.markDirtyClient();
        }
    }

    public void setPowerInput(int powered) {
        if (this.powerLevel != powered) {
            this.powerTimeout = 0;
        }
        super.setPowerInput(powered);
    }

    public List<EnvironmentModule> getEnvironmentModules() {
        if (this.environmentModules == null) {
            int volume = this.getVolume();
            this.totalRfPerTick = 0;
            this.environmentModules = new ArrayList<EnvironmentModule>();
            for (int i = 0; i < this.items.getSlots(); ++i) {
                Item item;
                ItemStack itemStack = this.items.getStackInSlot(i);
                if (itemStack.isEmpty() || !((item = itemStack.getItem()) instanceof EnvModuleProvider)) continue;
                EnvModuleProvider moduleProvider = (EnvModuleProvider)item;
                Supplier<? extends EnvironmentModule> supplier = moduleProvider.getServerEnvironmentModule();
                EnvironmentModule environmentModule = supplier.get();
                this.environmentModules.add(environmentModule);
                this.totalRfPerTick += (int)(environmentModule.getRfPerTick() * (float)volume);
            }
        }
        return this.environmentModules;
    }

    public void loadClientDataFromNBT(CompoundTag tag, HolderLookup.Provider provider) {
        this.active = tag.getBoolean("active");
    }

    public void saveClientDataToNBT(CompoundTag tag, HolderLookup.Provider provider) {
        tag.putBoolean("active", this.active);
    }

    public void saveAdditional(@Nonnull CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("rfPerTick", this.totalRfPerTick);
        tag.putBoolean("active", this.active);
        this.energyStorage.save(tag, "energy", provider);
        this.items.save(tag, "items", provider);
        this.infusable.save(tag, "infusable");
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.totalRfPerTick = tag.getInt("rfPerTick");
        this.active = tag.getBoolean("active");
        this.energyStorage.load(tag, "energy", provider);
        this.items.load(tag, "items", provider);
        this.infusable.load(tag, "infusable");
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        EnvironmentalData data = (EnvironmentalData)input.get(EnvironmentalModule.ITEM_ENVIRONMENTAL_DATA);
        if (data != null) {
            this.setData(EnvironmentalModule.ENVIRONMENTAL_DATA, data);
        }
        this.energyStorage.applyImplicitComponents((ItemEnergy)input.get((Supplier)Registration.ITEM_ENERGY));
        this.items.applyImplicitComponents((ItemInventory)input.get((Supplier)Registration.ITEM_INVENTORY));
        this.infusable.applyImplicitComponents((ItemInfusable)input.get((Supplier)Registration.ITEM_INFUSABLE));
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(EnvironmentalModule.ITEM_ENVIRONMENTAL_DATA, (Object)((EnvironmentalData)this.getData(EnvironmentalModule.ENVIRONMENTAL_DATA)));
        this.energyStorage.collectImplicitComponents(builder);
        this.items.collectImplicitComponents(builder);
        this.infusable.collectImplicitComponents(builder);
    }

    public void onReplaced(Level world, BlockPos pos, BlockState state, BlockState newstate) {
        this.deactivate();
    }

    @Nonnull
    private IPowerInformation createPowerInfo() {
        return new IPowerInformation(){

            public long getEnergyDiffPerTick() {
                return EnvironmentalControllerTileEntity.this.isActive() ? (long)(-EnvironmentalControllerTileEntity.this.getTotalRfPerTick()) : 0L;
            }

            public String getEnergyUnitName() {
                return "RF";
            }

            public boolean isMachineActive() {
                return EnvironmentalControllerTileEntity.this.isActive();
            }

            public boolean isMachineRunning() {
                return EnvironmentalControllerTileEntity.this.isActive();
            }

            public String getMachineStatus() {
                return EnvironmentalControllerTileEntity.this.isActive() ? "active" : "idle";
            }
        };
    }
}

