/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import mcjty.lib.McJtyLib;
import mcjty.lib.gui.BuffStyle;
import mcjty.lib.preferences.PreferencesProperties;
import mcjty.lib.varia.ComponentFactory;
import net.minecraft.SharedConstants;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class CommandSetBuffs
implements Command<CommandSourceStack> {
    private static final CommandSetBuffs CMD = new CommandSetBuffs();

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.literal((String)"setbuffs").requires(cs -> cs.hasPermission(1))).then(Commands.argument((String)"style", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"x", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"y", (ArgumentType)IntegerArgumentType.integer()).executes((Command)CMD))));
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        SharedConstants.IS_RUNNING_IN_IDE = true;
        String styleS = (String)context.getArgument("style", String.class);
        BuffStyle buffStyle = BuffStyle.getStyle((String)styleS);
        if (buffStyle == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)ComponentFactory.literal((String)("Unknown style '" + styleS + "'! Use one of 'off', 'topleft', 'topright', 'botleft', 'botright'")));
            return 0;
        }
        int x = (Integer)context.getArgument("x", Integer.class);
        int y = (Integer)context.getArgument("y", Integer.class);
        ServerPlayer playerEntity = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        PreferencesProperties preferences = McJtyLib.getPreferencesProperties((Player)playerEntity);
        if (preferences != null) {
            preferences.setBuffXY(buffStyle, x, y);
            McJtyLib.setPreferencesProperties((Player)playerEntity, (PreferencesProperties)preferences);
        }
        return 0;
    }
}

