/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.endergenic.data;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import mcjty.lib.varia.NamedEnum;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public enum EnderMonitorMode implements NamedEnum<EnderMonitorMode>,
StringRepresentable
{
    MODE_LOSTPEARL("Lost Pearl"),
    MODE_PEARLFIRED("Pearl Fired"),
    MODE_PEARLARRIVED("Pearl Arrived");

    public static final Codec<EnderMonitorMode> CODEC;
    public static final StreamCodec<FriendlyByteBuf, EnderMonitorMode> STREAM_CODEC;
    private static final Map<String, EnderMonitorMode> modeToMode;
    private final String description;

    private EnderMonitorMode(String description) {
        this.description = description;
    }

    public String getName() {
        return this.description;
    }

    public String[] getDescription() {
        return new String[]{this.description};
    }

    public static EnderMonitorMode getMode(String mode) {
        return modeToMode.get(mode);
    }

    public String getSerializedName() {
        return this.name();
    }

    static {
        CODEC = StringRepresentable.fromEnum(EnderMonitorMode::values);
        STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(EnderMonitorMode.class);
        modeToMode = new HashMap<String, EnderMonitorMode>();
        for (EnderMonitorMode mode : EnderMonitorMode.values()) {
            modeToMode.put(mode.description, mode);
        }
    }
}

