/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.dimensionalcell.blocks;

import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.container.ItemInventory;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.api.infusable.ItemInfusable;
import mcjty.lib.api.module.DefaultModuleSupport;
import mcjty.lib.api.module.IModuleSupport;
import mcjty.lib.api.smartwrench.ISmartWrenchSelector;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ResultCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.setup.Registration;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.api.infoscreen.IInformationScreenInfo;
import mcjty.rftoolsbase.api.machineinfo.IMachineInformation;
import mcjty.rftoolspower.modules.dimensionalcell.DimensionalCellConfiguration;
import mcjty.rftoolspower.modules.dimensionalcell.DimensionalCellModule;
import mcjty.rftoolspower.modules.dimensionalcell.DimensionalCellNetwork;
import mcjty.rftoolspower.modules.dimensionalcell.blocks.DimensionalCellBlock;
import mcjty.rftoolspower.modules.dimensionalcell.blocks.DimensionalCellInformationScreenInfo;
import mcjty.rftoolspower.modules.dimensionalcell.blocks.DimensionalCellType;
import mcjty.rftoolspower.modules.dimensionalcell.data.DimensionalCellData;
import mcjty.rftoolspower.modules.dimensionalcell.items.PowerCellCardItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class DimensionalCellTileEntity
extends TickingTileEntity
implements ISmartWrenchSelector {
    public static final int SLOT_CARD = 0;
    public static final int SLOT_CARDCOPY = 1;
    public static final int SLOT_CHARGEITEM = 2;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(3).slot(SlotDefinition.specific((Item[])new Item[]{(Item)DimensionalCellModule.POWERCELL_CARD.get()}).in().out(), 0, 28, 8).slot(SlotDefinition.specific((Item[])new Item[]{(Item)DimensionalCellModule.POWERCELL_CARD.get()}), 1, 64, 30).slot(SlotDefinition.generic(), 2, 64, 8).playerSlots(10, 70));
    public int tooltipEnergy = 0;
    public int tooltipBlocks = 0;
    public int tooltipSimpleBlocks = 0;
    public int tooltipAdvancedBlocks = 0;
    public long tooltipInserted = 0L;
    public long tooltipExtracted = 0L;
    public int tooltipRfPerTick = 0;
    public float tooltipCostFactor = 0.0f;
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).itemValid((slot, stack) -> {
        if (slot == 0 && stack.getItem() != DimensionalCellModule.POWERCELL_CARD.get()) {
            return false;
        }
        return slot != 1 || stack.getItem() == DimensionalCellModule.POWERCELL_CARD.get();
    }).onUpdate(this::onUpdateSlot).build();
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private static final Function<DimensionalCellTileEntity, GenericItemHandler> ITEM_CAP = tile -> tile.items;
    private final Lazy<IInformationScreenInfo> infoScreenInfo = Lazy.of(this::createScreenInfo);
    private final DefaultInfusable infusableHandler = new DefaultInfusable((BlockEntity)this);
    @Cap(type=CapType.INFUSABLE)
    private static final Function<DimensionalCellTileEntity, IInfusable> INFUSABLE_CAP = tile -> tile.infusableHandler;
    private final Lazy<NullHandler> nullStorage = Lazy.of(() -> new NullHandler());
    private final Lazy<IMachineInformation> infoHandler = Lazy.of(this::createMachineInfo);
    private final Lazy<SidedHandler>[] sidedStorages = new Lazy[]{Lazy.of(() -> new SidedHandler(Direction.DOWN)), Lazy.of(() -> new SidedHandler(Direction.UP)), Lazy.of(() -> new SidedHandler(Direction.NORTH)), Lazy.of(() -> new SidedHandler(Direction.SOUTH)), Lazy.of(() -> new SidedHandler(Direction.WEST)), Lazy.of(() -> new SidedHandler(Direction.EAST))};
    @Cap(type=CapType.CONTAINER)
    private static final Function<DimensionalCellTileEntity, MenuProvider> SCREEN_CAP = be -> new DefaultContainerProvider("Dimensional Cell").containerSupplier(DefaultContainerProvider.container(DimensionalCellModule.CONTAINER_DIMENSIONAL_CELL, CONTAINER_FACTORY, (GenericTileEntity)be)).itemHandler(() -> be.items).setupSync((GenericTileEntity)be);
    @Cap(type=CapType.MODULE)
    private static final Function<DimensionalCellTileEntity, IModuleSupport> MODULE_CAP = be -> new DefaultModuleSupport(0){

        public boolean isModule(ItemStack itemStack) {
            return itemStack.getItem() instanceof PowerCellCardItem;
        }
    };
    private long totalExtracted = 0L;
    private long totalInserted = 0L;
    private int lastRfPerTickIn = 0;
    private int lastRfPerTickOut = 0;
    private int powerIn = 0;
    private int powerOut = 0;
    private long lastTime = 0L;
    private static final EnumProperty<Mode>[] MODES = new EnumProperty[]{DimensionalCellBlock.DOWN, DimensionalCellBlock.UP, DimensionalCellBlock.NORTH, DimensionalCellBlock.SOUTH, DimensionalCellBlock.WEST, DimensionalCellBlock.EAST};
    @ServerCommand
    public static final Command<?> ACTION_CLEARSTATS = Command.create((String)"clearStats", (te, player, params) -> {
        te.totalExtracted = 0L;
        te.totalInserted = 0L;
        te.setChanged();
    });
    @ServerCommand
    public static final Command<?> ACTION_SETOUTPUT = Command.create((String)"setOutput", (te, player, params) -> te.setAllOutput());
    @ServerCommand
    public static final Command<?> ACTION_SETINPUT = Command.create((String)"setInput", (te, player, params) -> te.setAllInput());
    @ServerCommand
    public static final Command<?> ACTION_SETNONE = Command.create((String)"setNone", (te, player, params) -> te.setAllNone());
    public static final Key<Integer> PARAM_ENERGY = new Key("energy", Type.INTEGER);
    public static final Key<Integer> PARAM_BLOCKS = new Key("block", Type.INTEGER);
    public static final Key<Integer> PARAM_SIMPLEBLOCKS = new Key("simpleblocks", Type.INTEGER);
    public static final Key<Integer> PARAM_ADVANCEDBLOCKS = new Key("advancedblocks", Type.INTEGER);
    public static final Key<Long> PARAM_TOTAL_INSERTED = new Key("totalinserted", Type.LONG);
    public static final Key<Long> PARAM_TOTAL_EXTRACTED = new Key("totalextracted", Type.LONG);
    public static final Key<Integer> PARAM_RFPERTICK = new Key("rfpertick", Type.INTEGER);
    public static final Key<Double> PARAM_COSTFACTOR = new Key("costfactor", Type.DOUBLE);
    @ServerCommand
    public static final ResultCommand<?> CMD_GET_INFO = ResultCommand.create((String)"getInfo", (te, player, params) -> te.getInfo(), (te, player, params) -> {
        te.tooltipEnergy = (Integer)params.get(PARAM_ENERGY);
        te.tooltipBlocks = (Integer)params.get(PARAM_BLOCKS);
        te.tooltipSimpleBlocks = (Integer)params.get(PARAM_SIMPLEBLOCKS);
        te.tooltipAdvancedBlocks = (Integer)params.get(PARAM_ADVANCEDBLOCKS);
        te.tooltipInserted = (Long)params.get(PARAM_TOTAL_INSERTED);
        te.tooltipExtracted = (Long)params.get(PARAM_TOTAL_EXTRACTED);
        te.tooltipRfPerTick = (Integer)params.get(PARAM_RFPERTICK);
        te.tooltipCostFactor = ((Double)params.get(PARAM_COSTFACTOR)).floatValue();
    });

    public DimensionalCellTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    private void onUpdateSlot(Integer slot, ItemStack stack) {
        if (slot == 0) {
            ItemStack s = this.items.getStackInSlot(0);
            if (s.isEmpty()) {
                this.handleCardRemoval();
            } else {
                this.handleCardInsertion();
            }
        } else if (slot == 1 && !stack.isEmpty()) {
            int id = this.getNetworkId();
            PowerCellCardItem.setId(stack, id);
        }
    }

    public int getLastRfPerTickIn() {
        return this.lastRfPerTickIn;
    }

    public int getLastRfPerTickOut() {
        return this.lastRfPerTickOut;
    }

    public int getNetworkId() {
        return ((DimensionalCellData)this.getData(DimensionalCellModule.DIMENSIONAL_CELL_DATA)).networkId();
    }

    public void setNetworkId(int networkId) {
        DimensionalCellData data = (DimensionalCellData)this.getData(DimensionalCellModule.DIMENSIONAL_CELL_DATA);
        data = data.withNetworkId(networkId);
        this.setData(DimensionalCellModule.DIMENSIONAL_CELL_DATA, data);
    }

    @Nullable
    public DimensionalCellNetwork.Network getNetwork() {
        if (this.level.isClientSide) {
            return null;
        }
        int networkId = this.getNetworkId();
        if (networkId == -1) {
            return null;
        }
        DimensionalCellNetwork generatorNetwork = DimensionalCellNetwork.get(this.level);
        return generatorNetwork.getOrCreateNetwork(networkId);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        DimensionalCellData data = (DimensionalCellData)input.get(DimensionalCellModule.ITEM_DIMENSIONAL_CELL_DATA);
        if (data != null) {
            this.setData(DimensionalCellModule.DIMENSIONAL_CELL_DATA, data);
        }
        this.items.applyImplicitComponents((ItemInventory)input.get((Supplier)Registration.ITEM_INVENTORY));
        this.infusableHandler.applyImplicitComponents((ItemInfusable)input.get((Supplier)Registration.ITEM_INFUSABLE));
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(DimensionalCellModule.ITEM_DIMENSIONAL_CELL_DATA, (Object)((DimensionalCellData)this.getData(DimensionalCellModule.DIMENSIONAL_CELL_DATA)));
        this.items.collectImplicitComponents(builder);
        this.infusableHandler.collectImplicitComponents(builder);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        this.items.save(tag, "items", provider);
        this.infusableHandler.save(tag, "infusable");
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.items.load(tag, "items", provider);
        this.infusableHandler.load(tag, "infusable");
    }

    public Mode getMode(Direction side) {
        return (Mode)((Object)this.getBlockState().getValue(MODES[side.ordinal()]));
    }

    public void toggleMode(Direction side) {
        Mode mode = this.getMode(side);
        switch (mode.ordinal()) {
            case 0: {
                this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue(MODES[side.ordinal()], (Comparable)((Object)Mode.MODE_INPUT)), 3);
                break;
            }
            case 1: {
                this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue(MODES[side.ordinal()], (Comparable)((Object)Mode.MODE_OUTPUT)), 3);
                break;
            }
            case 2: {
                this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue(MODES[side.ordinal()], (Comparable)((Object)Mode.MODE_NONE)), 3);
            }
        }
    }

    protected void tickServer() {
        int energyStored;
        long time = this.level.getGameTime();
        if (this.lastTime == 0L) {
            this.lastTime = time;
        } else if (time > this.lastTime + 40L) {
            this.lastRfPerTickIn = (int)((long)this.powerIn / (time - this.lastTime));
            this.lastRfPerTickOut = (int)((long)this.powerOut / (time - this.lastTime));
            this.lastTime = time;
            this.powerIn = 0;
            this.powerOut = 0;
        }
        if (this.getDimensionalCellType().isCreative()) {
            int gain = 1000000;
            int networkId = this.getNetworkId();
            if (networkId == -1) {
                this.receiveEnergyLocal(gain, false);
            } else {
                this.receiveEnergyMulti(gain, false);
            }
        }
        if ((energyStored = this.getEnergyStored()) <= 0) {
            return;
        }
        this.handleChargingItem();
        this.sendOutEnergy();
    }

    private void handleChargingItem() {
        ItemStack stack = this.items.getStackInSlot(2);
        if (stack.isEmpty()) {
            return;
        }
        int rfToGive = Math.min((Integer)DimensionalCellConfiguration.CHARGEITEMPERTICK.get(), this.getEnergyStored());
        int received = (int)EnergyTools.receiveEnergy((ItemStack)stack, (long)rfToGive);
        if (received == 0) {
            return;
        }
        this.extractEnergyInternal(received, false, (Integer)DimensionalCellConfiguration.CHARGEITEMPERTICK.get());
    }

    private void sendOutEnergy() {
        int energyStored = this.getEnergyStored();
        for (Direction face : OrientationTools.DIRECTION_VALUES) {
            int rfToGive;
            int received;
            Direction opposite;
            BlockPos pos;
            BlockEntity te;
            if (this.getMode(face) != Mode.MODE_OUTPUT || !EnergyTools.isEnergyTE((BlockEntity)(te = this.level.getBlockEntity(pos = this.getBlockPos().relative(face))), (Direction)(opposite = face.getOpposite())) || te instanceof DimensionalCellTileEntity && this.getNetworkId() != -1 && ((DimensionalCellTileEntity)te).getNetworkId() == this.getNetworkId()) continue;
            float factor = this.getCostFactor();
            int rfPerTick = this.getRfPerTickPerSide();
            if ((energyStored -= this.extractEnergyInternal(received = (int)EnergyTools.receiveEnergy((BlockEntity)te, (Direction)opposite, (long)(rfToGive = Math.min(rfPerTick, (int)((float)energyStored / factor)))), false, Integer.MAX_VALUE)) <= 0) break;
        }
    }

    public float getCostFactor() {
        float factor;
        float infusedFactor = this.getInfusedFactor().floatValue();
        if (this.getNetworkId() == -1) {
            factor = 1.0f;
        } else {
            factor = this.getNetwork().calculateCostFactor(this.level, this.getGlobalPos());
            factor = (factor - 1.0f) * (1.0f - infusedFactor / 2.0f) + 1.0f;
        }
        return factor;
    }

    private Float getInfusedFactor() {
        return Float.valueOf(this.infusableHandler.getInfusedFactor());
    }

    public int getRfPerTickPerSide() {
        return (int)((double)((Integer)DimensionalCellConfiguration.rfPerTick.get() * this.getPowerFactor() / (Integer)DimensionalCellConfiguration.simpleFactor.get()) * ((double)this.getInfusedFactor().floatValue() * 0.5 + 1.0));
    }

    private void handleCardRemoval() {
        DimensionalCellNetwork.Network network;
        if (!this.level.isClientSide && (network = this.getNetwork()) != null) {
            int energy = network.extractEnergySingleBlock(this.getDimensionalCellType());
            this.setEnergy(energy);
            network.remove(this.level, this.getGlobalPos(), this.getDimensionalCellType());
            DimensionalCellNetwork.get(this.level).save();
        }
        this.setNetworkId(-1);
        this.setChanged();
    }

    private void handleCardInsertion() {
        ItemStack stack = this.items.getStackInSlot(0);
        int id = PowerCellCardItem.getId(stack);
        if (!this.level.isClientSide) {
            DimensionalCellNetwork channels = DimensionalCellNetwork.get(this.level);
            if (id == -1) {
                id = channels.newChannel();
                PowerCellCardItem.setId(stack, id);
            }
            this.setNetworkId(id);
            DimensionalCellNetwork.Network network = this.getNetwork();
            network.add(this.level, this.getGlobalPos(), this.getDimensionalCellType());
            network.receiveEnergy(this.getEnergy());
            channels.save();
        } else {
            this.setNetworkId(id);
        }
        this.setChanged();
    }

    private DimensionalCellType getDimensionalCellType() {
        return DimensionalCellBlock.getType(this.level.getBlockState(this.worldPosition).getBlock());
    }

    private int getPowerFactor() {
        if (this.getDimensionalCellType().isSimple()) {
            return 1;
        }
        return this.getDimensionalCellType().isAdvanced() ? (Integer)DimensionalCellConfiguration.advancedFactor.get() * (Integer)DimensionalCellConfiguration.simpleFactor.get() : (Integer)DimensionalCellConfiguration.simpleFactor.get();
    }

    private void setEnergy(int energy) {
        DimensionalCellData data = ((DimensionalCellData)this.getData(DimensionalCellModule.DIMENSIONAL_CELL_DATA)).withEnergy(energy);
        this.setData(DimensionalCellModule.DIMENSIONAL_CELL_DATA, data);
    }

    public int getEnergy() {
        return ((DimensionalCellData)this.getData(DimensionalCellModule.DIMENSIONAL_CELL_DATA)).energy();
    }

    public GlobalPos getGlobalPos() {
        return GlobalPos.of((ResourceKey)this.level.dimension(), (BlockPos)this.getBlockPos());
    }

    public long getTotalExtracted() {
        return this.totalExtracted;
    }

    public long getTotalInserted() {
        return this.totalInserted;
    }

    public void resetTotalExtracted() {
        this.totalExtracted = 0L;
    }

    public void resetTotalInserted() {
        this.totalInserted = 0L;
    }

    public int receiveEnergyFacing(Direction from, int maxReceive, boolean simulate) {
        if (this.getMode(from) != Mode.MODE_INPUT) {
            return 0;
        }
        maxReceive = Math.min(maxReceive, this.getRfPerTickPerSide());
        int networkId = this.getNetworkId();
        int received = networkId == -1 ? this.receiveEnergyLocal(maxReceive, simulate) : this.receiveEnergyMulti(maxReceive, simulate);
        if (!simulate) {
            this.totalInserted += (long)received;
            this.powerIn += received;
            this.setChanged();
        }
        return received;
    }

    private int receiveEnergyMulti(int maxReceive, boolean simulate) {
        if (this.level.isClientSide) {
            return 0;
        }
        DimensionalCellNetwork.Network network = this.getNetwork();
        int totEnergy = network.calculateMaximumEnergy();
        int maxInsert = Math.min(totEnergy - network.getEnergy(), maxReceive);
        if (maxInsert > 0 && !simulate) {
            maxInsert = network.receiveEnergy(maxInsert);
            DimensionalCellNetwork.get(this.level).save();
        }
        return this.getDimensionalCellType().isCreative() ? maxReceive : maxInsert;
    }

    private int receiveEnergyLocal(int maxReceive, boolean simulate) {
        int energy;
        long capacityL = (long)((Integer)DimensionalCellConfiguration.rfPerNormalCell.get()).intValue() * (long)this.getPowerFactor() / (long)((Integer)DimensionalCellConfiguration.simpleFactor.get()).intValue();
        int capacity = capacityL > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)capacityL;
        int maxInsert = Math.min(capacity - (energy = this.getEnergy()), maxReceive);
        if (maxInsert > 0 && !simulate) {
            this.setEnergy(energy += maxInsert);
        }
        return this.getDimensionalCellType().isCreative() ? maxReceive : maxInsert;
    }

    private int extractEnergyInternal(int maxExtract, boolean simulate, int maximum) {
        int networkId = this.getNetworkId();
        int extracted = networkId == -1 ? this.extractEnergyLocal(maxExtract, simulate, maximum) : this.extractEnergyMulti(maxExtract, simulate, maximum);
        if (!simulate) {
            this.totalExtracted += (long)extracted;
            this.powerOut += extracted;
            this.setChanged();
        }
        return extracted;
    }

    private int extractEnergyMulti(int maxExtract, boolean simulate, int maximum) {
        if (this.level.isClientSide) {
            return 0;
        }
        DimensionalCellNetwork.Network network = this.getNetwork();
        if (maxExtract > maximum) {
            maxExtract = maximum;
        }
        if (!simulate) {
            maxExtract = network.extractEnergy(maxExtract);
            DimensionalCellNetwork.get(this.level).save();
        }
        return maxExtract;
    }

    private int extractEnergyLocal(int maxExtract, boolean simulate, int maximum) {
        int energy = this.getEnergy();
        if (maxExtract > energy) {
            maxExtract = energy;
        }
        if (maxExtract > maximum) {
            maxExtract = maximum;
        }
        if (!simulate) {
            this.setEnergy(energy -= maxExtract);
        }
        return maxExtract;
    }

    public int getEnergyStored() {
        if (this.level.isClientSide) {
            return 0;
        }
        int networkId = this.getNetworkId();
        if (networkId == -1) {
            return this.getEnergy();
        }
        DimensionalCellNetwork.Network network = this.getNetwork();
        return network.getEnergy();
    }

    public int getMaxEnergyStored() {
        if (this.level.isClientSide) {
            return 0;
        }
        int networkId = this.getNetworkId();
        if (networkId == -1) {
            return (Integer)DimensionalCellConfiguration.rfPerNormalCell.get() * this.getPowerFactor() / (Integer)DimensionalCellConfiguration.simpleFactor.get();
        }
        DimensionalCellNetwork.Network network = this.getNetwork();
        return network.calculateMaximumEnergy();
    }

    public void setAllOutput() {
        this.level.setBlock(this.worldPosition, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getBlockState().setValue(DimensionalCellBlock.DOWN, (Comparable)((Object)Mode.MODE_OUTPUT))).setValue(DimensionalCellBlock.UP, (Comparable)((Object)Mode.MODE_OUTPUT))).setValue(DimensionalCellBlock.NORTH, (Comparable)((Object)Mode.MODE_OUTPUT))).setValue(DimensionalCellBlock.SOUTH, (Comparable)((Object)Mode.MODE_OUTPUT))).setValue(DimensionalCellBlock.WEST, (Comparable)((Object)Mode.MODE_OUTPUT))).setValue(DimensionalCellBlock.EAST, (Comparable)((Object)Mode.MODE_OUTPUT)), 3);
    }

    private void setAllInput() {
        this.level.setBlock(this.worldPosition, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getBlockState().setValue(DimensionalCellBlock.DOWN, (Comparable)((Object)Mode.MODE_INPUT))).setValue(DimensionalCellBlock.UP, (Comparable)((Object)Mode.MODE_INPUT))).setValue(DimensionalCellBlock.NORTH, (Comparable)((Object)Mode.MODE_INPUT))).setValue(DimensionalCellBlock.SOUTH, (Comparable)((Object)Mode.MODE_INPUT))).setValue(DimensionalCellBlock.WEST, (Comparable)((Object)Mode.MODE_INPUT))).setValue(DimensionalCellBlock.EAST, (Comparable)((Object)Mode.MODE_INPUT)), 3);
    }

    private void setAllNone() {
        this.level.setBlock(this.worldPosition, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getBlockState().setValue(DimensionalCellBlock.DOWN, (Comparable)((Object)Mode.MODE_NONE))).setValue(DimensionalCellBlock.UP, (Comparable)((Object)Mode.MODE_NONE))).setValue(DimensionalCellBlock.NORTH, (Comparable)((Object)Mode.MODE_NONE))).setValue(DimensionalCellBlock.SOUTH, (Comparable)((Object)Mode.MODE_NONE))).setValue(DimensionalCellBlock.WEST, (Comparable)((Object)Mode.MODE_NONE))).setValue(DimensionalCellBlock.EAST, (Comparable)((Object)Mode.MODE_NONE)), 3);
    }

    public void selectBlock(Player player, BlockPos pos) {
        DimensionalCellTileEntity.dumpNetwork(player, this);
    }

    public static void dumpNetwork(Player player, DimensionalCellTileEntity dimensionalCellTileEntity) {
        DimensionalCellNetwork.Network network = dimensionalCellTileEntity.getNetwork();
        Set<GlobalPos> blocks = network.getBlocks();
        blocks.forEach(b -> {
            Object msg;
            ServerLevel w = LevelTools.getLevel((ResourceKey)b.dimension());
            if (w == null) {
                msg = "dimension missing!";
            } else {
                Block block = w.getBlockState(b.pos()).getBlock();
                msg = block == DimensionalCellModule.DIMENSIONAL_CELL.block().get() ? "normal" : (block == DimensionalCellModule.DIMENSIONAL_CELL_ADVANCED.block().get() ? "advanced" : (block == DimensionalCellModule.DIMENSIONAL_CELL_CREATIVE.block().get() ? "creative" : "not a powercell!"));
                BlockEntity te = w.getBlockEntity(b.pos());
                if (te instanceof DimensionalCellTileEntity) {
                    DimensionalCellTileEntity power = (DimensionalCellTileEntity)te;
                    msg = (String)msg + " (+:" + power.getTotalInserted() + ", -:" + power.getTotalExtracted() + ")";
                }
            }
            Logging.message((Player)player, (String)("Block: " + BlockPosTools.toString((BlockPos)b.pos()) + " (" + b.dimension().location().getPath() + "): " + (String)msg));
        });
    }

    private TypedMap getInfo() {
        if (this.getNetworkId() == -1) {
            return TypedMap.builder().put(PARAM_ENERGY, (Object)this.getEnergy()).put(PARAM_BLOCKS, (Object)1).put(PARAM_SIMPLEBLOCKS, (Object)(this.getDimensionalCellType().isSimple() ? 1 : 0)).put(PARAM_ADVANCEDBLOCKS, (Object)(this.getDimensionalCellType().isAdvanced() ? 1 : 0)).put(PARAM_TOTAL_INSERTED, (Object)this.getTotalInserted()).put(PARAM_TOTAL_EXTRACTED, (Object)this.getTotalExtracted()).put(PARAM_RFPERTICK, (Object)this.getRfPerTickPerSide()).put(PARAM_COSTFACTOR, (Object)1.0).build();
        }
        DimensionalCellNetwork.Network network = this.getNetwork();
        return TypedMap.builder().put(PARAM_ENERGY, (Object)network.getEnergy()).put(PARAM_BLOCKS, (Object)network.getBlockCount()).put(PARAM_SIMPLEBLOCKS, (Object)network.getSimpleBlockCount()).put(PARAM_ADVANCEDBLOCKS, (Object)network.getAdvancedBlockCount()).put(PARAM_TOTAL_INSERTED, (Object)this.getTotalInserted()).put(PARAM_TOTAL_EXTRACTED, (Object)this.getTotalExtracted()).put(PARAM_RFPERTICK, (Object)this.getRfPerTickPerSide()).put(PARAM_COSTFACTOR, (Object)this.getCostFactor()).build();
    }

    public IMachineInformation getInfoHandler() {
        return (IMachineInformation)this.infoHandler.get();
    }

    public IInformationScreenInfo getInfoScreenInfo() {
        return (IInformationScreenInfo)this.infoScreenInfo.get();
    }

    public IEnergyStorage getEnergyStorage(Direction facing) {
        if (facing == null) {
            return (IEnergyStorage)this.nullStorage.get();
        }
        return (IEnergyStorage)this.sidedStorages[facing.ordinal()].get();
    }

    @Nonnull
    private IInformationScreenInfo createScreenInfo() {
        return new DimensionalCellInformationScreenInfo(this);
    }

    @Nonnull
    private IMachineInformation createMachineInfo() {
        return new IMachineInformation(){
            private final String[] TAGS = new String[]{"rfpertick_out", "rfpertick_in", "rftotal_in", "rftotal_out"};
            private final String[] TAG_DESCRIPTIONS = new String[]{"The current RF/t output given by this block (last 2 seconds)", "The current RF/t input received by this block (last 2 seconds)", "The total RF/t output given by this block", "The current RF/t input received by this block"};

            public int getTagCount() {
                return this.TAGS.length;
            }

            public String getTagName(int index) {
                return this.TAGS[index];
            }

            public String getTagDescription(int index) {
                return this.TAG_DESCRIPTIONS[index];
            }

            public String getData(int index, long millis) {
                return switch (index) {
                    case 0 -> DimensionalCellTileEntity.this.lastRfPerTickOut + "RF/t";
                    case 1 -> DimensionalCellTileEntity.this.lastRfPerTickIn + "RF/t";
                    case 2 -> DimensionalCellTileEntity.this.totalExtracted + "RF";
                    case 3 -> DimensionalCellTileEntity.this.totalInserted + "RF";
                    default -> null;
                };
            }
        };
    }

    public static enum Mode implements StringRepresentable
    {
        MODE_NONE("none", "overlay_none"),
        MODE_INPUT("input", "overlay_in"),
        MODE_OUTPUT("output", "overlay_out");

        private final String name;
        private final String overlayName;

        private Mode(String name, String overlayName) {
            this.name = name;
            this.overlayName = overlayName;
        }

        public String getOverlayName() {
            return this.overlayName;
        }

        @Nonnull
        public String getSerializedName() {
            return this.name;
        }

        public String toString() {
            return this.getSerializedName();
        }
    }

    private class SidedHandler
    implements IEnergyStorage {
        private final Direction facing;

        private SidedHandler(Direction facing) {
            this.facing = facing;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return DimensionalCellTileEntity.this.receiveEnergyFacing(this.facing, maxReceive, simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return DimensionalCellTileEntity.this.getEnergyStored();
        }

        public int getMaxEnergyStored() {
            return DimensionalCellTileEntity.this.getMaxEnergyStored();
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }
    }

    private class NullHandler
    implements IEnergyStorage {
        private NullHandler() {
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return DimensionalCellTileEntity.this.getEnergyStored();
        }

        public int getMaxEnergyStored() {
            return DimensionalCellTileEntity.this.getMaxEnergyStored();
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return false;
        }
    }
}

