/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.blazing.items;

import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.varia.Tools;
import mcjty.rftoolspower.modules.blazing.BlazingModule;
import mcjty.rftoolspower.modules.blazing.data.BlazingRodData;
import mcjty.rftoolspower.setup.Registration;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.common.util.Lazy;

public class BlazingRod
extends Item {
    public static final float MAXTIME = 600.0f;
    public static final float START_QUALITY = 60000.0f;
    public static final float START_DURATION = 20.0f;
    public static final int MAX_INFUSION_STEPS = 64;
    private final Lazy<TooltipBuilder> tooltipBuilder = Lazy.of(() -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsbase.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.parameter((String)"time", BlazingRod::isCharging, stack -> BlazingRod.getAgitationTimePercentage(stack) + "%"), TooltipBuilder.parameter((String)"infused", BlazingRod::isInfused, stack -> BlazingRod.getInfusionPercentage(stack) + "%"), TooltipBuilder.parameter((String)"power", stack -> BlazingRod.getRfPerTick(stack) + " RF/t"), TooltipBuilder.parameter((String)"duration", stack -> BlazingRod.getTotalTicks(stack) + " ticks")}));

    public BlazingRod() {
        super(Registration.createStandardProperties());
    }

    public void appendHoverText(@Nonnull ItemStack itemStack, Item.TooltipContext context, @Nonnull List<Component> list, @Nonnull TooltipFlag flags) {
        super.appendHoverText(itemStack, context, list, flags);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(Tools.getId((Item)this), itemStack, list, flags);
    }

    public static boolean isCharging(ItemStack stack) {
        float left = BlazingRod.getAgitationTimeLeft(stack);
        return left > 0.0f;
    }

    public static boolean isInfused(ItemStack stack) {
        int left = BlazingRod.getInfusionStepsLeft(stack);
        return left < 64;
    }

    public static int getInfusionPercentage(ItemStack stack) {
        int left = BlazingRod.getInfusionStepsLeft(stack);
        return (64 - left) * 100 / 64;
    }

    public static int getInfusionStepsLeft(ItemStack stack) {
        BlazingRodData data = (BlazingRodData)stack.getOrDefault(BlazingModule.ITEM_BLAZING_ROD_DATA, (Object)BlazingRodData.DEFAULT);
        return data.steps();
    }

    public static void setInfusionStepsLeft(ItemStack stack, int steps) {
        BlazingRodData data = (BlazingRodData)stack.getOrDefault(BlazingModule.ITEM_BLAZING_ROD_DATA, (Object)BlazingRodData.DEFAULT);
        data = data.withSteps(steps);
        stack.set(BlazingModule.ITEM_BLAZING_ROD_DATA, (Object)data);
    }

    public static float getAgitationTimeLeft(ItemStack stack) {
        BlazingRodData data = (BlazingRodData)stack.getOrDefault(BlazingModule.ITEM_BLAZING_ROD_DATA, (Object)BlazingRodData.DEFAULT);
        return data.time();
    }

    public static void setAgitationTimeLeft(ItemStack stack, float time) {
        BlazingRodData data = (BlazingRodData)stack.getOrDefault(BlazingModule.ITEM_BLAZING_ROD_DATA, (Object)BlazingRodData.DEFAULT);
        data = data.withTime(time);
        stack.set(BlazingModule.ITEM_BLAZING_ROD_DATA, (Object)data);
    }

    public static int getAgitationTimePercentage(ItemStack stack) {
        float left = BlazingRod.getAgitationTimeLeft(stack);
        return (int)((600.0f - left) * 100.0f / 600.0f);
    }

    public static float getPowerQuality(ItemStack stack) {
        BlazingRodData data = (BlazingRodData)stack.getOrDefault(BlazingModule.ITEM_BLAZING_ROD_DATA, (Object)BlazingRodData.DEFAULT);
        return data.quality();
    }

    public static void setPowerQuality(ItemStack stack, float quality) {
        BlazingRodData data = (BlazingRodData)stack.getOrDefault(BlazingModule.ITEM_BLAZING_ROD_DATA, (Object)BlazingRodData.DEFAULT);
        data = data.withQuality(quality);
        stack.set(BlazingModule.ITEM_BLAZING_ROD_DATA, (Object)data);
    }

    public static int getRfPerTick(ItemStack stack) {
        return (int)(BlazingRod.getPowerQuality(stack) / 1000.0f);
    }

    public static float getPowerDuration(ItemStack stack) {
        BlazingRodData data = (BlazingRodData)stack.getOrDefault(BlazingModule.ITEM_BLAZING_ROD_DATA, (Object)BlazingRodData.DEFAULT);
        return data.duration();
    }

    public static void setPowerDuration(ItemStack stack, float duration) {
        BlazingRodData data = (BlazingRodData)stack.getOrDefault(BlazingModule.ITEM_BLAZING_ROD_DATA, (Object)BlazingRodData.DEFAULT);
        data = data.withDuration(duration);
        stack.set(BlazingModule.ITEM_BLAZING_ROD_DATA, (Object)data);
    }

    public static int getTotalTicks(ItemStack stack) {
        return (int)BlazingRod.getPowerDuration(stack);
    }
}

