/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.mover.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.IdMap;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public record VehicleData(List<StateWithCount> states, String name, BlockPos desiredPos, String desiredPosName) {
    public static final VehicleData DEFAULT = new VehicleData(Collections.emptyList(), "", BlockPos.ZERO, "");
    private static final Codec<StateWithCount> STATE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.CODEC.fieldOf("state").forGetter(StateWithCount::state), (App)Codec.INT.listOf().fieldOf("positions").forGetter(StateWithCount::positions)).apply((Applicative)instance, StateWithCount::new));
    private static final StreamCodec<RegistryFriendlyByteBuf, StateWithCount> STATE_STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.idMapper((IdMap)Block.BLOCK_STATE_REGISTRY), StateWithCount::state, (StreamCodec)ByteBufCodecs.INT.apply(ByteBufCodecs.list()), StateWithCount::positions, StateWithCount::new);
    public static final Codec<VehicleData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)STATE_CODEC.listOf().fieldOf("states").forGetter(VehicleData::states), (App)Codec.STRING.fieldOf("name").forGetter(VehicleData::name), (App)BlockPos.CODEC.fieldOf("desiredPos").forGetter(VehicleData::desiredPos), (App)Codec.STRING.fieldOf("desiredPosName").forGetter(VehicleData::desiredPosName)).apply((Applicative)instance, VehicleData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, VehicleData> STREAM_CODEC = StreamCodec.composite((StreamCodec)STATE_STREAM_CODEC.apply(ByteBufCodecs.list()), VehicleData::states, (StreamCodec)ByteBufCodecs.STRING_UTF8, VehicleData::name, (StreamCodec)BlockPos.STREAM_CODEC, VehicleData::desiredPos, (StreamCodec)ByteBufCodecs.STRING_UTF8, VehicleData::desiredPosName, VehicleData::new);

    public VehicleData withStates(List<StateWithCount> states) {
        return new VehicleData(states, this.name, this.desiredPos, this.desiredPosName);
    }

    public VehicleData withName(String name) {
        return new VehicleData(this.states, name, this.desiredPos, this.desiredPosName);
    }

    public VehicleData withDesiredPos(BlockPos desiredPos) {
        return new VehicleData(this.states, this.name, desiredPos, this.desiredPosName);
    }

    public VehicleData withDesiredPosName(String desiredPosName) {
        return new VehicleData(this.states, this.name, this.desiredPos, desiredPosName);
    }

    public record StateWithCount(BlockState state, List<Integer> positions) {
    }
}

