/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.modules.tablet.items;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.items.BaseItem;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.RFToolsBase;
import mcjty.rftoolsbase.api.various.IItemCycler;
import mcjty.rftoolsbase.api.various.ITabletSupport;
import mcjty.rftoolsbase.modules.tablet.TabletModule;
import mcjty.rftoolsbase.modules.tablet.data.TabletData;
import mcjty.rftoolsbase.modules.tablet.items.TabletContainer;
import mcjty.rftoolsbase.modules.tablet.items.TabletItemHandler;
import mcjty.rftoolsbase.tools.ManualHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.items.IItemHandler;

public class TabletItem
extends BaseItem
implements IItemCycler,
ITooltipSettings {
    public static final ManualEntry MANUAL = ManualHelper.create("rftoolsbase:tools/tablet");
    private final Lazy<TooltipBuilder> tooltipBuilder = Lazy.of(() -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsbase.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()}));

    public ManualEntry getManualEntry() {
        return MANUAL;
    }

    public TabletItem() {
        super(RFToolsBase.setup.defaultProperties().stacksTo(1));
    }

    public static int getCurrentSlot(ItemStack stack) {
        TabletData data = (TabletData)stack.getOrDefault(TabletModule.ITEM_TABLET_DATA, (Object)TabletData.EMPTY);
        return data.current();
    }

    public static void setCurrentSlot(Player player, ItemStack stack, int current) {
        TabletData data = (TabletData)stack.getOrDefault(TabletModule.ITEM_TABLET_DATA, (Object)TabletData.EMPTY);
        data = data.withCurrent(current);
        ItemStack containingItem = TabletItem.getContainingItem(stack, current);
        ItemStack newTablet = TabletItem.deriveNewItemstack(current, containingItem, data, current);
        player.getInventory().items.set(player.getInventory().selected, (Object)newTablet);
    }

    public static InteractionHand getHand(Player player) {
        return player.getUsedItemHand() == null ? InteractionHand.MAIN_HAND : player.getUsedItemHand();
    }

    public List<ItemStack> getItemsForTab() {
        return Collections.singletonList(new ItemStack((ItemLike)TabletModule.TABLET.get()));
    }

    @Override
    public void cycle(Player player, ItemStack stack, boolean next) {
        int currentItem = TabletItem.getCurrentSlot(stack);
        for (int tries = 7; tries > 0; --tries) {
            currentItem = next ? (currentItem + 1) % 6 : (currentItem + 6 - 1) % 6;
            ItemStack containingItem = TabletItem.getContainingItem(stack, currentItem);
            if (containingItem.isEmpty()) continue;
            TabletItem.setCurrentSlot(player, stack, currentItem);
            player.displayClientMessage((Component)ComponentFactory.literal((String)"Switched item"), false);
            return;
        }
    }

    public static ItemStack getContainingItem(ItemStack stack, int slot) {
        TabletData data = (TabletData)stack.getOrDefault(TabletModule.ITEM_TABLET_DATA, (Object)TabletData.EMPTY);
        if (slot < 0 || slot >= data.stacks().size()) {
            return ItemStack.EMPTY;
        }
        return data.stacks().get(slot);
    }

    public static void setContainingItem(Player player, InteractionHand hand, int slot, ItemStack containingItem) {
        ItemStack stack = player.getItemInHand(hand);
        TabletData data = (TabletData)stack.getOrDefault(TabletModule.ITEM_TABLET_DATA, (Object)TabletData.EMPTY);
        data = containingItem.isEmpty() ? data.setStack(slot, ItemStack.EMPTY) : data.setStack(slot, containingItem.copy());
        stack.set(TabletModule.ITEM_TABLET_DATA, (Object)data);
        int current = TabletItem.getCurrentSlot(stack);
        ItemStack newTablet = TabletItem.deriveNewItemstack(slot, containingItem, data, current);
        player.getInventory().items.set(player.getInventory().selected, (Object)newTablet);
    }

    private static ItemStack deriveNewItemstack(int slot, ItemStack containingItem, TabletData data, int current) {
        ItemStack newTablet = slot == current ? (containingItem.isEmpty() ? new ItemStack((ItemLike)TabletModule.TABLET.get()) : new ItemStack((ItemLike)((ITabletSupport)containingItem.getItem()).getInstalledTablet())) : new ItemStack((ItemLike)TabletModule.TABLET.get());
        newTablet.set(TabletModule.ITEM_TABLET_DATA, (Object)data);
        return newTablet;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide) {
            if (player.isShiftKeyDown()) {
                this.openTabletGui(player);
            } else {
                ItemStack containingItem = TabletItem.getContainingItem(stack, TabletItem.getCurrentSlot(stack));
                if (containingItem.isEmpty()) {
                    this.openTabletGui(player);
                } else if (containingItem.getItem() instanceof ITabletSupport) {
                    ((ITabletSupport)containingItem.getItem()).openGui(player, stack, containingItem);
                }
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    private void openTabletGui(Player player) {
        player.openMenu(new MenuProvider(this){

            @Nonnull
            public Component getDisplayName() {
                return ComponentFactory.literal((String)"Tablet");
            }

            public AbstractContainerMenu createMenu(int id, @Nonnull Inventory playerInventory, @Nonnull Player player) {
                TabletContainer container = new TabletContainer(id, player.blockPosition(), player);
                container.setupInventories((IItemHandler)new TabletItemHandler(player), playerInventory);
                return container;
            }
        });
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public void appendHoverText(@Nonnull ItemStack itemStack, Item.TooltipContext context, @Nonnull List<Component> list, @Nonnull TooltipFlag flags) {
        super.appendHoverText(itemStack, context, list, flags);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(Tools.getId((Item)this), itemStack, list, flags);
    }
}

