/*
 * Decompiled with CFR 0.152.
 */
package mcjty.restrictions.items;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mcjty.lib.items.GenericArmorItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;

public class GlassBootsModel
extends HumanoidModel<LivingEntity> {
    public static final ModelLayerLocation GLASS_BOOTS = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"restrictions", (String)"main"), "glass_boots");
    private static GlassBootsModel modelBoots;
    private final ModelPart bootsLeft;
    private final ModelPart bootsRight;

    public GlassBootsModel(ModelPart part) {
        super(part);
        this.bootsLeft = part.getChild("left_leg").getChild("boots_left");
        this.bootsRight = part.getChild("right_leg").getChild("boots_right");
    }

    public static LayerDefinition createBootsLayer() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        float offY = 0.0f;
        PartDefinition leftLeg = partdefinition.getChild("left_leg");
        PartDefinition bootsLeft = leftLeg.addOrReplaceChild("boots_left", CubeListBuilder.create(), PartPose.offset((float)-2.0f, (float)-12.0f, (float)0.0f));
        bootsLeft.addOrReplaceChild("foot_base", CubeListBuilder.create().texOffs(12, 0).addBox(0.0f, offY, 0.0f, 4.0f, 0.0f, 4.0f).mirror(), PartPose.offset((float)0.0f, (float)24.0f, (float)-2.0f));
        bootsLeft.addOrReplaceChild("back", CubeListBuilder.create().texOffs(0, 8).addBox(0.0f, offY, 0.0f, 4.0f, 4.0f, 2.0f).mirror(), PartPose.offset((float)0.0f, (float)20.0f, (float)2.0f));
        bootsLeft.addOrReplaceChild("front", CubeListBuilder.create().texOffs(0, 8).addBox(0.0f, offY, 0.0f, 4.0f, 4.0f, 2.0f).mirror(), PartPose.offset((float)0.0f, (float)20.0f, (float)-4.0f));
        bootsLeft.addOrReplaceChild("side2", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, offY, 0.0f, 2.0f, 4.0f, 4.0f).mirror(), PartPose.offset((float)0.0f, (float)20.0f, (float)-2.0f));
        bootsLeft.addOrReplaceChild("side1", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, offY, 0.0f, 2.0f, 4.0f, 4.0f).mirror(), PartPose.offset((float)4.0f, (float)20.0f, (float)-2.0f));
        bootsLeft.addOrReplaceChild("tip", CubeListBuilder.create().texOffs(12, 4).addBox(0.0f, offY, 0.0f, 2.0f, 3.0f, 1.0f).mirror(), PartPose.offset((float)1.0f, (float)21.0f, (float)-5.0f));
        PartDefinition rightLeg = partdefinition.getChild("right_leg");
        PartDefinition bootsRight = rightLeg.addOrReplaceChild("boots_right", CubeListBuilder.create(), PartPose.offset((float)2.0f, (float)-12.0f, (float)0.0f));
        bootsRight.addOrReplaceChild("foot_base", CubeListBuilder.create().texOffs(12, 0).addBox(0.0f, offY, 0.0f, 4.0f, 0.0f, 4.0f).mirror(), PartPose.offset((float)-4.0f, (float)24.0f, (float)-2.0f));
        bootsRight.addOrReplaceChild("back", CubeListBuilder.create().texOffs(0, 8).addBox(0.0f, offY, 0.0f, 4.0f, 4.0f, 2.0f).mirror(), PartPose.offset((float)-4.0f, (float)20.0f, (float)2.0f));
        bootsRight.addOrReplaceChild("front", CubeListBuilder.create().texOffs(0, 8).addBox(0.0f, offY, 0.0f, 4.0f, 4.0f, 2.0f).mirror(), PartPose.offset((float)-4.0f, (float)20.0f, (float)-4.0f));
        bootsRight.addOrReplaceChild("side2", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, offY, 0.0f, 2.0f, 4.0f, 4.0f).mirror(), PartPose.offset((float)-2.0f, (float)20.0f, (float)-2.0f));
        bootsRight.addOrReplaceChild("side1", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, offY, 0.0f, 2.0f, 4.0f, 4.0f).mirror(), PartPose.offset((float)-6.0f, (float)20.0f, (float)-2.0f));
        bootsRight.addOrReplaceChild("tip", CubeListBuilder.create().texOffs(12, 4).addBox(0.0f, offY, 0.0f, 2.0f, 3.0f, 1.0f).mirror(), PartPose.offset((float)-3.0f, (float)21.0f, (float)-5.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public static <A extends HumanoidModel<?>> A getModel(LivingEntity entity, ItemStack stack) {
        if (stack.isEmpty() || !(stack.getItem() instanceof ArmorItem)) {
            return null;
        }
        EquipmentSlot slot = GenericArmorItem.getSlotForItem((ItemStack)stack);
        if (slot == EquipmentSlot.FEET && modelBoots != null) {
            return (A)((Object)modelBoots);
        }
        GlassBootsModel armor = new GlassBootsModel(Minecraft.getInstance().getEntityModels().bakeLayer(GLASS_BOOTS));
        armor.body.visible = false;
        armor.leftArm.visible = false;
        armor.rightArm.visible = false;
        armor.head.visible = false;
        armor.leftLeg.visible = false;
        armor.rightLeg.visible = false;
        armor.bootsRight.visible = false;
        armor.bootsLeft.visible = false;
        if (slot == EquipmentSlot.FEET) {
            armor.bootsLeft.visible = true;
            armor.bootsRight.visible = true;
            modelBoots = armor;
        }
        return (A)((Object)armor);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer consumer, int packedlight, int packedOverlay, int color) {
        super.renderToBuffer(poseStack, consumer, packedlight, packedOverlay, color);
    }

    public void setupAnim(LivingEntity entity, float p_225597_2_, float p_225597_3_, float p_225597_4_, float p_225597_5_, float p_225597_6_) {
        this.crouching = entity.isShiftKeyDown();
        this.riding = entity.isPassenger();
        super.setupAnim(entity, p_225597_2_, p_225597_3_, p_225597_4_, p_225597_5_, p_225597_6_);
        if (this.young) {
            float f = 2.0f;
        }
    }
}

