/*
 * Decompiled with CFR 0.152.
 */
package mcjty.restrictions.blocks;

import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.restrictions.items.GlassBoots;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class OneWayWall
extends BaseBlock {
    public OneWayWall() {
        super(new BlockBuilder().properties(BlockBehaviour.Properties.of().isSuffocating((state, reader, pos) -> false).isRedstoneConductor((state, reader, pos) -> false).strength(2.0f).noOcclusion().sound(SoundType.GLASS)).info(new InfoLine[]{TooltipBuilder.key((String)"message.restrictions.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}));
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entityContext;
        Entity entity;
        Direction direction = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        if (context instanceof EntityCollisionContext && (entity = (entityContext = (EntityCollisionContext)context).getEntity()) != null) {
            Player player;
            ItemStack boots;
            if (entity instanceof Player && !(boots = (player = (Player)entity).getItemBySlot(EquipmentSlot.FEET)).isEmpty() && boots.getItem() instanceof GlassBoots) {
                return Shapes.empty();
            }
            if (direction.getStepX() == 1 ? entity.getDeltaMovement().x() > 0.0 : direction.getStepX() == -1 && entity.getDeltaMovement().x() < 0.0) {
                return Shapes.block();
            }
            if (direction.getStepY() == 1 ? entity.getDeltaMovement().y() > 0.0 : direction.getStepY() == -1 && entity.getDeltaMovement().y() < 0.0) {
                return Shapes.block();
            }
            if (direction.getStepZ() == 1 ? entity.getDeltaMovement().z() > 0.0 : direction.getStepZ() == -1 && entity.getDeltaMovement().z() < 0.0) {
                return Shapes.block();
            }
        }
        return Shapes.empty();
    }

    public int getLightBlock(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return 15;
    }
}

