/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.utils;

import com.google.gson.JsonObject;
import com.teamresourceful.resourcefullib.common.exceptions.UtilityClassException;
import com.teamresourceful.resourcefullib.common.utils.GsonHelpers;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public final class WebUtils {
    private static final HttpClient CLIENT = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofSeconds(10L)).build();

    private WebUtils() throws UtilityClassException {
        throw new UtilityClassException();
    }

    @Nullable
    public static String get(String url, boolean onlySuccess) {
        return WebUtils.get(url, HttpResponse.BodyHandlers.ofString()).filter(response -> !onlySuccess || response.statusCode() >= 200 && response.statusCode() < 300).map(HttpResponse::body).orElse(null);
    }

    @Nullable
    public static String get(String url) {
        return WebUtils.get(url, false);
    }

    @Nullable
    public static JsonObject getJson(String url, boolean onlySuccess) {
        return GsonHelpers.parseJson(WebUtils.get(url, onlySuccess)).orElse(null);
    }

    @Nullable
    public static JsonObject getJson(String url) {
        return WebUtils.getJson(url, false);
    }

    public static <T> Optional<HttpResponse<T>> get(String url, HttpResponse.BodyHandler<T> handler) {
        try {
            HttpRequest request = HttpRequest.newBuilder(new URI(url)).GET().version(HttpClient.Version.HTTP_2).header("User-Agent", "Minecraft Mod").build();
            return Optional.of(CLIENT.send(request, handler));
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }
}

