/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.bytecodecs;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.teamresourceful.bytecodecs.base.ByteCodec;
import com.teamresourceful.bytecodecs.base.ObjectEntryByteCodec;
import com.teamresourceful.bytecodecs.base.object.ObjectByteCodec;
import com.teamresourceful.resourcefullib.common.ApiProxy;
import com.teamresourceful.resourcefullib.common.bytecodecs.CompoundTagByteCodec;
import com.teamresourceful.resourcefullib.common.bytecodecs.IdMapByteCodec;
import com.teamresourceful.resourcefullib.common.bytecodecs.StreamCodecByteCodec;
import com.teamresourceful.resourcefullib.common.exceptions.UtilityClassException;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import org.joml.Vector3f;

public final class ExtraByteCodecs {
    public static final ByteCodec<ResourceLocation> RESOURCE_LOCATION = ByteCodec.STRING.map(ResourceLocation::parse, ResourceLocation::toString);
    public static final ByteCodec<ResourceKey<Level>> DIMENSION = ExtraByteCodecs.resourceKey(Registries.DIMENSION);
    public static final ByteCodec<BlockPos> BLOCK_POS = ByteCodec.LONG.map(BlockPos::of, BlockPos::asLong);
    public static final ByteCodec<ChunkPos> CHUNK_POS = ByteCodec.LONG.map(ChunkPos::new, ChunkPos::toLong);
    public static final ByteCodec<SectionPos> SECTION_POS = ByteCodec.LONG.map(SectionPos::of, SectionPos::asLong);
    public static final ByteCodec<GlobalPos> GLOBAL_POS = ObjectByteCodec.create((ObjectEntryByteCodec)DIMENSION.fieldOf(GlobalPos::dimension), (ObjectEntryByteCodec)BLOCK_POS.fieldOf(GlobalPos::pos), GlobalPos::of);
    public static final ByteCodec<Vector3f> VECTOR_3F = ObjectByteCodec.create((ObjectEntryByteCodec)ByteCodec.FLOAT.fieldOf(Vector3f::x), (ObjectEntryByteCodec)ByteCodec.FLOAT.fieldOf(Vector3f::y), (ObjectEntryByteCodec)ByteCodec.FLOAT.fieldOf(Vector3f::z), Vector3f::new);
    public static final ByteCodec<CompoundTag> NULLABLE_COMPOUND_TAG = CompoundTagByteCodec.INSTANCE.map(value -> value.orElse(null), Optional::ofNullable);
    public static final ByteCodec<CompoundTag> NONNULL_COMPOUND_TAG = CompoundTagByteCodec.INSTANCE.map(Optional::orElseThrow, Optional::of);
    public static final ByteCodec<Optional<CompoundTag>> COMPOUND_TAG = CompoundTagByteCodec.INSTANCE;
    public static final ByteCodec<Component> COMPONENT = StreamCodecByteCodec.ofRegistry(ComponentSerialization.STREAM_CODEC);
    public static final ByteCodec<Item> ITEM = ExtraByteCodecs.registry(BuiltInRegistries.ITEM);
    public static final ByteCodec<Fluid> FLUID = ExtraByteCodecs.registry(BuiltInRegistries.FLUID);
    public static final ByteCodec<ItemStack> ITEM_STACK = StreamCodecByteCodec.ofRegistry(ItemStack.STREAM_CODEC);
    public static final ByteCodec<Ingredient> INGREDIENT = StreamCodecByteCodec.ofRegistry(Ingredient.CONTENTS_STREAM_CODEC);

    private ExtraByteCodecs() throws UtilityClassException {
        throw new UtilityClassException();
    }

    public static <T, R extends Registry<T>> ByteCodec<ResourceKey<T>> resourceKey(ResourceKey<R> registry) {
        return RESOURCE_LOCATION.map(id -> ResourceKey.create((ResourceKey)registry, (ResourceLocation)id), ResourceKey::location);
    }

    public static <T> ByteCodec<T> registry(IdMap<T> map) {
        return new IdMapByteCodec<T>(map);
    }

    public static <A, B> ByteCodec<Pair<A, B>> pair(ByteCodec<A> first, ByteCodec<B> second) {
        return ObjectByteCodec.create((ObjectEntryByteCodec)first.fieldOf(Pair::getFirst), (ObjectEntryByteCodec)second.fieldOf(Pair::getSecond), Pair::of);
    }

    public static <A, B> ByteCodec<Either<A, B>> either(ByteCodec<A> first, ByteCodec<B> second) {
        ByteCodec left = first.map(Either::left, either -> either.left().orElseThrow());
        ByteCodec right = second.map(Either::right, either -> either.right().orElseThrow());
        return ByteCodec.BOOLEAN.dispatch(value -> value != false ? left : right, either -> (Boolean)either.map(l -> true, r -> false));
    }

    public static FriendlyByteBuf toFriendly(ByteBuf buffer) {
        FriendlyByteBuf friendlyByteBuf;
        return buffer instanceof FriendlyByteBuf ? (friendlyByteBuf = (FriendlyByteBuf)buffer) : new FriendlyByteBuf(buffer);
    }

    public static RegistryFriendlyByteBuf toRegistry(ByteBuf buffer) {
        if (buffer instanceof RegistryFriendlyByteBuf) {
            RegistryFriendlyByteBuf registryFriendlyByteBuf = (RegistryFriendlyByteBuf)buffer;
            return registryFriendlyByteBuf;
        }
        if (!ApiProxy.hasProxy()) {
            throw new IllegalStateException("No proxy found.");
        }
        return new RegistryFriendlyByteBuf(buffer, ApiProxy.getRegistry());
    }
}

