/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.world.features.configs.StructureTargetConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class StructureFire
extends Feature<StructureTargetConfig> {
    private static final Map<ResourceKey<Level>, TagKey<Block>> INFINITE_FIRE_BLOCKS = new HashMap<ResourceKey<Level>, TagKey<Block>>(){
        {
            this.put(Level.OVERWORLD, BlockTags.INFINIBURN_OVERWORLD);
            this.put(Level.NETHER, BlockTags.INFINIBURN_NETHER);
            this.put(Level.END, BlockTags.INFINIBURN_END);
        }
    };
    private static final Set<Block> REPLACEABLE_BLOCKS = Set.of(Blocks.NETHER_BRICKS, Blocks.RED_NETHER_BRICKS, Blocks.CRIMSON_NYLIUM, Blocks.WARPED_NYLIUM);

    public StructureFire(Codec<StructureTargetConfig> config) {
        super(config);
    }

    public boolean place(FeaturePlaceContext<StructureTargetConfig> context) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        BlockState fire = Blocks.FIRE.defaultBlockState();
        BlockState soulFire = Blocks.SOUL_FIRE.defaultBlockState();
        TagKey<Block> infiniteBurningBlocksTagKey = INFINITE_FIRE_BLOCKS.getOrDefault(context.level().getLevel().dimension(), (TagKey<Block>)BlockTags.INFINIBURN_OVERWORLD);
        for (int i = 0; i < ((StructureTargetConfig)context.config()).attempts; ++i) {
            boolean belowIsSoul;
            mutable.set((Vec3i)context.origin()).move(context.random().nextInt(7) - 3, -1, context.random().nextInt(7) - 3);
            BlockState belowBlock = context.level().getBlockState(mutable.below());
            boolean bl = belowIsSoul = belowBlock.getBlock() == Blocks.SOUL_SOIL || belowBlock.getBlock() == Blocks.SOUL_SAND;
            if (!context.level().getBlockState((BlockPos)mutable).isAir() || !REPLACEABLE_BLOCKS.contains(belowBlock.getBlock()) && !belowBlock.is(infiniteBurningBlocksTagKey) && !belowIsSoul) continue;
            if (REPLACEABLE_BLOCKS.contains(belowBlock.getBlock())) {
                context.level().setBlock(mutable.below(), Blocks.NETHERRACK.defaultBlockState(), 3);
            }
            if (belowIsSoul) {
                context.level().setBlock((BlockPos)mutable, soulFire, 3);
                continue;
            }
            context.level().setBlock((BlockPos)mutable, fire, 3);
        }
        return true;
    }
}

