/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.telepathicgrunt.repurposedstructures.mixins.entities.ShulkerEntityInvoker;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class ShulkerMob
extends Feature<NoneFeatureConfiguration> {
    public ShulkerMob() {
        super(NoneFeatureConfiguration.CODEC);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos position = context.origin().below();
        Shulker shulkerEntity = (Shulker)EntityType.SHULKER.create((Level)context.level().getLevel());
        shulkerEntity.setPersistenceRequired();
        shulkerEntity.absMoveTo((double)position.getX() + 0.5, (double)position.getY(), (double)position.getZ() + 0.5);
        Direction shulkerAttachment = Direction.UP;
        for (Direction direction : Direction.values()) {
            BlockState blockStateCurrentSpot = context.level().getBlockState(position);
            BlockState blockStateAttachmentSpot = context.level().getBlockState(position.relative(direction));
            if (!blockStateCurrentSpot.isAir() || !blockStateAttachmentSpot.canOcclude()) continue;
            shulkerAttachment = direction;
            break;
        }
        ((ShulkerEntityInvoker)shulkerEntity).repurposedstructures_callSetAttachFace(shulkerAttachment);
        context.level().addFreshEntityWithPassengers((Entity)shulkerEntity);
        return true;
    }
}

