/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.mixins.features;

import com.telepathicgrunt.repurposedstructures.modinit.RSTags;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BushFoliagePlacer;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TreeFeature.class})
public class LessJungleBushInStructuresMixin {
    @Inject(method={"place(Lnet/minecraft/world/level/levelgen/feature/FeaturePlaceContext;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void repurposedstructures_lessJungleBushInStructures(FeaturePlaceContext<TreeConfiguration> context, CallbackInfoReturnable<Boolean> cir) {
        WorldGenLevel worldGenLevel = context.level();
        if (worldGenLevel instanceof WorldGenRegion) {
            WorldGenRegion worldGenRegion = (WorldGenRegion)worldGenLevel;
            if (((TreeConfiguration)context.config()).foliagePlacer instanceof BushFoliagePlacer && ((TreeConfiguration)context.config()).minimumSize.minClippedHeight().orElse(0) < 2 && context.random().nextFloat() < 0.85f) {
                Registry structureRegistry = (Registry)worldGenRegion.registryAccess().registry(Registries.STRUCTURE).get();
                List<StructureStart> structureStarts = GeneralUtils.inboundsValidStartsForAllStructure(worldGenRegion, context.origin(), struct -> structureRegistry.getHolderOrThrow((ResourceKey)structureRegistry.getResourceKey(struct).get()).is(RSTags.LESS_JUNGLE_BUSHES));
                if (!structureStarts.isEmpty()) {
                    cir.setReturnValue((Object)false);
                }
            }
        }
    }
}

