/*
 * Decompiled with CFR 0.152.
 */
package reliquary.util;

import java.util.Optional;
import java.util.Set;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;

public class MobHelper {
    private static final Set<MemoryModuleType<?>> TARGET_MEMORIES = Set.of(MemoryModuleType.ATTACK_TARGET, MemoryModuleType.ANGRY_AT, MemoryModuleType.UNIVERSAL_ANGER, MemoryModuleType.NEAREST_TARGETABLE_PLAYER_NOT_WEARING_GOLD, MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER);

    private MobHelper() {
    }

    public static void resetTarget(Mob entity) {
        MobHelper.resetTarget(entity, false);
    }

    public static void resetTarget(Mob entity, boolean resetRevengeTarget) {
        Brain brain = entity.getBrain();
        for (MemoryModuleType<?> memory : TARGET_MEMORIES) {
            if (!brain.hasMemoryValue(memory)) continue;
            MobHelper.emptyMemory(brain, memory);
        }
        entity.setTarget(null);
        if (resetRevengeTarget) {
            entity.setLastHurtByMob(null);
        }
    }

    private static <T> void emptyMemory(Brain<?> brain, MemoryModuleType<T> memory) {
        brain.setMemory(memory, Optional.empty());
    }

    public static Optional<Player> getTargetedPlayerFromMemory(Mob entity) {
        Brain brain = entity.getBrain();
        for (MemoryModuleType<?> memory : TARGET_MEMORIES) {
            Optional value;
            if (!brain.hasMemoryValue(memory) || !(value = brain.getMemory(memory)).isPresent() || !(value.get() instanceof Player)) continue;
            return Optional.of((Player)value.get());
        }
        return Optional.empty();
    }
}

