/*
 * Decompiled with CFR 0.152.
 */
package reliquary.pedestal.wrappers;

import java.util.ArrayDeque;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.util.FakePlayer;
import reliquary.api.IPedestal;
import reliquary.api.IPedestalActionItemWrapper;
import reliquary.blocks.FertileLilyPadBlock;
import reliquary.init.ModItems;
import reliquary.items.HarvestRodItem;
import reliquary.reference.Config;
import reliquary.util.ItemHelper;

public class PedestalHarvestRodWrapper
implements IPedestalActionItemWrapper {
    private static final int NO_JOB_COOL_DOWN_CYCLES = 10;
    private static final HarvestRodItem harvestRod = ModItems.HARVEST_ROD.get();
    private int hoeCoolDown = 0;
    private int plantCoolDown = 0;
    private int boneMealCoolDown = 0;
    private int breakCoolDown = 0;
    private final Queue<BlockPos> queueToHoe = new ArrayDeque<BlockPos>();
    private final Queue<BlockPos> queueToPlant = new ArrayDeque<BlockPos>();
    private final Queue<BlockPos> queueToBoneMeal = new ArrayDeque<BlockPos>();
    private final Queue<BlockPos> queueToBreak = new ArrayDeque<BlockPos>();

    @Override
    public void update(ItemStack stack, Level level, IPedestal pedestal) {
        BlockPos pos = pedestal.getBlockPosition();
        int cooldown = (Integer)Config.COMMON.items.harvestRod.pedestalCooldown.get();
        pedestal.getFakePlayer().ifPresent(fakePlayer -> {
            int range = (Integer)Config.COMMON.items.harvestRod.pedestalRange.get();
            this.hoeLand(level, (Player)fakePlayer, pos, range);
            this.plantSeeds(level, (Player)fakePlayer, pos, stack, range);
            this.boneMealCrops(level, (FakePlayer)fakePlayer, pos, stack, range);
            this.breakCrops(level, (Player)fakePlayer, pos, stack, range);
        });
        pedestal.setActionCoolDown(cooldown);
    }

    @Override
    public void onRemoved(ItemStack stack, Level level, IPedestal pedestal) {
    }

    @Override
    public void stop(ItemStack stack, Level level, IPedestal pedestal) {
    }

    private void breakCrops(Level level, Player player, BlockPos pos, ItemStack stack, int range) {
        if (this.breakCoolDown > 0) {
            --this.breakCoolDown;
        } else if (!this.breakNext(level, player, pos, stack, range)) {
            this.breakCoolDown = 10;
        }
    }

    private boolean breakNext(Level level, Player player, BlockPos pos, ItemStack stack, int range) {
        return this.getNextBlockToBreak(level, pos, range).map(nextBlockToBreak -> {
            this.doHarvestBlockBreak(level, player, stack, (BlockPos)nextBlockToBreak);
            return true;
        }).orElse(false);
    }

    private void doHarvestBlockBreak(Level level, Player player, ItemStack stack, BlockPos pos) {
        BlockState blockState = level.getBlockState(pos);
        List drops = Block.getDrops((BlockState)blockState, (ServerLevel)((ServerLevel)level), (BlockPos)pos, null, (Entity)player, (ItemStack)stack);
        for (ItemStack drop : drops) {
            float f = 0.7f;
            double d = (double)(level.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(level.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(level.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            ItemEntity entityitem = new ItemEntity(level, (double)pos.getX() + d, (double)pos.getY() + d1, (double)pos.getZ() + d2, drop);
            entityitem.setPickUpDelay(10);
            level.addFreshEntity((Entity)entityitem);
        }
        level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
    }

    private void boneMealCrops(Level level, FakePlayer fakePlayer, BlockPos pos, ItemStack stack, int range) {
        if (this.boneMealCoolDown > 0) {
            --this.boneMealCoolDown;
        } else {
            if (harvestRod.getBoneMealCount(stack) >= harvestRod.getBonemealCost() && this.boneMealNext(level, fakePlayer, pos, stack, range)) {
                return;
            }
            this.boneMealCoolDown = 10;
        }
    }

    private boolean boneMealNext(Level level, FakePlayer fakePlayer, BlockPos pos, ItemStack stack, int range) {
        return this.getNextBlockToBoneMeal(level, pos, range).map(blockToBoneMeal -> {
            this.boneMealBlock(stack, fakePlayer, level, (BlockPos)blockToBoneMeal);
            return true;
        }).orElse(false);
    }

    private void boneMealBlock(ItemStack stack, FakePlayer fakePlayer, Level level, BlockPos pos) {
        ItemStack fakeItemStack = new ItemStack((ItemLike)Items.BONE_MEAL);
        boolean boneMealUsed = false;
        for (int repeatedUses = 0; repeatedUses <= harvestRod.getLuckRolls(); ++repeatedUses) {
            if (repeatedUses != 0 && level.random.nextInt(100) > harvestRod.getLuckPercent() || !BoneMealItem.applyBonemeal((ItemStack)fakeItemStack, (Level)level, (BlockPos)pos, (Player)fakePlayer)) continue;
            boneMealUsed = true;
        }
        if (boneMealUsed) {
            level.levelEvent(2005, pos, 0);
            harvestRod.setBoneMealCount(stack, harvestRod.getBoneMealCount(stack) - harvestRod.getBonemealCost());
        }
    }

    private void plantSeeds(Level level, Player player, BlockPos pos, ItemStack stack, int range) {
        if (this.plantCoolDown > 0) {
            --this.plantCoolDown;
        } else {
            int quantity;
            byte plantableSlot = 1;
            if (harvestRod.getCountOfPlantables(stack) > 0 && (quantity = harvestRod.getPlantableQuantity(stack, plantableSlot)) > 0 && this.plantNext(level, player, pos, stack, range, plantableSlot)) {
                return;
            }
            this.plantCoolDown = 10;
        }
    }

    private boolean plantNext(Level level, Player player, BlockPos pos, ItemStack stack, int range, byte plantableSlot) {
        return this.getNextBlockToPlantOn(level, pos, range, harvestRod.getPlantableInSlot(stack, plantableSlot)).map(blockToPlantOn -> {
            this.plantItem(player, (BlockPos)blockToPlantOn, stack, plantableSlot);
            return true;
        }).orElse(false);
    }

    private void plantItem(Player player, BlockPos pos, ItemStack stack, byte idx) {
        ItemStack fakePlantableStack = harvestRod.getPlantableInSlot(stack, idx).copy();
        fakePlantableStack.setCount(1);
        player.setItemInHand(InteractionHand.MAIN_HAND, fakePlantableStack);
        if (fakePlantableStack.useOn(ItemHelper.getItemUseContext(pos, player)).consumesAction()) {
            harvestRod.decrementPlantable(stack, idx, 1);
        }
    }

    private void hoeLand(Level level, Player player, BlockPos pos, int range) {
        if (this.hoeCoolDown > 0) {
            --this.hoeCoolDown;
        } else if (!this.hoeNext(level, player, pos, range)) {
            this.hoeCoolDown = 10;
        }
    }

    private boolean hoeNext(Level level, Player player, BlockPos pos, int range) {
        return this.getNextBlockToHoe(level, pos, range).map(blockToHoe -> {
            ItemStack fakeHoe = new ItemStack((ItemLike)Items.WOODEN_HOE);
            player.setItemInHand(InteractionHand.MAIN_HAND, fakeHoe);
            Items.WOODEN_HOE.useOn(ItemHelper.getItemUseContext(blockToHoe, player));
            return true;
        }).orElse(false);
    }

    private Optional<BlockPos> getNextBlockToBreak(Level level, BlockPos pos, int range) {
        if (this.queueToBreak.isEmpty()) {
            this.fillQueueToBreak(level, pos, range);
        }
        return Optional.ofNullable(this.queueToBreak.poll());
    }

    private void fillQueueToBreak(Level level, BlockPos pos, int range) {
        BlockPos.betweenClosedStream((BlockPos)pos.offset(-range, -range, -range), (BlockPos)pos.offset(range, range, range)).forEach(p -> {
            BlockPos currentPos = p.immutable();
            BlockState state = level.getBlockState(currentPos);
            Block block = state.getBlock();
            if (state.is(BlockTags.CROPS) || block instanceof BushBlock || block == Blocks.MELON || block == Blocks.PUMPKIN) {
                CropBlock cropBlock;
                if (block instanceof FertileLilyPadBlock || block == Blocks.PUMPKIN_STEM || block == Blocks.MELON_STEM || block instanceof CropBlock && (cropBlock = (CropBlock)block).isValidBonemealTarget((LevelReader)level, currentPos, state) || block instanceof NetherWartBlock && (Integer)state.getValue((Property)NetherWartBlock.AGE) < 3 || block instanceof SweetBerryBushBlock && (Integer)state.getValue((Property)SweetBerryBushBlock.AGE) < 3) {
                    return;
                }
                this.queueToBreak.add(currentPos);
            }
        });
    }

    private Optional<BlockPos> getNextBlockToHoe(Level level, BlockPos pos, int range) {
        if (this.queueToHoe.isEmpty()) {
            this.fillQueueToHoe(level, pos, range);
        }
        return Optional.ofNullable(this.queueToHoe.poll());
    }

    private void fillQueueToHoe(Level level, BlockPos pos, int range) {
        this.queueToHoe.clear();
        BlockPos.betweenClosedStream((BlockPos)pos.offset(-range, -range, -range), (BlockPos)pos.offset(range, range, range)).forEach(p -> {
            BlockPos currentPos = p.immutable();
            BlockState blockState = level.getBlockState(currentPos);
            Block block = blockState.getBlock();
            if (level.isEmptyBlock(currentPos.above()) && (block == Blocks.GRASS_BLOCK || block == Blocks.DIRT_PATH || block == Blocks.DIRT || block == Blocks.COARSE_DIRT)) {
                this.queueToHoe.add(currentPos);
            }
        });
    }

    private Optional<BlockPos> getNextBlockToPlantOn(Level level, BlockPos pos, int range, ItemStack plantable) {
        if (this.queueToPlant.isEmpty()) {
            this.fillQueueToPlant(level, pos, range, plantable);
        }
        return Optional.ofNullable(this.queueToPlant.poll());
    }

    private void fillQueueToPlant(Level level, BlockPos pos, int range, ItemStack plantable) {
        this.queueToPlant.clear();
        boolean checkerboard = false;
        boolean bothOddOrEven = false;
        if (plantable.getItem() == Items.PUMPKIN_SEEDS || plantable.getItem() == Items.MELON_SEEDS) {
            checkerboard = true;
            boolean xEven = pos.getX() % 2 == 0;
            boolean zEven = pos.getZ() % 2 == 0;
            bothOddOrEven = xEven == zEven;
        }
        boolean finalCheckerboard = checkerboard;
        boolean finalBothOddOrEven = bothOddOrEven;
        BlockPos.betweenClosedStream((BlockPos)pos.offset(-range, -range, -range), (BlockPos)pos.offset(range, range, range)).forEach(p -> {
            BlockPos currentPos = p.immutable();
            BlockState blockState = level.getBlockState(currentPos);
            if ((!finalCheckerboard || finalBothOddOrEven == (currentPos.getX() % 2 == 0 == (currentPos.getZ() % 2 == 0))) && HarvestRodItem.canPlacePlantableAt(level, currentPos.above(), plantable) && level.isEmptyBlock(currentPos.above())) {
                this.queueToPlant.add(currentPos);
            }
        });
    }

    private Optional<BlockPos> getNextBlockToBoneMeal(Level level, BlockPos pos, int range) {
        if (this.queueToBoneMeal.isEmpty()) {
            this.fillQueueToBoneMeal(level, pos, range);
        }
        return Optional.ofNullable(this.queueToBoneMeal.poll());
    }

    private void fillQueueToBoneMeal(Level level, BlockPos pos, int range) {
        this.queueToBoneMeal.clear();
        BlockPos.betweenClosedStream((BlockPos)pos.offset(-range, -range, -range), (BlockPos)pos.offset(range, range, range)).forEach(p -> {
            BonemealableBlock bonemealableBlock;
            Block patt0$temp;
            BlockPos currentPos = p.immutable();
            BlockState blockState = level.getBlockState(currentPos);
            if (blockState.getBlock() != Blocks.GRASS_BLOCK && (patt0$temp = blockState.getBlock()) instanceof BonemealableBlock && (bonemealableBlock = (BonemealableBlock)patt0$temp).isValidBonemealTarget((LevelReader)level, currentPos, blockState)) {
                this.queueToBoneMeal.add(currentPos);
            }
        });
    }
}

