/*
 * Decompiled with CFR 0.152.
 */
package reliquary.network;

import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import reliquary.Reliquary;
import reliquary.compat.curios.CuriosCompat;
import reliquary.init.ModItems;
import reliquary.items.FortuneCoinItem;

public record FortuneCoinTogglePressedPayload(InventoryType inventoryType, int slot, String identifier) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<FortuneCoinTogglePressedPayload> TYPE = new CustomPacketPayload.Type(Reliquary.getRL("fortune_coin_toggle_pressed"));
    public static final StreamCodec<FriendlyByteBuf, FortuneCoinTogglePressedPayload> STREAM_CODEC = StreamCodec.composite(InventoryType.STREAM_CODEC, FortuneCoinTogglePressedPayload::inventoryType, (StreamCodec)ByteBufCodecs.INT, FortuneCoinTogglePressedPayload::slot, (StreamCodec)ByteBufCodecs.STRING_UTF8, FortuneCoinTogglePressedPayload::identifier, FortuneCoinTogglePressedPayload::new);

    public FortuneCoinTogglePressedPayload(InventoryType inventoryType, int slot) {
        this(inventoryType, slot, "");
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handlePayload(FortuneCoinTogglePressedPayload payload, IPayloadContext context) {
        Player player = context.player();
        switch (payload.inventoryType.ordinal()) {
            case 0: {
                ItemStack stack2 = (ItemStack)player.getInventory().items.get(payload.slot);
                if (stack2.getItem() != ModItems.FORTUNE_COIN.get()) break;
                ModItems.FORTUNE_COIN.get().toggle(stack2);
                FortuneCoinTogglePressedPayload.showMessage(player, stack2);
                break;
            }
            case 1: {
                ItemStack stack1 = (ItemStack)player.getInventory().offhand.getFirst();
                if (stack1.getItem() != ModItems.FORTUNE_COIN.get()) break;
                ModItems.FORTUNE_COIN.get().toggle(stack1);
                FortuneCoinTogglePressedPayload.showMessage(player, stack1);
                break;
            }
            case 2: {
                FortuneCoinTogglePressedPayload.run(() -> () -> CuriosCompat.getStackInSlot((LivingEntity)player, payload.identifier, payload.slot).ifPresent(stack -> {
                    if (stack.getItem() == ModItems.FORTUNE_COIN.get()) {
                        ModItems.FORTUNE_COIN.get().toggle((ItemStack)stack);
                        FortuneCoinTogglePressedPayload.showMessage(player, stack);
                        CuriosCompat.setStackInSlot((LivingEntity)player, payload.identifier, payload.slot, stack);
                    }
                }));
            }
        }
    }

    private static void showMessage(Player player, ItemStack fortuneCoin) {
        player.displayClientMessage((Component)Component.translatable((String)"chat.reliquary.fortune_coin.toggle", (Object[])new Object[]{FortuneCoinItem.isEnabled(fortuneCoin) ? Component.translatable((String)"chat.reliquary.fortune_coin.on").withStyle(ChatFormatting.GREEN) : Component.translatable((String)"chat.reliquary.fortune_coin.off").withStyle(ChatFormatting.RED)}), true);
    }

    private static void run(Supplier<Runnable> toRun) {
        toRun.get().run();
    }

    public static enum InventoryType {
        MAIN,
        OFF_HAND,
        CURIOS;

        public static final StreamCodec<FriendlyByteBuf, InventoryType> STREAM_CODEC;

        static {
            STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(InventoryType.class);
        }
    }
}

