/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import reliquary.items.ToggleableItem;
import reliquary.reference.Config;
import reliquary.util.TooltipBuilder;

public class EmperorChaliceItem
extends ToggleableItem {
    public EmperorChaliceItem() {
        super(new Item.Properties().stacksTo(1).setNoRepair().rarity(Rarity.EPIC));
        NeoForge.EVENT_BUS.addListener(this::onBlockRightClick);
    }

    @Override
    protected void addMoreInformation(ItemStack stack, @Nullable HolderLookup.Provider registries, TooltipBuilder tooltipBuilder) {
        tooltipBuilder.description(this, ".tooltip2", new Object[0]);
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    public int getUseDuration(ItemStack stack, LivingEntity livingEntity) {
        return 16;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        if (level.isClientSide) {
            return stack;
        }
        if (!(livingEntity instanceof Player)) {
            return stack;
        }
        Player player = (Player)livingEntity;
        int multiplier = (Integer)Config.COMMON.items.emperorChalice.hungerSatiationMultiplier.get();
        player.getFoodData().eat(1, (float)multiplier / 2.0f);
        player.hurt(player.damageSources().drown(), (float)multiplier);
        return stack;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack emperorChalice = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            return super.use(level, player, hand);
        }
        boolean isInDrainMode = this.isEnabled(emperorChalice);
        BlockHitResult result = EmperorChaliceItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)(isInDrainMode ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE));
        if (result == null || result.getType() == HitResult.Type.MISS) {
            if (!this.isEnabled(emperorChalice)) {
                player.startUsingItem(hand);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)emperorChalice);
        }
        if (result.getType() == HitResult.Type.BLOCK) {
            boolean success;
            if (!level.mayInteract(player, result.getBlockPos()) || !player.mayUseItemAt(result.getBlockPos(), result.getDirection(), emperorChalice)) {
                return new InteractionResultHolder(InteractionResult.FAIL, (Object)emperorChalice);
            }
            IFluidHandlerItem fluidHandler = (IFluidHandlerItem)emperorChalice.getCapability(Capabilities.FluidHandler.ITEM);
            if (fluidHandler != null && (success = !this.isEnabled(emperorChalice) ? this.placeWater(level, player, hand, fluidHandler, result) : FluidUtil.tryPickUpFluid((ItemStack)emperorChalice, (Player)player, (Level)level, (BlockPos)result.getBlockPos(), (Direction)result.getDirection()).isSuccess())) {
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)emperorChalice);
            }
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)emperorChalice);
    }

    private boolean placeWater(Level level, Player player, InteractionHand hand, IFluidHandlerItem fluidHandler, BlockHitResult result) {
        if (FluidUtil.tryPlaceFluid((Player)player, (Level)level, (InteractionHand)hand, (BlockPos)result.getBlockPos(), (IFluidHandler)fluidHandler, (FluidStack)new FluidStack((Fluid)Fluids.WATER, 1000))) {
            return true;
        }
        return FluidUtil.tryPlaceFluid((Player)player, (Level)level, (InteractionHand)hand, (BlockPos)result.getBlockPos().relative(result.getDirection()), (IFluidHandler)fluidHandler, (FluidStack)new FluidStack((Fluid)Fluids.WATER, 1000));
    }

    private void onBlockRightClick(PlayerInteractEvent.RightClickBlock evt) {
        if (evt.getItemStack().getItem() == this) {
            Level level = evt.getLevel();
            BlockState state = level.getBlockState(evt.getPos());
            if (!this.isEnabled(evt.getItemStack()) && state.getBlock() == Blocks.CAULDRON) {
                this.fillCauldron(evt, level);
            } else if (this.isEnabled(evt.getItemStack()) && state.getBlock() == Blocks.WATER_CAULDRON && ((LayeredCauldronBlock)state.getBlock()).isFull(state)) {
                this.emptyCauldron(evt, level);
            }
        }
    }

    private void emptyCauldron(PlayerInteractEvent.RightClickBlock evt, Level level) {
        level.setBlockAndUpdate(evt.getPos(), Blocks.CAULDRON.defaultBlockState());
        this.cancelEvent(evt);
    }

    private void fillCauldron(PlayerInteractEvent.RightClickBlock evt, Level level) {
        level.setBlockAndUpdate(evt.getPos(), (BlockState)Blocks.WATER_CAULDRON.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(3)));
        this.cancelEvent(evt);
    }

    private void cancelEvent(PlayerInteractEvent.RightClickBlock evt) {
        evt.setUseItem(TriState.FALSE);
        evt.setCanceled(true);
        evt.setCancellationResult(InteractionResult.SUCCESS);
    }
}

