/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import reliquary.init.ModDataComponents;
import reliquary.items.ToggleableItem;
import reliquary.reference.Config;
import reliquary.util.RandHelper;
import reliquary.util.TooltipBuilder;

public class DestructionCatalystItem
extends ToggleableItem {
    public DestructionCatalystItem() {
        super(new Item.Properties().stacksTo(1).setNoRepair());
    }

    @Override
    protected void addMoreInformation(ItemStack catalyst, @Nullable HolderLookup.Provider registries, TooltipBuilder tooltipBuilder) {
        tooltipBuilder.charge(this, ".tooltip2", DestructionCatalystItem.getGunpowder(catalyst));
        if (this.isEnabled(catalyst)) {
            tooltipBuilder.absorbActive(Items.GUNPOWDER.getName(new ItemStack((ItemLike)Items.GUNPOWDER)).getString());
        } else {
            tooltipBuilder.absorb();
        }
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    public InteractionResult useOn(UseOnContext itemUseContext) {
        Player player = itemUseContext.getPlayer();
        if (player != null && player.isCrouching()) {
            return InteractionResult.PASS;
        }
        ItemStack stack = itemUseContext.getItemInHand();
        if (DestructionCatalystItem.getGunpowder(stack) >= this.gunpowderCost() || player != null && player.isCreative()) {
            if (this.doExplosion(itemUseContext.getLevel(), itemUseContext.getClickedPos(), itemUseContext.getClickedFace()) && player != null && !player.isCreative()) {
                this.setGunpowder(stack, DestructionCatalystItem.getGunpowder(stack) - this.gunpowderCost());
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void inventoryTick(ItemStack catalyst, Level level, Entity entity, int itemSlot, boolean isSelected) {
        Player player;
        if (level.isClientSide || !(entity instanceof Player) || (player = (Player)entity).isSpectator() || level.getGameTime() % 10L != 0L) {
            return;
        }
        if (this.isEnabled(catalyst)) {
            int gunpowderCharge = DestructionCatalystItem.getGunpowder(catalyst);
            this.consumeAndCharge(player, this.gunpowderLimit() - gunpowderCharge, this.gunpowderWorth(), Items.GUNPOWDER, 16, (int chargeToAdd) -> this.setGunpowder(catalyst, gunpowderCharge + chargeToAdd));
        }
    }

    public static int getGunpowder(ItemStack catalyst) {
        return (Integer)catalyst.getOrDefault(ModDataComponents.GUNPOWDER, (Object)0);
    }

    private void setGunpowder(ItemStack catalyst, int gunpowder) {
        catalyst.set(ModDataComponents.GUNPOWDER, (Object)gunpowder);
    }

    private int getExplosionRadius() {
        return (Integer)Config.COMMON.items.destructionCatalyst.explosionRadius.get();
    }

    private boolean perfectCube() {
        return (Boolean)Config.COMMON.items.destructionCatalyst.perfectCube.get();
    }

    private boolean doExplosion(Level level, BlockPos pos, Direction direction) {
        boolean destroyedSomething = false;
        boolean playOnce = true;
        BlockPos origin = pos;
        if (Boolean.FALSE.equals(Config.COMMON.items.destructionCatalyst.centeredExplosion.get())) {
            origin = pos.relative(direction.getOpposite(), this.getExplosionRadius());
        }
        for (BlockPos target : BlockPos.betweenClosed((BlockPos)origin.offset(-this.getExplosionRadius(), -this.getExplosionRadius(), -this.getExplosionRadius()), (BlockPos)origin.offset(this.getExplosionRadius(), this.getExplosionRadius(), this.getExplosionRadius()))) {
            double distance;
            if (!this.perfectCube() && (distance = origin.distSqr((Vec3i)target)) >= (double)this.getExplosionRadius() || !this.isBreakable(BuiltInRegistries.BLOCK.getKey((Object)level.getBlockState(target).getBlock()).toString())) continue;
            level.setBlockAndUpdate(target, Blocks.AIR.defaultBlockState());
            if (level.random.nextInt(2) == 0) {
                level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, (double)((float)target.getX() + (level.random.nextFloat() - 0.5f)), (double)((float)target.getY() + (level.random.nextFloat() - 0.5f)), (double)((float)target.getZ() + (level.random.nextFloat() - 0.5f)), 0.0, 0.0, 0.0);
            }
            destroyedSomething = true;
            if (!playOnce) continue;
            level.playSound(null, target, (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.BLOCKS, 4.0f, (1.0f + RandHelper.getRandomMinusOneToOne(level.random) * 0.2f) * 0.7f);
            playOnce = false;
        }
        return destroyedSomething;
    }

    private boolean isBreakable(String id) {
        return ((List)Config.COMMON.items.destructionCatalyst.mundaneBlocks.get()).contains(id);
    }

    private int gunpowderCost() {
        return (Integer)Config.COMMON.items.destructionCatalyst.gunpowderCost.get();
    }

    private int gunpowderWorth() {
        return (Integer)Config.COMMON.items.destructionCatalyst.gunpowderWorth.get();
    }

    private int gunpowderLimit() {
        return (Integer)Config.COMMON.items.destructionCatalyst.gunpowderLimit.get();
    }
}

