/*
 * Decompiled with CFR 0.152.
 */
package reliquary.entities.shot;

import net.minecraft.core.Direction;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import reliquary.entities.ConcussiveExplosion;
import reliquary.entities.shot.ShotBase;
import reliquary.init.ModEntities;
import reliquary.reference.ClientReference;

public class SandShot
extends ShotBase {
    public SandShot(EntityType<SandShot> entityType, Level level) {
        super(entityType, level);
    }

    public SandShot(Level level, Player player, InteractionHand hand) {
        super(ModEntities.SAND_SHOT.get(), level, player, hand);
    }

    @Override
    void doFiringEffects() {
        this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)0.5f, (float)0.5f, (float)0.5f), this.getX() + this.smallGauss(0.1), this.getY() + this.smallGauss(0.1), this.getZ() + this.smallGauss(0.1), 0.0, 0.0, 0.0);
        this.spawnMotionBasedParticle((ParticleOptions)ParticleTypes.FLAME);
    }

    @Override
    void doFlightEffects() {
        if (this.ticksInAir % 3 == 0) {
            this.spawnHitParticles(1);
        }
    }

    @Override
    void doBurstEffect(Direction sideHit) {
        this.spawnHitParticles(8);
    }

    @Override
    void spawnHitParticles(int i) {
        for (int particles = 0; particles < i; ++particles) {
            this.level().addParticle((ParticleOptions)DustParticleOptions.REDSTONE, this.getX(), this.getY(), this.getZ(), (double)0.7f, (double)0.7f, (double)0.3f);
        }
    }

    @Override
    int getDamageOfShot(LivingEntity e) {
        if (e instanceof Creeper) {
            ConcussiveExplosion.customBusterExplosion((Entity)this, this.getX(), this.getY(), this.getZ(), 2.0f);
            this.getShooterPlayer().ifPresent(player -> e.hurt(this.damageSources().playerAttack(player), 20.0f));
            return 0;
        }
        if (e instanceof Mob) {
            e.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 200, 1));
        }
        return (this.level().getLevelData().isRaining() ? 4 : 8) + this.d6();
    }

    @Override
    int getRicochetMax() {
        return 0;
    }

    @Override
    public ResourceLocation getShotTexture() {
        return ClientReference.SAND;
    }
}

