/*
 * Decompiled with CFR 0.152.
 */
package reliquary.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.GlobalLootModifierProvider;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import net.neoforged.neoforge.common.loot.LootTableIdCondition;
import reliquary.data.ChestLootEnabledCondition;
import reliquary.data.ChestLootInjectSubProvider;
import reliquary.data.EntityLootEnabledCondition;
import reliquary.data.EntityLootInjectSubProvider;
import reliquary.init.ModItems;

public class ReliquaryLootModifierProvider
extends GlobalLootModifierProvider {
    ReliquaryLootModifierProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries) {
        super(packOutput, registries, "reliquary");
    }

    protected void start() {
        ChestLootInjectSubProvider.LOOT_INJECTS.forEach((vanillaLootTable, injectLootTable) -> this.add(vanillaLootTable.location().getPath(), (IGlobalLootModifier)InjectLootModifier.chest((ResourceKey<LootTable>)injectLootTable, (ResourceKey<LootTable>)vanillaLootTable), new ICondition[0]));
        EntityLootInjectSubProvider.LOOT_INJECTS.forEach((vanillaLootTable, injectLootTable) -> this.add(vanillaLootTable.location().getPath(), (IGlobalLootModifier)InjectLootModifier.entity((ResourceKey<LootTable>)injectLootTable, (ResourceKey<LootTable>)vanillaLootTable), new ICondition[0]));
    }

    public static class InjectLootModifier
    extends LootModifier {
        public static final MapCodec<InjectLootModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).fieldOf("loot_table").forGetter(m -> m.lootTable), (App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).fieldOf("loot_table_to_inject_into").forGetter(m -> m.lootTableToInjectInto))).apply((Applicative)inst, InjectLootModifier::new));
        private final ResourceKey<LootTable> lootTable;
        private final ResourceKey<LootTable> lootTableToInjectInto;

        protected InjectLootModifier(LootItemCondition[] conditions, ResourceKey<LootTable> lootTable, ResourceKey<LootTable> lootTableToInjectInto) {
            super(conditions);
            this.lootTable = lootTable;
            this.lootTableToInjectInto = lootTableToInjectInto;
        }

        protected static InjectLootModifier chest(ResourceKey<LootTable> lootTable, ResourceKey<LootTable> lootTableToInjectInto) {
            return new InjectLootModifier(new LootItemCondition[]{ChestLootEnabledCondition.builder().build(), LootTableIdCondition.builder((ResourceLocation)lootTableToInjectInto.location()).build()}, lootTable, lootTableToInjectInto);
        }

        protected static InjectLootModifier entity(ResourceKey<LootTable> lootTable, ResourceKey<LootTable> lootTableToInjectInto) {
            return new InjectLootModifier(new LootItemCondition[]{EntityLootEnabledCondition.builder().build(), LootTableIdCondition.builder((ResourceLocation)lootTableToInjectInto.location()).build()}, lootTable, lootTableToInjectInto);
        }

        protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            context.getResolver().get(Registries.LOOT_TABLE, this.lootTable).ifPresent(extraTable -> ((LootTable)extraTable.value()).getRandomItemsRaw(context, LootTable.createStackSplitter((ServerLevel)context.getLevel(), arg_0 -> ((ObjectArrayList)generatedLoot).add(arg_0))));
            return generatedLoot;
        }

        public MapCodec<? extends IGlobalLootModifier> codec() {
            return ModItems.INJECT_LOOT.get();
        }
    }
}

