/*
 * Decompiled with CFR 0.152.
 */
package reliquary.data;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithEnchantedBonusCondition;
import reliquary.Reliquary;
import reliquary.data.LootItemRandomChanceWithSeveringBonusCondition;
import reliquary.init.ModItems;

public class EntityLootInjectSubProvider
implements LootTableSubProvider {
    private static final String INJECT_FOLDER = "inject/";
    protected static final Map<ResourceKey<LootTable>, ResourceKey<LootTable>> LOOT_INJECTS = new HashMap<ResourceKey<LootTable>, ResourceKey<LootTable>>();
    public static final ResourceKey<LootTable> BAT = EntityLootInjectSubProvider.createInjectLootTableRegistryKey((ResourceKey<LootTable>)EntityType.BAT.getDefaultLootTable());
    public static final ResourceKey<LootTable> BLAZE = EntityLootInjectSubProvider.createInjectLootTableRegistryKey((ResourceKey<LootTable>)EntityType.BLAZE.getDefaultLootTable());
    public static final ResourceKey<LootTable> CAVE_SPIDER = EntityLootInjectSubProvider.createInjectLootTableRegistryKey((ResourceKey<LootTable>)EntityType.CAVE_SPIDER.getDefaultLootTable());
    public static final ResourceKey<LootTable> CREEPER = EntityLootInjectSubProvider.createInjectLootTableRegistryKey((ResourceKey<LootTable>)EntityType.CREEPER.getDefaultLootTable());
    public static final ResourceKey<LootTable> ENDERMAN = EntityLootInjectSubProvider.createInjectLootTableRegistryKey((ResourceKey<LootTable>)EntityType.ENDERMAN.getDefaultLootTable());
    public static final ResourceKey<LootTable> GHAST = EntityLootInjectSubProvider.createInjectLootTableRegistryKey((ResourceKey<LootTable>)EntityType.GHAST.getDefaultLootTable());
    public static final ResourceKey<LootTable> GUARDIAN = EntityLootInjectSubProvider.createInjectLootTableRegistryKey((ResourceKey<LootTable>)EntityType.GUARDIAN.getDefaultLootTable());
    public static final ResourceKey<LootTable> HUSK = EntityLootInjectSubProvider.createInjectLootTableRegistryKey((ResourceKey<LootTable>)EntityType.HUSK.getDefaultLootTable());
    public static final ResourceKey<LootTable> MAGMA_CUBE = EntityLootInjectSubProvider.createInjectLootTableRegistryKey((ResourceKey<LootTable>)EntityType.MAGMA_CUBE.getDefaultLootTable());
    public static final ResourceKey<LootTable> SKELETON = EntityLootInjectSubProvider.createInjectLootTableRegistryKey((ResourceKey<LootTable>)EntityType.SKELETON.getDefaultLootTable());
    public static final ResourceKey<LootTable> SNOW_GOLEM = EntityLootInjectSubProvider.createInjectLootTableRegistryKey((ResourceKey<LootTable>)EntityType.SNOW_GOLEM.getDefaultLootTable());
    public static final ResourceKey<LootTable> SLIME = EntityLootInjectSubProvider.createInjectLootTableRegistryKey((ResourceKey<LootTable>)EntityType.SLIME.getDefaultLootTable());
    public static final ResourceKey<LootTable> SPIDER = EntityLootInjectSubProvider.createInjectLootTableRegistryKey((ResourceKey<LootTable>)EntityType.SPIDER.getDefaultLootTable());
    public static final ResourceKey<LootTable> SQUID = EntityLootInjectSubProvider.createInjectLootTableRegistryKey((ResourceKey<LootTable>)EntityType.SQUID.getDefaultLootTable());
    public static final ResourceKey<LootTable> STRAY = EntityLootInjectSubProvider.createInjectLootTableRegistryKey((ResourceKey<LootTable>)EntityType.STRAY.getDefaultLootTable());
    public static final ResourceKey<LootTable> WITCH = EntityLootInjectSubProvider.createInjectLootTableRegistryKey((ResourceKey<LootTable>)EntityType.WITCH.getDefaultLootTable());
    public static final ResourceKey<LootTable> WITHER_SKELETON = EntityLootInjectSubProvider.createInjectLootTableRegistryKey((ResourceKey<LootTable>)EntityType.WITHER_SKELETON.getDefaultLootTable());
    public static final ResourceKey<LootTable> ZOMBIE = EntityLootInjectSubProvider.createInjectLootTableRegistryKey((ResourceKey<LootTable>)EntityType.ZOMBIE.getDefaultLootTable());
    public static final ResourceKey<LootTable> ZOMBIE_VILLAGER = EntityLootInjectSubProvider.createInjectLootTableRegistryKey((ResourceKey<LootTable>)EntityType.ZOMBIE_VILLAGER.getDefaultLootTable());
    public static final ResourceKey<LootTable> ZOMBIFIED_PIGLIN = EntityLootInjectSubProvider.createInjectLootTableRegistryKey((ResourceKey<LootTable>)EntityType.ZOMBIFIED_PIGLIN.getDefaultLootTable());
    private final HolderLookup.Provider registries;

    private static ResourceKey<LootTable> createInjectLootTableRegistryKey(ResourceKey<LootTable> vanillaLootTable) {
        ResourceLocation location = Reliquary.getRL(INJECT_FOLDER + vanillaLootTable.location().getPath());
        ResourceKey injectLootTable = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)location);
        LOOT_INJECTS.put(vanillaLootTable, (ResourceKey<LootTable>)injectLootTable);
        return injectLootTable;
    }

    public EntityLootInjectSubProvider(HolderLookup.Provider registries) {
        this.registries = registries;
    }

    public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> tables) {
        tables.accept(BAT, this.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry(ModItems.BAT_WING.get(), 1), new LootItemCondition.Builder[0]));
        tables.accept(BLAZE, this.getEntityLootTable(0.03f, 0.04f, 0.12f, this.getItemLootEntry(ModItems.MOLTEN_CORE.get(), 1), new LootItemCondition.Builder[0]));
        tables.accept(CAVE_SPIDER, this.getEntityLootTable(0.03f, 0.04f, 0.12f, this.getItemLootEntry(ModItems.CHELICERAE.get(), 1), new LootItemCondition.Builder[0]));
        CompoundTag poweredTag = new CompoundTag();
        poweredTag.putBoolean("powered", true);
        tables.accept(CREEPER, this.addLootPools(this.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry(ModItems.CATALYZING_GLAND.get(), 1), new LootItemCondition.Builder[0]), "reliquary_powered_creeper_", 0.03f, 0.05f, 0.15f, this.getItemLootEntry(ModItems.EYE_OF_THE_STORM.get(), 1), LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)new EntityPredicate.Builder().nbt(new NbtPredicate(poweredTag)))));
        tables.accept(ENDERMAN, this.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry(ModItems.NEBULOUS_HEART.get(), 1), new LootItemCondition.Builder[0]));
        tables.accept(GHAST, this.getEntityLootTable(0.03f, 0.04f, 0.12f, this.getItemLootEntry(ModItems.CATALYZING_GLAND.get(), 1), new LootItemCondition.Builder[0]));
        tables.accept(GUARDIAN, this.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry(ModItems.GUARDIAN_SPIKE.get(), 1), new LootItemCondition.Builder[0]));
        tables.accept(HUSK, this.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry(ModItems.ZOMBIE_HEART.get(), 1), new LootItemCondition.Builder[0]));
        tables.accept(MAGMA_CUBE, this.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry(ModItems.MOLTEN_CORE.get(), 1), new LootItemCondition.Builder[0]));
        tables.accept(SKELETON, this.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry(ModItems.RIB_BONE.get(), 1), new LootItemCondition.Builder[0]));
        tables.accept(SLIME, this.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry(ModItems.SLIME_PEARL.get(), 1), new LootItemCondition.Builder[0]));
        tables.accept(SNOW_GOLEM, this.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry(ModItems.FROZEN_CORE.get(), 1), new LootItemCondition.Builder[0]));
        tables.accept(SPIDER, this.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry(ModItems.CHELICERAE.get(), 1), new LootItemCondition.Builder[0]));
        tables.accept(SQUID, this.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry(ModItems.SQUID_BEAK.get(), 1), new LootItemCondition.Builder[0]));
        tables.accept(STRAY, this.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry(ModItems.RIB_BONE.get(), 1), new LootItemCondition.Builder[0]));
        tables.accept(WITCH, this.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry((Item)ModItems.WITCH_HAT.get(), 1), new LootItemCondition.Builder[0]));
        tables.accept(WITHER_SKELETON, this.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry(ModItems.WITHERED_RIB.get(), 1), new LootItemCondition.Builder[0]));
        tables.accept(ZOMBIE, this.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry(ModItems.ZOMBIE_HEART.get(), 1), new LootItemCondition.Builder[0]));
        tables.accept(ZOMBIE_VILLAGER, this.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry(ModItems.ZOMBIE_HEART.get(), 1), new LootItemCondition.Builder[0]));
        tables.accept(ZOMBIFIED_PIGLIN, this.getEntityLootTable(0.03f, 0.04f, 0.12f, this.getItemLootEntry(ModItems.ZOMBIE_HEART.get(), 1), new LootItemCondition.Builder[0]));
    }

    private LootPoolEntryContainer.Builder<?> getItemLootEntry(Item item, int weight) {
        return LootItem.lootTableItem((ItemLike)item).setWeight(weight);
    }

    private LootTable.Builder getEntityLootTable(float baseChance, float perLevelLooting, float perLevelSevering, LootPoolEntryContainer.Builder<?> entry, LootItemCondition.Builder ... extraConditions) {
        LootTable.Builder lootTableBuilder = LootTable.lootTable();
        return this.addLootPools(lootTableBuilder, "reliquary_", baseChance, perLevelLooting, perLevelSevering, entry, extraConditions);
    }

    private LootTable.Builder addLootPools(LootTable.Builder lootTableBuilder, String lootPoolPrefix, float baseChance, float perLevelLooting, float perLevelSevering, LootPoolEntryContainer.Builder<?> entry, LootItemCondition.Builder ... extraConditions) {
        LootPool.Builder lootingPool = LootPool.lootPool().name(lootPoolPrefix + "looting");
        lootingPool.add(entry);
        lootingPool.when(LootItemKilledByPlayerCondition.killedByPlayer());
        lootingPool.when(LootItemRandomChanceWithEnchantedBonusCondition.randomChanceAndLootingBoost((HolderLookup.Provider)this.registries, (float)baseChance, (float)perLevelLooting));
        for (LootItemCondition.Builder extraCondition : extraConditions) {
            lootingPool.when(extraCondition);
        }
        LootPool.Builder severingPool = LootPool.lootPool().name(lootPoolPrefix + "severing");
        severingPool.add(entry);
        severingPool.when(LootItemKilledByPlayerCondition.killedByPlayer());
        severingPool.when(LootItemRandomChanceWithSeveringBonusCondition.randomChanceAndSeveringBoost(this.registries, baseChance, perLevelSevering));
        for (LootItemCondition.Builder extraCondition : extraConditions) {
            severingPool.when(extraCondition);
        }
        return lootTableBuilder.withPool(lootingPool).withPool(severingPool);
    }
}

