/*
 * Decompiled with CFR 0.152.
 */
package reliquary.crafting;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import reliquary.crafting.FragmentToSpawnEggRecipe;

public class SpawnEggRecipeBuilder {
    private final NonNullList<Ingredient> ingredients = NonNullList.create();
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    private SpawnEggRecipeBuilder() {
    }

    public static SpawnEggRecipeBuilder spawnEggRecipe() {
        return new SpawnEggRecipeBuilder();
    }

    public SpawnEggRecipeBuilder addIngredient(ItemLike itemProvider) {
        this.ingredients.add((Object)Ingredient.of((ItemLike[])new ItemLike[]{itemProvider}));
        return this;
    }

    public SpawnEggRecipeBuilder unlockedBy(String name, Criterion<?> criterionIn) {
        this.criteria.put(name, criterionIn);
        return this;
    }

    public void build(RecipeOutput recipeOutput, ResourceLocation id) {
        this.ensureValid(id);
        Advancement.Builder advancementBuilder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancementBuilder).addCriterion(arg_0, arg_1));
        recipeOutput.accept(id, (Recipe)new FragmentToSpawnEggRecipe(new ShapelessRecipe("", CraftingBookCategory.MISC, new ItemStack((ItemLike)Items.CHICKEN_SPAWN_EGG), this.ingredients)), advancementBuilder.build(id.withPrefix("recipes/")));
    }

    private void ensureValid(ResourceLocation id) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(id));
        }
    }
}

