/*
 * Decompiled with CFR 0.152.
 */
package reliquary.common.gui;

import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import reliquary.init.ModItems;

class SlotMobCharm
extends Slot {
    private static final Container emptyInventory = new SimpleContainer(new ItemStack[0]);
    private final ItemStack belt;

    SlotMobCharm(ItemStack belt, int index) {
        super(emptyInventory, index, -999, 0);
        this.belt = belt;
    }

    public ItemStack getItem() {
        return ModItems.MOB_CHARM_BELT.get().getMobCharmInSlot(this.belt, this.getSlotIndex());
    }

    public void set(ItemStack stack) {
        ModItems.MOB_CHARM_BELT.get().putMobCharmInSlot(this.belt, this.getSlotIndex(), stack);
    }

    public void onQuickCraft(ItemStack newStack, ItemStack originalStack) {
    }

    public int getMaxStackSize() {
        return 1;
    }

    public ItemStack remove(int amount) {
        if (amount > 1) {
            return ItemStack.EMPTY;
        }
        return ModItems.MOB_CHARM_BELT.get().removeMobCharmInSlot(this.belt, this.getSlotIndex());
    }

    public boolean mayPlace(ItemStack stack) {
        return stack.getItem() == ModItems.MOB_CHARM.get();
    }

    public boolean isSameInventory(Slot other) {
        SlotMobCharm slotMobCharm;
        return other instanceof SlotMobCharm && (slotMobCharm = (SlotMobCharm)other).getBelt() == this.belt;
    }

    private ItemStack getBelt() {
        return this.belt;
    }
}

