/*
 * Decompiled with CFR 0.152.
 */
package reliquary.client.gui.components;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import reliquary.client.gui.components.Component;

public class ItemStackPane
extends Component {
    private ItemStack itemStack;
    private final boolean renderOverlay;

    public ItemStackPane(Item item) {
        this(new ItemStack((ItemLike)item));
    }

    public ItemStackPane(ItemStack itemStack) {
        this(itemStack, false);
    }

    public ItemStackPane(ItemStack itemStack, boolean renderOverlay) {
        this.itemStack = itemStack;
        this.renderOverlay = renderOverlay;
    }

    public void setItem(Item item) {
        this.itemStack = new ItemStack((ItemLike)item);
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    @Override
    public int getHeightInternal() {
        return 16;
    }

    @Override
    public int getWidthInternal() {
        return 16;
    }

    @Override
    public void renderInternal(GuiGraphics guiGraphics, int x, int y) {
        if (this.itemStack.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        guiGraphics.renderItem(this.itemStack, x, y);
        if (this.renderOverlay) {
            guiGraphics.renderItemDecorations(mc.font, this.itemStack, x, y, null);
        }
    }
}

