/*
 * Decompiled with CFR 0.152.
 */
package reliquary.blocks.tile;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.IItemHandler;
import reliquary.api.IPedestal;
import reliquary.api.IPedestalActionItem;
import reliquary.api.IPedestalRedstoneItem;
import reliquary.api.IPedestalRedstoneItemWrapper;
import reliquary.blocks.PedestalBlock;
import reliquary.blocks.tile.PassivePedestalBlockEntity;
import reliquary.blocks.tile.PedestalFluidHandler;
import reliquary.init.ModBlocks;
import reliquary.pedestal.PedestalRegistry;
import reliquary.util.CombinedItemHandler;
import reliquary.util.FakePlayerFactory;
import reliquary.util.InventoryHelper;

public class PedestalBlockEntity
extends PassivePedestalBlockEntity
implements IPedestal {
    private boolean tickable = false;
    private int actionCooldown = 0;
    @Nullable
    private IPedestalActionItem actionItem = null;
    @Nullable
    private IPedestalRedstoneItem redstoneItem = null;
    @Nullable
    private IItemHandler itemHandler = null;
    @Nullable
    private IItemHandler combinedHandler = null;
    private ItemStack fluidContainer = ItemStack.EMPTY;
    private boolean switchedOn = false;
    private final List<Long> onSwitches = new ArrayList<Long>();
    private boolean enabledInitialized = false;
    private boolean powered = false;
    private PedestalFluidHandler pedestalFluidHandler = null;
    private Object itemData = null;

    public PedestalBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.PEDESTAL_TILE_TYPE.get(), pos, state);
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.switchedOn = tag.getBoolean("SwitchedOn");
        this.powered = tag.getBoolean("Powered");
        ListTag onLocations = tag.getList("OnSwitches", 4);
        this.onSwitches.clear();
        for (Tag onLocation : onLocations) {
            this.onSwitches.add(((LongTag)onLocation).getAsLong());
        }
        this.updateSpecialItems();
    }

    @Override
    public void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putBoolean("SwitchedOn", this.switchedOn);
        compound.putBoolean("Powered", this.powered);
        ListTag onLocations = new ListTag();
        for (Long onSwitch : this.onSwitches) {
            onLocations.add((Object)LongTag.valueOf((long)onSwitch));
        }
        compound.put("OnSwitches", (Tag)onLocations);
    }

    public void onChunkUnloaded() {
        if (this.level != null && !this.level.isClientSide) {
            PedestalRegistry.unregisterPosition(this.level.dimension().registry(), this.worldPosition);
        }
        super.onChunkUnloaded();
    }

    public void onLoad() {
        if (this.level != null && !this.level.isClientSide) {
            PedestalRegistry.registerPosition(this.level.dimension().registry(), this.worldPosition);
        }
        super.onLoad();
    }

    @Override
    public IItemHandler getItemHandler() {
        IItemHandler superInventory = super.getItemHandler();
        if (this.itemHandler == null) {
            return superInventory;
        }
        if (this.combinedHandler == null) {
            this.combinedHandler = new CombinedItemHandler(superInventory, this.itemHandler);
        }
        return this.combinedHandler;
    }

    public IFluidHandler getFluidHandler() {
        if (this.pedestalFluidHandler == null) {
            this.pedestalFluidHandler = new PedestalFluidHandler(this);
        }
        return this.pedestalFluidHandler;
    }

    public void executeOnActionItem(Consumer<IPedestalActionItem> execute) {
        if (this.actionItem == null) {
            return;
        }
        execute.accept(this.actionItem);
    }

    private void executeOnRedstoneItem(Consumer<IPedestalRedstoneItem> execute) {
        if (this.redstoneItem == null) {
            return;
        }
        execute.accept(this.redstoneItem);
    }

    private void updateSpecialItems() {
        Item item;
        this.resetSpecialItems();
        if (this.item.isEmpty()) {
            return;
        }
        IItemHandler ih = (IItemHandler)this.item.getCapability(Capabilities.ItemHandler.ITEM);
        if (ih != null) {
            this.itemHandler = ih;
        }
        if ((item = this.item.getItem()) instanceof IPedestalActionItem) {
            IPedestalActionItem pedestalActionItem = (IPedestalActionItem)item;
            this.tickable = true;
            this.actionItem = pedestalActionItem;
        } else {
            item = this.item.getItem();
            if (item instanceof IPedestalRedstoneItem) {
                IPedestalRedstoneItem pedestalRedstoneItem;
                this.redstoneItem = pedestalRedstoneItem = (IPedestalRedstoneItem)item;
            } else {
                PedestalRegistry.getItemWrapper(this.item).ifPresent(wrapper -> {
                    if (wrapper instanceof IPedestalActionItem) {
                        IPedestalActionItem pedestalActionItem = (IPedestalActionItem)((Object)wrapper);
                        this.tickable = true;
                        this.actionItem = pedestalActionItem;
                    }
                    if (wrapper instanceof IPedestalRedstoneItemWrapper) {
                        this.redstoneItem = (IPedestalRedstoneItem)((Object)wrapper);
                    }
                });
            }
        }
        IFluidHandlerItem itemFluidHandler = (IFluidHandlerItem)this.item.getCapability(Capabilities.FluidHandler.ITEM);
        if (itemFluidHandler != null) {
            this.fluidContainer = this.item;
        }
        this.actionCooldown = 0;
    }

    private void resetSpecialItems() {
        this.tickable = false;
        this.fluidContainer = ItemStack.EMPTY;
        this.actionItem = null;
        this.redstoneItem = null;
        this.itemHandler = null;
        if (this.combinedHandler != null) {
            this.level.invalidateCapabilities(this.getBlockPos());
        }
        this.combinedHandler = null;
    }

    public void serverTick(Level level) {
        if (level.isClientSide) {
            return;
        }
        if (!this.enabledInitialized) {
            this.enabledInitialized = true;
            this.neighborUpdate(level);
        }
        if (this.tickable && this.isEnabled()) {
            if (this.actionCooldown > 0) {
                --this.actionCooldown;
            } else {
                this.executeOnActionItem(ai -> ai.update(this.item, level, this));
            }
        }
    }

    public void neighborUpdate(Level level) {
        if (this.powered != level.hasNeighborSignal(this.worldPosition)) {
            this.powered = level.hasNeighborSignal(this.worldPosition);
            if (this.powered) {
                this.switchOn(level, BlockPos.ZERO);
            } else {
                this.switchOff(level, BlockPos.ZERO);
            }
        }
        this.updateRedstone(level);
    }

    public void updateRedstone(Level level) {
        this.executeOnRedstoneItem(ri -> ri.updateRedstone(this.item, level, this));
    }

    @Override
    public BlockPos getBlockPosition() {
        return this.getBlockPos();
    }

    @Override
    public int addToConnectedInventory(Level level, ItemStack stack) {
        int numberAdded = 0;
        for (Direction side : Direction.values()) {
            if ((numberAdded += InventoryHelper.tryToAddToInventoryAtPos(stack, level, this.worldPosition.offset(side.getNormal()), side.getOpposite(), stack.getCount() - numberAdded)) >= stack.getCount()) break;
        }
        return numberAdded;
    }

    @Override
    public int fillConnectedTank(FluidStack fluidStack, IFluidHandler.FluidAction action) {
        List<IFluidHandler> adjacentTanks = this.getAdjacentTanks();
        int fluidFilled = 0;
        FluidStack copy = fluidStack.copy();
        for (IFluidHandler tank : adjacentTanks) {
            if (tank.fill(copy, IFluidHandler.FluidAction.SIMULATE) != copy.getAmount()) continue;
            if ((fluidFilled += tank.fill(copy, action)) >= fluidStack.getAmount()) break;
            copy.setAmount(fluidStack.getAmount() - fluidFilled);
        }
        return fluidFilled;
    }

    @Override
    public int fillConnectedTank(FluidStack fluidStack) {
        return this.fillConnectedTank(fluidStack, IFluidHandler.FluidAction.EXECUTE);
    }

    @Override
    public void setActionCoolDown(int coolDownTicks) {
        this.actionCooldown = coolDownTicks;
    }

    @Override
    public Optional<FakePlayer> getFakePlayer() {
        Level level;
        if (this.level == null || !((level = this.level) instanceof ServerLevel)) {
            return Optional.empty();
        }
        ServerLevel serverLevel = (ServerLevel)level;
        return Optional.of(FakePlayerFactory.get(serverLevel));
    }

    @Override
    public void destroyItem() {
        this.setItem(ItemStack.EMPTY);
    }

    @Override
    public void setItem(ItemStack stack) {
        if (this.level == null) {
            return;
        }
        this.removeSpecialItems(this.level);
        this.item = stack;
        this.updateItemsAndBlock();
    }

    @Override
    public void setItem(int slot, ItemStack stack) {
        if (slot == 0) {
            this.setItem(stack);
        }
    }

    @Override
    public List<BlockPos> getPedestalsInRange(Level level, int range) {
        return PedestalRegistry.getPositionsInRange(level.dimension().registry(), this.worldPosition, range);
    }

    @Override
    public void switchOn(Level level, BlockPos switchedOnFrom) {
        if (switchedOnFrom != BlockPos.ZERO && !this.onSwitches.contains(switchedOnFrom.asLong())) {
            this.onSwitches.add(switchedOnFrom.asLong());
        }
        this.setEnabled(level, true);
        BlockState blockState = level.getBlockState(this.worldPosition);
        level.sendBlockUpdated(this.worldPosition, blockState, blockState, 3);
    }

    @Override
    public void switchOff(Level level, BlockPos switchedOffFrom) {
        if (switchedOffFrom != BlockPos.ZERO) {
            this.onSwitches.remove(switchedOffFrom.asLong());
        }
        if (!this.switchedOn && !this.powered && this.onSwitches.isEmpty()) {
            this.setEnabled(level, false);
        }
        BlockState blockState = level.getBlockState(this.worldPosition);
        level.sendBlockUpdated(this.worldPosition, blockState, blockState, 3);
    }

    @Override
    public Optional<Object> getItemData() {
        return Optional.ofNullable(this.itemData);
    }

    @Override
    public void setItemData(@Nullable Object data) {
        this.itemData = data;
    }

    @Override
    public boolean switchedOn() {
        return this.switchedOn;
    }

    public boolean isPowered() {
        return this.powered;
    }

    public List<Long> getOnSwitches() {
        return this.onSwitches;
    }

    private void setEnabled(Level level, boolean switchedOn) {
        if (level.getBlockState(this.worldPosition).getBlock() instanceof PedestalBlock) {
            level.setBlockAndUpdate(this.worldPosition, (BlockState)level.getBlockState(this.worldPosition).setValue((Property)PedestalBlock.ENABLED, (Comparable)Boolean.valueOf(switchedOn)));
            if (!switchedOn) {
                this.executeOnActionItem(ai -> ai.stop(this.item, level, this));
            }
        }
        this.setChanged();
    }

    private List<IFluidHandler> getAdjacentTanks() {
        ArrayList<IFluidHandler> adjacentTanks = new ArrayList<IFluidHandler>();
        for (Direction side : Direction.values()) {
            BlockPos tankPos = this.getBlockPos().offset(side.getNormal());
            Direction tankDirection = side.getOpposite();
            this.addIfTank(adjacentTanks, tankPos, tankDirection);
        }
        return adjacentTanks;
    }

    private void addIfTank(List<IFluidHandler> adjacentTanks, BlockPos tankPos, Direction tankDirection) {
        IFluidHandler fh = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, tankPos, (Object)tankDirection);
        if (fh != null) {
            adjacentTanks.add(fh);
        }
    }

    public void removeSpecialItems(Level level) {
        this.executeOnRedstoneItem(ri -> ri.onRemoved(this.item, level, this));
        this.executeOnActionItem(ai -> ai.onRemoved(this.item, level, this));
    }

    @Override
    public void removeAndSpawnItem(Level level) {
        this.removeSpecialItems(level);
        this.resetSpecialItems();
        super.removeAndSpawnItem(level);
    }

    @Override
    public ItemStack removeItem(int slot, int count) {
        if (slot == 0) {
            return this.decrStack(count);
        }
        return ItemStack.EMPTY;
    }

    private ItemStack decrStack(int count) {
        if (!this.item.isEmpty()) {
            ItemStack stack;
            if (this.item.getCount() > count) {
                stack = this.item.split(count);
            } else {
                stack = this.item;
                if (this.level != null) {
                    this.removeSpecialItems(this.level);
                }
                this.item = ItemStack.EMPTY;
                this.updateItemsAndBlock();
            }
            return stack;
        }
        return ItemStack.EMPTY;
    }

    private void updateItemsAndBlock() {
        this.updateSpecialItems();
        if (this.level == null) {
            return;
        }
        this.updateRedstone(this.level);
        BlockState blockState = this.level.getBlockState(this.getBlockPos());
        this.level.sendBlockUpdated(this.getBlockPos(), blockState, blockState, 3);
    }

    @Override
    public ItemStack removeItemNoUpdate(int slot) {
        if (slot == 0) {
            ItemStack stack = this.item;
            if (this.level != null) {
                this.removeSpecialItems(this.level);
            }
            this.item = ItemStack.EMPTY;
            this.updateItemsAndBlock();
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public void toggleSwitch(Level level) {
        boolean bl = this.switchedOn = !this.switchedOn;
        if (this.switchedOn) {
            this.switchOn(level, BlockPos.ZERO);
        } else {
            this.switchOff(level, BlockPos.ZERO);
        }
        this.updateRedstone(level);
    }

    ItemStack getFluidContainer() {
        return this.fluidContainer;
    }

    public boolean isEnabled() {
        return (Boolean)this.getBlockState().getValue((Property)PedestalBlock.ENABLED);
    }
}

