/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items;

import it.hurts.sskirillss.relics.entities.ThrownRelicExperienceBottle;
import it.hurts.sskirillss.relics.init.EntityRegistry;
import it.hurts.sskirillss.relics.items.ItemBase;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;

public class RelicExperienceBottleItem
extends ItemBase
implements ProjectileItem {
    public RelicExperienceBottleItem() {
        super(new Item.Properties().rarity(Rarity.UNCOMMON));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.EXPERIENCE_BOTTLE_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!level.isClientSide) {
            ThrownRelicExperienceBottle bottle = new ThrownRelicExperienceBottle((EntityType<? extends ThrownRelicExperienceBottle>)((EntityType)EntityRegistry.THROWN_RELIC_EXPERIENCE_BOTTLE.get()), level);
            bottle.setItem(stack);
            bottle.setOwner((Entity)player);
            bottle.setPos(player.getEyePosition());
            bottle.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), -20.0f, 0.7f, 1.0f);
            level.addFreshEntity((Entity)bottle);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public Projectile asProjectile(Level p_338868_, Position p_338766_, ItemStack p_338321_, Direction p_338772_) {
        ThrownRelicExperienceBottle thrownexperiencebottle = new ThrownRelicExperienceBottle((EntityType<? extends ThrownRelicExperienceBottle>)((EntityType)EntityRegistry.THROWN_RELIC_EXPERIENCE_BOTTLE.get()), p_338868_);
        thrownexperiencebottle.setPos(p_338766_.x(), p_338766_.y(), p_338766_.z());
        thrownexperiencebottle.setItem(p_338321_);
        return thrownexperiencebottle;
    }
}

